/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.athena.agiledataecho.config;

import com.mongodb.ConnectionString;
import com.mongodb.MongoClientSettings;
import com.mongodb.client.MongoClient;
import com.mongodb.client.internal.MongoClientImpl;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.data.mongodb.core.MongoTemplate;
import org.springframework.data.mongodb.core.convert.DefaultMongoTypeMapper;
import org.springframework.data.mongodb.core.convert.MappingMongoConverter;
import org.springframework.data.mongodb.core.convert.MongoConverter;
import org.springframework.data.mongodb.core.convert.MongoTypeMapper;

@Configuration
public class MongoTemplateConfig {
    private static final Logger log = LoggerFactory.getLogger(MongoTemplateConfig.class);
    @Value(value="${spring.data.mongodb.url}")
    private String url;
    @Value(value="${spring.data.mongodb.database}")
    private String echoInfoLog;
    @Value(value="${spring.data.mongodb.agileDataPagebase}")
    private String databaseagileDataPage;

    @Bean(value={"mongoTemplate"})
    public MongoTemplate mongoTemplate() {
        MongoClientImpl client = new MongoClientImpl(MongoClientSettings.builder().retryWrites(false).applyConnectionString(new ConnectionString(this.url)).build(), null);
        return new MongoTemplate((MongoClient)client, this.echoInfoLog);
    }

    @Bean(value={"mongoAgileDataPageViewTemplate"})
    public MongoTemplate mongoAgileDataPageViewTemplate() {
        MongoClientImpl client = new MongoClientImpl(MongoClientSettings.builder().retryWrites(false).applyConnectionString(new ConnectionString(this.url)).build(), null);
        MongoTemplate mongoTemplate = new MongoTemplate((MongoClient)client, this.databaseagileDataPage);
        MongoConverter converter = mongoTemplate.getConverter();
        if (converter.getTypeMapper().isTypeKey("_class")) {
            ((MappingMongoConverter)converter).setTypeMapper((MongoTypeMapper)new DefaultMongoTypeMapper(null));
        }
        return mongoTemplate;
    }
}

