/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.athena.agiledataecho.config;

import com.digiwin.athena.appcore.util.SpringUtil;
import com.google.common.eventbus.AsyncEventBus;
import com.google.common.eventbus.Subscribe;
import java.lang.reflect.Method;
import java.util.Set;
import org.reflections.Reflections;
import org.reflections.scanners.MethodAnnotationsScanner;
import org.reflections.scanners.Scanner;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.ApplicationArguments;
import org.springframework.boot.ApplicationRunner;
import org.springframework.stereotype.Component;

@Component
public class RegisterEventOnApplicationRunner
implements ApplicationRunner {
    private static final Logger log = LoggerFactory.getLogger(RegisterEventOnApplicationRunner.class);
    @Autowired
    private AsyncEventBus localEventBus;

    public void run(ApplicationArguments args) {
        Reflections reflections = new Reflections("com.digiwin.athena.agiledataecho", new Scanner[]{new MethodAnnotationsScanner()});
        Set methods = reflections.getMethodsAnnotatedWith(Subscribe.class);
        if (null != methods) {
            for (Method method : methods) {
                try {
                    this.localEventBus.register(SpringUtil.getBean(method.getDeclaringClass()));
                }
                catch (Exception e) {
                    log.error(e.getMessage(), (Throwable)e);
                }
            }
        }
    }
}

