/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.athena.agiledataecho.controller;

import com.digiwin.athena.agiledataecho.service.EchoLiteChargingService;
import com.digiwin.athena.appcore.auth.domain.AuthoredUser;
import com.digiwin.athena.appcore.util.ResponseEntityWrapper;
import java.util.Map;
import org.apache.commons.collections.MapUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestAttribute;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/api/ai/agile/echo/lite"})
public class EchoLiteChargingController {
    @Autowired
    private EchoLiteChargingService echoLiteChargingService;

    @GetMapping(value={"/changeCharging"})
    public ResponseEntity<?> changeCharging(@RequestAttribute(value="digi-middleware-auth-user-data", required=false) AuthoredUser user) {
        return ResponseEntityWrapper.wrapperOk((Object)this.echoLiteChargingService.changeCharging(user, null));
    }

    @PostMapping(value={"/initCharging"})
    public ResponseEntity<?> initCharging(@RequestBody Map<String, Object> params, @RequestAttribute(value="digi-middleware-auth-user-data", required=false) AuthoredUser user) {
        String chargingType = MapUtils.getString(params, (Object)"chargingType");
        Integer chargingNum = MapUtils.getInteger(params, (Object)"chargingNum");
        Integer chargingRemain = MapUtils.getInteger(params, (Object)"chargingRemain");
        this.echoLiteChargingService.initCharging(user, chargingType, chargingNum, chargingRemain);
        return ResponseEntityWrapper.wrapperOk((Object)true);
    }

    @PostMapping(value={"/initChargingRemain"})
    public ResponseEntity<?> initChargingRemain(@RequestBody Map<String, Object> params, @RequestAttribute(value="digi-middleware-auth-user-data", required=false) AuthoredUser user) {
        String userId = MapUtils.getString(params, (Object)"userId");
        String tenantId = MapUtils.getString(params, (Object)"tenantId");
        String chargingType = MapUtils.getString(params, (Object)"chargingType");
        Integer chargingRemain = MapUtils.getInteger(params, (Object)"chargingRemain");
        this.echoLiteChargingService.initChargingRemain(userId, tenantId, chargingRemain, chargingType);
        return ResponseEntityWrapper.wrapperOk((Object)true);
    }
}

