/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.athena.show.component.grid;

import com.digiwin.athena.show.component.AbstractComponent;
import com.digiwin.athena.show.component.AbstractComponentService;
import com.digiwin.athena.show.component.ComponentFormat;
import com.digiwin.athena.show.component.grid.GridColumnDef;
import com.digiwin.athena.show.component.grid.GridComponent;
import com.digiwin.athena.show.component.grid.WidthCalculator;
import com.digiwin.athena.show.domain.BuildContext;
import com.digiwin.athena.show.domain.agileDataDTO.ConvertAgileDataUtils;
import com.digiwin.athena.show.metadata.MetadataField;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.apache.commons.compress.utils.Lists;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;
import org.springframework.util.StringUtils;

@Service(value="gridComponent")
public class GridComponentImpl
extends AbstractComponentService {
    private static final String COMPONENT_TYPE = "TABLE";

    public AbstractComponent initComponent(MetadataField metadataField, BuildContext buildContext) {
        GridComponent gridComponent = new GridComponent();
        if (metadataField == null) {
            return gridComponent;
        }
        List showFields = this.getShowFields(metadataField);
        if (CollectionUtils.isEmpty((Collection)showFields)) {
            return gridComponent;
        }
        gridComponent.setId(buildContext.getThemeMapReport().getActionId());
        gridComponent.setType(COMPONENT_TYPE);
        gridComponent.setTitle(buildContext.getThemeMapReport().getTitle());
        ArrayList columns = Lists.newArrayList();
        WidthCalculator.calColumnWidth((List)showFields, (List)buildContext.getThemeMapReport().getPageData());
        showFields.stream().forEach(field -> {
            GridColumnDef column = new GridColumnDef();
            column.setId(field.getName());
            column.setName(field.getDescription());
            column.setWidth(Integer.valueOf(field.getDisplayWidth()));
            column.setDataType(field.getDataType());
            if (!StringUtils.pathEquals((String)"string", (String)field.getDataType())) {
                ComponentFormat componentFormat = new ComponentFormat();
                componentFormat.setDecimal(field.getDecimal());
                componentFormat.setPercent(field.getPercent());
                componentFormat.setBusinessType(field.getBusinessType());
                componentFormat.setDecimalRule(ConvertAgileDataUtils.getDecimalRule((String)field.getDecimalRule()));
                componentFormat.setUnit(ConvertAgileDataUtils.getUnitRule((String)field.getUnit()));
                column.setFormat(componentFormat);
            }
            columns.add(column);
        });
        gridComponent.setColumns((List)columns);
        gridComponent.setShowData(buildContext.getThemeMapReport().getPageData());
        return gridComponent;
    }

    private List<MetadataField> getShowFields(MetadataField metadataField) {
        ArrayList fields = Lists.newArrayList();
        if (metadataField.isObjectField()) {
            metadataField.getSubFields().forEach(field -> fields.addAll(this.getShowFields(field)));
        } else {
            fields.add(metadataField);
        }
        return fields;
    }
}

