/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.athena.show.controller;

import com.digiwin.athena.appcore.auth.domain.AuthoredUser;
import com.digiwin.athena.appcore.util.ResponseEntityWrapper;
import com.digiwin.athena.show.domain.board.BoardLayoutDTO;
import com.digiwin.athena.show.domain.board.BoardLayoutParamsDTO;
import com.digiwin.athena.show.domain.dynamicLayout.BordDynamicDTO;
import com.digiwin.athena.show.service.DynamicLayoutBoardService;
import javax.servlet.http.HttpServletRequest;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestAttribute;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/api/ai/v1/board/"})
public class DynamicLayoutBoardController {
    @Autowired
    private DynamicLayoutBoardService dynamicLayoutBoardService;

    @PostMapping(value={"dynamicLayout"})
    public ResponseEntity<?> transAgileData(HttpServletRequest request, @RequestAttribute(value="digi-middleware-auth-user-data", required=false) AuthoredUser user, @RequestBody BordDynamicDTO bordDynamicDTO) {
        String locale = request.getHeader("locale");
        return ResponseEntityWrapper.wrapperOk((Object)this.dynamicLayoutBoardService.calcDynamicLayoutBoard(user, bordDynamicDTO, locale));
    }

    @PostMapping(value={"buildBoardPresented"})
    public ResponseEntity<?> generateBoardLayout(HttpServletRequest request, @RequestAttribute(value="digi-middleware-auth-user-data", required=false) AuthoredUser user, @RequestBody BoardLayoutParamsDTO bordDynamicDTO) {
        String locale = request.getHeader("locale");
        return ResponseEntityWrapper.wrapperOk((Object)this.dynamicLayoutBoardService.generateBoardLayout(user, bordDynamicDTO, locale));
    }

    @PostMapping(value={"saveBoardLayout"})
    public ResponseEntity<?> saveBoardLayout(HttpServletRequest request, @RequestAttribute(value="digi-middleware-auth-user-data", required=false) AuthoredUser user, @RequestBody BoardLayoutDTO boardLayout) {
        return ResponseEntityWrapper.wrapperOk((Object)this.dynamicLayoutBoardService.saveDynamicLayoutBoard(user, boardLayout));
    }

    @GetMapping(value={"getBoardLayout"})
    public ResponseEntity<?> getBoardLayout(HttpServletRequest request, @RequestAttribute(value="digi-middleware-auth-user-data", required=false) AuthoredUser user, @RequestParam(value="boardId", required=false) String boardId) {
        return ResponseEntityWrapper.wrapperOk((Object)this.dynamicLayoutBoardService.getDynamicLayoutBoard(user, boardId));
    }
}

