/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.athena.show.domain.agileDataDTO;

import com.digiwin.athena.show.domain.agileDataDTO.AgileDataGridsterArea;
import com.google.common.collect.Lists;
import java.util.Comparator;
import java.util.List;
import java.util.Optional;
import org.apache.commons.lang3.StringUtils;

public class AgileDataGridsterGroup {
    private int width;
    private int height;
    private String direction = "line";
    private List<AgileDataGridsterArea> areas = Lists.newArrayList();

    public void setSize() {
        this.width = 0;
        this.height = 0;
        Optional<AgileDataGridsterArea> maxWidthOptional = this.areas.stream().max(Comparator.comparing(AgileDataGridsterArea::getCols));
        this.areas.stream().forEach(area -> {
            if (StringUtils.equals((CharSequence)"line", (CharSequence)this.direction)) {
                this.width += area.getCols();
                this.height = area.getRows();
            } else {
                this.width = maxWidthOptional.isPresent() ? ((AgileDataGridsterArea)maxWidthOptional.get()).getCols() : area.getCols();
                this.height += area.getRows();
            }
        });
    }

    public void reSize(int arrangeSize, int maxWidthSize) {
        this.areas.stream().forEach(area -> area.reSizeProportion(arrangeSize, maxWidthSize));
        this.setSize();
    }

    public void completionSize(int arrangeSize, int prevGroupWidth, boolean isLast) {
        if (isLast) {
            this.areas.stream().forEach(area -> {
                if (!StringUtils.equals((CharSequence)"STATISTIC", (CharSequence)area.getComponent().getType())) {
                    area.reSize(arrangeSize, prevGroupWidth);
                }
            });
        } else {
            this.areas.stream().forEach(area -> {
                if (!StringUtils.equals((CharSequence)"STATISTIC", (CharSequence)area.getComponent().getType())) {
                    area.reSize(this.width, 0);
                }
            });
        }
        this.setSize();
    }

    public void calcCoordinate(int prevWidth, int prevHeight) {
        for (AgileDataGridsterArea area : this.areas) {
            area.setX(Integer.valueOf(prevWidth));
            area.setY(Integer.valueOf(prevHeight));
            if (!StringUtils.equals((CharSequence)"row", (CharSequence)this.direction)) continue;
            prevHeight += area.getRows();
        }
    }

    public int getWidth() {
        return this.width;
    }

    public int getHeight() {
        return this.height;
    }

    public String getDirection() {
        return this.direction;
    }

    public List<AgileDataGridsterArea> getAreas() {
        return this.areas;
    }

    public void setWidth(int width) {
        this.width = width;
    }

    public void setHeight(int height) {
        this.height = height;
    }

    public void setDirection(String direction) {
        this.direction = direction;
    }

    public void setAreas(List<AgileDataGridsterArea> areas) {
        this.areas = areas;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof AgileDataGridsterGroup)) {
            return false;
        }
        AgileDataGridsterGroup other = (AgileDataGridsterGroup)o;
        if (!other.canEqual((Object)this)) {
            return false;
        }
        if (this.getWidth() != other.getWidth()) {
            return false;
        }
        if (this.getHeight() != other.getHeight()) {
            return false;
        }
        String this$direction = this.getDirection();
        String other$direction = other.getDirection();
        if (this$direction == null ? other$direction != null : !this$direction.equals(other$direction)) {
            return false;
        }
        List this$areas = this.getAreas();
        List other$areas = other.getAreas();
        return !(this$areas == null ? other$areas != null : !((Object)this$areas).equals(other$areas));
    }

    protected boolean canEqual(Object other) {
        return other instanceof AgileDataGridsterGroup;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + this.getWidth();
        result = result * 59 + this.getHeight();
        String $direction = this.getDirection();
        result = result * 59 + ($direction == null ? 43 : $direction.hashCode());
        List $areas = this.getAreas();
        result = result * 59 + ($areas == null ? 43 : ((Object)$areas).hashCode());
        return result;
    }

    public String toString() {
        return "AgileDataGridsterGroup(width=" + this.getWidth() + ", height=" + this.getHeight() + ", direction=" + this.getDirection() + ", areas=" + this.getAreas() + ")";
    }
}

