/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.athena.show.domain.agileDataDTO;

import cn.hutool.core.bean.BeanUtil;
import com.digiwin.athena.show.component.grid.GridColumnDef;
import com.digiwin.athena.show.domain.TagDefinition;
import com.digiwin.athena.show.domain.agileDataDTO.ConvertAgileDataUtils;
import com.digiwin.athena.show.metadata.MetadataField;
import com.fasterxml.jackson.annotation.JsonIgnore;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import org.apache.commons.compress.utils.Lists;
import org.apache.commons.lang3.StringUtils;

public class AgileDataMobileGridColumnDef
extends GridColumnDef {
    private String businessType;
    private String percent;
    private Map<String, Object> decimalRule;
    private Map<String, Object> unit;
    private String schema;
    private List<TagDefinition> tagDefinitions;

    @JsonIgnore
    public void getMobilelGridColumn(MetadataField metadataField, String dataSource, Integer width) {
        this.setHeaderName(metadataField.getDescription());
        this.setPath(dataSource);
        this.setLevel(Integer.valueOf(0));
        this.setSortable(Boolean.valueOf(false));
        this.setFilterable(Boolean.valueOf(false));
        this.setOptions((List)Lists.newArrayList());
        this.setWidth(width);
        AgileDataMobileGridColumnDef columnDef = new AgileDataMobileGridColumnDef();
        columnDef.setType("LABEL");
        columnDef.setSchema(metadataField.getName());
        columnDef.setHeaderName(metadataField.getDescription());
        columnDef.setPath(dataSource);
        columnDef.setLevel(Integer.valueOf(0));
        columnDef.setDataType(metadataField.getDataType());
        columnDef.setRowGroupable(Boolean.valueOf(true));
        columnDef.setWidth(width);
        columnDef.setRelationSchemas(Arrays.asList(metadataField.getName()));
        TagDefinition tagDefinition = new TagDefinition();
        tagDefinition.setCustomize(Boolean.valueOf(false));
        tagDefinition.setAppend(false);
        tagDefinition.setCategory("DATATYPE");
        this.setTagType(metadataField.getDataType(), tagDefinition);
        columnDef.setTagDefinitions(Arrays.asList(tagDefinition));
        columnDef.setPercent(metadataField.getPercent());
        columnDef.setDecimal(metadataField.getDecimal());
        if (StringUtils.isNotEmpty((CharSequence)metadataField.getBusinessType())) {
            columnDef.setBusinessType(metadataField.getBusinessType());
        }
        if (StringUtils.isNotEmpty((CharSequence)metadataField.getDecimalRule())) {
            columnDef.setDecimalRule(BeanUtil.beanToMap((Object)ConvertAgileDataUtils.getDecimalRule((String)metadataField.getDecimalRule()), (String[])new String[0]));
        }
        if (StringUtils.isNotEmpty((CharSequence)metadataField.getUnit())) {
            columnDef.setUnit(BeanUtil.beanToMap((Object)ConvertAgileDataUtils.getUnitRule((String)metadataField.getUnit()), (String[])new String[0]));
        }
        this.setColumns(Arrays.asList(columnDef));
    }

    @JsonIgnore
    private void setTagType(String type, TagDefinition tagDefinition) {
        if (type.equals("string")) {
            tagDefinition.setCode("TYPE_STRING");
            tagDefinition.setInterpreterServiceName("typeStringTagInterpreter");
        }
        if (type.equals("date")) {
            tagDefinition.setCode("TYPE_DATE");
            tagDefinition.setInterpreterServiceName("typeDateTagInterpreter");
        }
        if (type.equals("numeric")) {
            tagDefinition.setCode("TYPE_NUMERIC");
            tagDefinition.setInterpreterServiceName("typeNumericTagInterpreter");
        }
    }

    public String getBusinessType() {
        return this.businessType;
    }

    public String getPercent() {
        return this.percent;
    }

    public Map<String, Object> getDecimalRule() {
        return this.decimalRule;
    }

    public Map<String, Object> getUnit() {
        return this.unit;
    }

    public String getSchema() {
        return this.schema;
    }

    public List<TagDefinition> getTagDefinitions() {
        return this.tagDefinitions;
    }

    public void setBusinessType(String businessType) {
        this.businessType = businessType;
    }

    public void setPercent(String percent) {
        this.percent = percent;
    }

    public void setDecimalRule(Map<String, Object> decimalRule) {
        this.decimalRule = decimalRule;
    }

    public void setUnit(Map<String, Object> unit) {
        this.unit = unit;
    }

    public void setSchema(String schema) {
        this.schema = schema;
    }

    public void setTagDefinitions(List<TagDefinition> tagDefinitions) {
        this.tagDefinitions = tagDefinitions;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof AgileDataMobileGridColumnDef)) {
            return false;
        }
        AgileDataMobileGridColumnDef other = (AgileDataMobileGridColumnDef)o;
        if (!other.canEqual((Object)this)) {
            return false;
        }
        String this$businessType = this.getBusinessType();
        String other$businessType = other.getBusinessType();
        if (this$businessType == null ? other$businessType != null : !this$businessType.equals(other$businessType)) {
            return false;
        }
        String this$percent = this.getPercent();
        String other$percent = other.getPercent();
        if (this$percent == null ? other$percent != null : !this$percent.equals(other$percent)) {
            return false;
        }
        Map this$decimalRule = this.getDecimalRule();
        Map other$decimalRule = other.getDecimalRule();
        if (this$decimalRule == null ? other$decimalRule != null : !((Object)this$decimalRule).equals(other$decimalRule)) {
            return false;
        }
        Map this$unit = this.getUnit();
        Map other$unit = other.getUnit();
        if (this$unit == null ? other$unit != null : !((Object)this$unit).equals(other$unit)) {
            return false;
        }
        String this$schema = this.getSchema();
        String other$schema = other.getSchema();
        if (this$schema == null ? other$schema != null : !this$schema.equals(other$schema)) {
            return false;
        }
        List this$tagDefinitions = this.getTagDefinitions();
        List other$tagDefinitions = other.getTagDefinitions();
        return !(this$tagDefinitions == null ? other$tagDefinitions != null : !((Object)this$tagDefinitions).equals(other$tagDefinitions));
    }

    protected boolean canEqual(Object other) {
        return other instanceof AgileDataMobileGridColumnDef;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $businessType = this.getBusinessType();
        result = result * 59 + ($businessType == null ? 43 : $businessType.hashCode());
        String $percent = this.getPercent();
        result = result * 59 + ($percent == null ? 43 : $percent.hashCode());
        Map $decimalRule = this.getDecimalRule();
        result = result * 59 + ($decimalRule == null ? 43 : ((Object)$decimalRule).hashCode());
        Map $unit = this.getUnit();
        result = result * 59 + ($unit == null ? 43 : ((Object)$unit).hashCode());
        String $schema = this.getSchema();
        result = result * 59 + ($schema == null ? 43 : $schema.hashCode());
        List $tagDefinitions = this.getTagDefinitions();
        result = result * 59 + ($tagDefinitions == null ? 43 : ((Object)$tagDefinitions).hashCode());
        return result;
    }

    public String toString() {
        return "AgileDataMobileGridColumnDef(businessType=" + this.getBusinessType() + ", percent=" + this.getPercent() + ", decimalRule=" + this.getDecimalRule() + ", unit=" + this.getUnit() + ", schema=" + this.getSchema() + ", tagDefinitions=" + this.getTagDefinitions() + ")";
    }
}

