/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.athena.show.domain.agileDataDTO;

import com.digiwin.athena.show.assistant.ExecuteContext;
import com.digiwin.athena.show.component.AbstractComponent;
import com.digiwin.athena.show.component.gridster.GridGroupDTO;
import com.digiwin.athena.show.domain.agileDataDTO.AgileDataBestShowRule;
import com.digiwin.athena.show.domain.agileDataDTO.AgileDataGridsterArea;
import com.digiwin.athena.show.domain.agileDataDTO.AgileDataGridsterArrange;
import com.digiwin.athena.show.domain.agileDataDTO.AgileDataGridsterGroup;
import com.digiwin.athena.show.domain.agileDataDTO.AgileDataRelationDTO;
import com.digiwin.athena.show.domain.board.BoardLayoutMongoData;
import com.digiwin.athena.show.util.layout.AgileDataGridsterBestShow;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.stream.Collectors;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.collections.MapUtils;
import org.apache.commons.lang3.StringUtils;

/*
 * Exception performing whole class analysis ignored.
 */
public class ConvertAgileDataRelation {
    private static List<String> sortComponent = Lists.newArrayList((Object[])new String[]{"LABEL", "STATISTIC", "ECHARTS", "ATHENA_TABLE", "PANEL", "LIST", "CARD"});

    private ConvertAgileDataRelation() {
        throw new IllegalStateException("Utility class");
    }

    public static List<GridGroupDTO> gridGroupDTOS(List<AgileDataRelationDTO> agileDataRelationDTOList, List<AgileDataBestShowRule> bestShowRules, List<AbstractComponent> abstractComponents, ExecuteContext executeContext) {
        String entry;
        Map agileDataMap = executeContext.getAgileData();
        if (MapUtils.isNotEmpty((Map)agileDataMap) && agileDataMap.containsKey("entry") && StringUtils.equals((CharSequence)"1", (CharSequence)(entry = MapUtils.getString((Map)agileDataMap, (Object)"entry")))) {
            return AgileDataGridsterBestShow.createItems(agileDataRelationDTOList, abstractComponents, (ExecuteContext)executeContext);
        }
        return ConvertAgileDataRelation.createItems(agileDataRelationDTOList, bestShowRules, abstractComponents, null);
    }

    public static List<GridGroupDTO> createItems(List<AgileDataRelationDTO> agileDataRelationDTOList, List<AgileDataBestShowRule> bestShowRules, List<AbstractComponent> components, BoardLayoutMongoData userDefineLayout) {
        ArrayList gridGroupDTOList = Lists.newArrayList();
        ArrayList abstractComponents = Lists.newArrayList();
        if (CollectionUtils.isNotEmpty(agileDataRelationDTOList)) {
            agileDataRelationDTOList.stream().forEach(agileDataRelationDTO -> {
                if (agileDataRelationDTO.getAbstractComponents() != null) {
                    abstractComponents.addAll(agileDataRelationDTO.getAbstractComponents());
                }
            });
        }
        if (CollectionUtils.isEmpty((Collection)abstractComponents) && CollectionUtils.isNotEmpty(components)) {
            abstractComponents.addAll(components);
        }
        Map<String, List<AbstractComponent>> abstractComponentMap = abstractComponents.stream().collect(Collectors.groupingBy(AbstractComponent::getType));
        ArrayList arranges = Lists.newArrayList();
        for (String sort : sortComponent) {
            if (!abstractComponentMap.containsKey(sort)) continue;
            AgileDataGridsterArrange agileDataGridsterArrange = new AgileDataGridsterArrange();
            Boolean isAdd = false;
            for (AbstractComponent abstractComponent : abstractComponentMap.get(sort)) {
                AgileDataGridsterArea area = new AgileDataGridsterArea(abstractComponent, null);
                GridGroupDTO userDefineGroup = ConvertAgileDataRelation.getUserDefineGroup((BoardLayoutMongoData)userDefineLayout, (String)abstractComponent.getId());
                if (userDefineGroup != null) {
                    area.setSize(userDefineGroup.getCols().intValue(), userDefineGroup.getRows().intValue());
                } else {
                    area.setSize();
                }
                AgileDataGridsterGroup agileDataGridsterGroup = new AgileDataGridsterGroup();
                agileDataGridsterGroup.getAreas().add(area);
                agileDataGridsterGroup.setSize();
                if (ConvertAgileDataRelation.triggerRule((Integer)12, (AgileDataGridsterArrange)agileDataGridsterArrange, (AgileDataGridsterArea)area).booleanValue()) {
                    AgileDataGridsterArrange newArrange;
                    agileDataGridsterArrange = newArrange = ConvertAgileDataRelation.getNewAgileDataGridsterArrange((AgileDataGridsterGroup)agileDataGridsterGroup, (List)arranges);
                    isAdd = true;
                    continue;
                }
                agileDataGridsterArrange.getGroups().add(agileDataGridsterGroup);
                agileDataGridsterArrange.setSize();
                if (!isAdd.booleanValue()) {
                    arranges.add(agileDataGridsterArrange);
                }
                isAdd = true;
            }
        }
        ConvertAgileDataRelation.reSize((List)arranges);
        arranges.stream().forEach(arrange -> arrange.getGroups().stream().forEach(group -> group.getAreas().stream().forEach(area -> {
            GridGroupDTO gridGroupDTO = new GridGroupDTO();
            gridGroupDTO.setId(area.getComponent().getId());
            gridGroupDTO.setType(area.getComponent().getType());
            gridGroupDTO.setX(area.getX());
            gridGroupDTO.setY(area.getY());
            gridGroupDTO.setCols(Integer.valueOf(area.getCols()));
            gridGroupDTO.setRows(Integer.valueOf(area.getRows()));
            gridGroupDTOList.add(gridGroupDTO);
        })));
        return gridGroupDTOList;
    }

    public static List<GridGroupDTO> createBoardItems(List<AbstractComponent> components, BoardLayoutMongoData userDefineLayout) {
        ArrayList gridGroupDTOList = Lists.newArrayList();
        if (CollectionUtils.isEmpty(components)) {
            return null;
        }
        ArrayList arranges = Lists.newArrayList();
        for (AbstractComponent component : components) {
            AgileDataGridsterArrange agileDataGridsterArrange = new AgileDataGridsterArrange();
            AgileDataGridsterArea area = new AgileDataGridsterArea(component, null);
            GridGroupDTO userDefineGroup = ConvertAgileDataRelation.getUserDefineGroup((BoardLayoutMongoData)userDefineLayout, (String)component.getId());
            if (userDefineGroup != null) {
                area.setSize(userDefineGroup.getCols().intValue(), userDefineGroup.getRows().intValue(), userDefineGroup.getX().intValue(), userDefineGroup.getY().intValue());
            } else {
                area.setSize();
            }
            AgileDataGridsterGroup agileDataGridsterGroup = new AgileDataGridsterGroup();
            agileDataGridsterGroup.getAreas().add(area);
            agileDataGridsterGroup.setSize();
            agileDataGridsterArrange.getGroups().add(agileDataGridsterGroup);
            agileDataGridsterArrange.setSize();
            arranges.add(agileDataGridsterArrange);
        }
        ConvertAgileDataRelation.reSize((List)arranges);
        arranges.stream().forEach(arrange -> arrange.getGroups().stream().forEach(group -> group.getAreas().stream().forEach(area -> {
            GridGroupDTO gridGroupDTO = new GridGroupDTO();
            gridGroupDTO.setId(area.getComponent().getId());
            gridGroupDTO.setType(area.getComponent().getType());
            gridGroupDTO.setX(area.getX());
            gridGroupDTO.setY(area.getY());
            gridGroupDTO.setCols(Integer.valueOf(area.getCols()));
            gridGroupDTO.setRows(Integer.valueOf(area.getRows()));
            gridGroupDTOList.add(gridGroupDTO);
        })));
        return gridGroupDTOList;
    }

    public static List<GridGroupDTO> createUserDefineBoardItems(List<AbstractComponent> components, BoardLayoutMongoData userDefineLayout) {
        ArrayList gridGroupDTOList = Lists.newArrayList();
        if (CollectionUtils.isEmpty(components)) {
            return null;
        }
        int lastY = 0;
        for (AbstractComponent component : components) {
            GridGroupDTO gridGroupDTO = new GridGroupDTO();
            gridGroupDTO.setId(component.getId());
            gridGroupDTO.setType(component.getType());
            GridGroupDTO userDefineGroup = ConvertAgileDataRelation.getUserDefineGroup((BoardLayoutMongoData)userDefineLayout, (String)component.getId());
            if (userDefineGroup != null) {
                gridGroupDTO.setX(userDefineGroup.getX());
                gridGroupDTO.setY(userDefineGroup.getY());
                gridGroupDTO.setCols(userDefineGroup.getCols());
                gridGroupDTO.setRows(userDefineGroup.getRows());
            } else {
                AgileDataGridsterArea area = new AgileDataGridsterArea(component, null);
                area.setSize();
                gridGroupDTO.setX(Integer.valueOf(0));
                gridGroupDTO.setY(Integer.valueOf(lastY));
                gridGroupDTO.setCols(Integer.valueOf(area.getCols()));
                gridGroupDTO.setRows(Integer.valueOf(area.getRows()));
            }
            lastY = gridGroupDTO.getY() + gridGroupDTO.getRows();
            gridGroupDTOList.add(gridGroupDTO);
        }
        return gridGroupDTOList;
    }

    public static GridGroupDTO getUserDefineGroup(BoardLayoutMongoData userDefineLayout, String defineId) {
        if (userDefineLayout == null) {
            return null;
        }
        if (CollectionUtils.isEmpty((Collection)userDefineLayout.getBoardLayout())) {
            return null;
        }
        return userDefineLayout.getBoardLayout().stream().filter(gridGroup -> StringUtils.equals((CharSequence)gridGroup.getId(), (CharSequence)defineId)).findFirst().orElse(null);
    }

    public static AgileDataGridsterArrange getNewAgileDataGridsterArrange(AgileDataGridsterGroup agileDataGridsterGroup, List<AgileDataGridsterArrange> arranges) {
        AgileDataGridsterArrange newArrange = new AgileDataGridsterArrange();
        newArrange.getGroups().add(agileDataGridsterGroup);
        newArrange.setSize();
        arranges.add(newArrange);
        return newArrange;
    }

    public static List<GridGroupDTO> assembleGridster(List<AgileDataGridsterArrange> arranges) {
        ArrayList gridGroupDTOList = Lists.newArrayList();
        arranges.stream().forEach(arrange -> arrange.getGroups().stream().forEach(group -> group.getAreas().stream().forEach(area -> {
            GridGroupDTO gridGroupDTO = new GridGroupDTO();
            gridGroupDTO.setId(area.getComponent().getId());
            gridGroupDTO.setType(area.getComponent().getType());
            gridGroupDTO.setX(area.getX());
            gridGroupDTO.setY(area.getY());
            gridGroupDTO.setCols(Integer.valueOf(area.getCols()));
            gridGroupDTO.setRows(Integer.valueOf(area.getRows()));
            gridGroupDTOList.add(gridGroupDTO);
        })));
        return gridGroupDTOList;
    }

    public static void reSize(List<AgileDataGridsterArrange> arranges) {
        Optional<AgileDataGridsterArrange> arrangeOptional = arranges.stream().max(Comparator.comparing(AgileDataGridsterArrange::getWidth));
        if (arrangeOptional.isPresent()) {
            AgileDataGridsterArrange maxArrange = arrangeOptional.get();
            ConvertAgileDataRelation.calcCoordinate(arranges);
        }
    }

    private static void calcCoordinate(List<AgileDataGridsterArrange> arranges) {
        int height = 0;
        for (AgileDataGridsterArrange arrange : arranges) {
            arrange.setCoordinate(height);
            height += arrange.getHeight();
        }
    }

    private static Boolean triggerRule(Integer num, AgileDataGridsterArrange agileDataGridsterArrange, AgileDataGridsterArea areaComponent) {
        AtomicInteger totalCols = new AtomicInteger();
        agileDataGridsterArrange.getGroups().stream().forEach(group -> group.getAreas().stream().forEach(area -> totalCols.addAndGet(area.getCols())));
        if (totalCols.get() + areaComponent.getCols() > num) {
            return true;
        }
        return false;
    }
}

