/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.athena.show.service;

import cn.hutool.core.bean.BeanUtil;
import com.alibaba.fastjson.JSON;
import com.digiwin.athena.appcore.util.MessageUtils;
import com.digiwin.athena.show.domain.BuildContext;
import com.digiwin.athena.show.domain.agileDataDTO.AgileReportECharts;
import com.digiwin.athena.show.domain.agileDataDTO.ConvertAgileDataUtils;
import com.digiwin.athena.show.domain.agileDataDTO.ConvertGetAgileData;
import com.digiwin.athena.show.domain.showDefine.ThemeMapReport;
import com.digiwin.athena.show.metadata.ApiMetadata;
import com.digiwin.athena.show.metadata.MetadataField;
import com.digiwin.athena.show.service.AgileDataCompensateDataService;
import com.digiwin.athena.show.service.AgileReportRuleService;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import digiwin.chartsdk.beans.sdk.chart.ChartBase;
import digiwin.chartsdk.beans.sdk.chart.ChartBaseSeries;
import digiwin.chartsdk.beans.sdk.chart.Option;
import digiwin.chartsdk.beans.sdk.chart.Point;
import digiwin.chartsdk.beans.sdk.chart.Value;
import digiwin.chartsdk.enums.FieldTypeEnum;
import digiwin.chartsdk.utils.ChartUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.collections.MapUtils;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class ChartBuildBase {
    private static final Logger log = LoggerFactory.getLogger(ChartBuildBase.class);
    @Autowired
    private MessageUtils messageUtils;
    @Autowired
    private AgileDataCompensateDataService agileDataCompensateDataService;
    @Autowired
    private AgileReportRuleService agileReportRuleService;

    public Option buildChart(MetadataField metadataField, BuildContext buildContext) {
        ChartBase chartBase = this.buildChartParams(buildContext);
        this.bindRules(chartBase, buildContext.getThemeMapReport());
        Option option = ChartUtil.getOption((ChartBase)chartBase);
        this.setTitle(buildContext.getThemeMapReport(), option);
        this.transShow(metadataField, chartBase, option, buildContext);
        return option;
    }

    public void bindRules(ChartBase chartBase, ThemeMapReport themeMapReport) {
        this.agileReportRuleService.buildChartDataRule(chartBase, themeMapReport);
    }

    public ChartBase buildChartParams(BuildContext buildContext) {
        ChartBase chartBase = new ChartBase();
        ThemeMapReport themeMapReport = buildContext.getThemeMapReport();
        AgileReportECharts agileReportECharts = themeMapReport.getECharts();
        if (agileReportECharts == null || CollectionUtils.isEmpty((Collection)themeMapReport.getPageData())) {
            return null;
        }
        ArrayList valueMetadataFields = Lists.newArrayList();
        ArrayList chartBaseSeriesList = Lists.newArrayList();
        chartBase.setChartBaseSeries((List)chartBaseSeriesList);
        chartBase.setShowType(agileReportECharts.getChartType());
        for (AgileReportECharts.EChartsData eChartsData : agileReportECharts.getData()) {
            ChartBaseSeries chartBaseSeries = new ChartBaseSeries();
            ArrayList points = Lists.newArrayList();
            List pointFields = this.getChartMetadataField(themeMapReport.getDataSource(), eChartsData.getPoints(), buildContext);
            pointFields.stream().forEach(pointField -> {
                Point point = new Point();
                point.setName(pointField.getName());
                point.setDataType(FieldTypeEnum.getFieldTypeEnumByCode((String)pointField.getDataType()));
                point.setTitle(pointField.getDescription());
                points.add(point);
            });
            ArrayList values = Lists.newArrayList();
            List valueFields = this.getChartMetadataField(themeMapReport.getDataSource(), eChartsData.getValues(), buildContext);
            valueMetadataFields.addAll(valueFields);
            valueFields.stream().forEach(valueField -> {
                Value value = new Value();
                value.setName(valueField.getName());
                String dataType = valueField.getDataType();
                if (StringUtils.equals((String)"numeric", (String)dataType)) {
                    dataType = "number";
                }
                value.setDataType(FieldTypeEnum.getFieldTypeEnumByCode((String)dataType));
                value.setTitle(valueField.getDescription());
                value.setType(this.getDoubleChartType(eChartsData, valueField.getName(), agileReportECharts));
                value.setDecimal(valueField.getDecimal());
                value.setPercent(valueField.getPercent());
                if (StringUtils.isNotEmpty((String)valueField.getExplanation())) {
                    StringBuilder descriptionBuilder = new StringBuilder();
                    descriptionBuilder.append(this.messageUtils.getMessage("agileData.description"));
                    descriptionBuilder.append(valueField.getExplanation());
                    value.setDescription(descriptionBuilder.toString());
                }
                if (StringUtils.isNotEmpty((String)valueField.getBusinessType())) {
                    HashMap extendInfo = Maps.newHashMap();
                    extendInfo.put("businessType", valueField.getBusinessType());
                    value.setExtendInfo((Map)extendInfo);
                }
                if (StringUtils.isNotEmpty((String)valueField.getDecimalRule())) {
                    value.setDecimalRule(BeanUtil.beanToMap((Object)ConvertAgileDataUtils.getDecimalRule((String)valueField.getDecimalRule()), (String[])new String[0]));
                }
                if (StringUtils.isNotEmpty((String)valueField.getUnit())) {
                    value.setUnit(BeanUtil.beanToMap((Object)ConvertAgileDataUtils.getUnitRule((String)valueField.getUnit()), (String[])new String[0]));
                }
                if (CollectionUtils.isNotEmpty((Collection)valueField.getOriginalFields())) {
                    List measurementFields;
                    List dimensionFields = valueField.getOriginalFields().stream().filter(originalField -> !StringUtils.equals((String)"numeric", (String)originalField.getDataType())).collect(Collectors.toList());
                    if (CollectionUtils.isNotEmpty(dimensionFields)) {
                        ArrayList dimensionValues = Lists.newArrayList();
                        dimensionFields.stream().forEach(dimensionField -> {
                            Value dimensionValue = new Value();
                            dimensionValue.setName(dimensionField.getName());
                            dimensionValue.setTitle(dimensionField.getDescription());
                            dimensionValues.add(dimensionValue);
                        });
                        value.setDimensionValue((List)dimensionValues);
                    }
                    if (CollectionUtils.isNotEmpty(measurementFields = valueField.getOriginalFields().stream().filter(originalField -> StringUtils.equals((String)"numeric", (String)originalField.getDataType())).collect(Collectors.toList()))) {
                        ArrayList measurementValues = Lists.newArrayList();
                        measurementFields.stream().forEach(measurement -> {
                            Value dimensionValue = new Value();
                            dimensionValue.setName(measurement.getName());
                            dimensionValue.setTitle(measurement.getDescription());
                            measurementValues.add(dimensionValue);
                        });
                        value.setMeasurementValue((List)measurementValues);
                    }
                }
                values.add(value);
            });
            chartBaseSeries.setPoints((List)points);
            chartBaseSeries.setValues((List)values);
            chartBaseSeries.setType(agileReportECharts.getChartType());
            chartBaseSeriesList.add(chartBaseSeries);
        }
        ArrayList datas = themeMapReport.getPageData();
        ArrayList noValueFields = Lists.newArrayList();
        HashSet hasValueList = new HashSet();
        for (Map dataMap : datas) {
            List hasValues = valueMetadataFields.stream().filter(x -> dataMap.containsKey(x.getName())).collect(Collectors.toList());
            if (hasValues == null) continue;
            hasValues.stream().forEach(value -> {
                if (MapUtils.getObject((Map)dataMap, (Object)value.getName()) == null && !noValueFields.contains(value.getName()) && !hasValueList.contains(value.getName())) {
                    noValueFields.add(value.getName());
                } else {
                    hasValueList.add(value.getName());
                    noValueFields.remove(value.getName());
                }
            });
        }
        if (CollectionUtils.isNotEmpty((Collection)noValueFields)) {
            datas.forEach(data -> noValueFields.forEach(data::remove));
        }
        if (CollectionUtils.isEmpty((Collection)chartBaseSeriesList)) {
            chartBase.setDatas((List)datas);
            return chartBase;
        }
        List compensationData = new ArrayList();
        if (this.needCompensationData(agileReportECharts, (List)datas, (List)chartBaseSeriesList)) {
            String xKey = ((Point)((ChartBaseSeries)chartBaseSeriesList.get(0)).getPoints().get(0)).getName();
            boolean anyDateTypeNull = datas.stream().anyMatch(data -> Objects.isNull(data.get(xKey)) || StringUtils.isEmpty((String)String.valueOf(data.get(xKey))));
            if (anyDateTypeNull) {
                log.warn("buildChartParams dateType key is null datas:{}", (Object)JSON.toJSONString(datas));
            } else {
                compensationData = this.agileDataCompensateDataService.compensateChartLineAgileData((List)chartBaseSeriesList, buildContext, datas, themeMapReport, xKey);
            }
        }
        chartBase.setDatas(compensationData.isEmpty() ? datas : compensationData);
        themeMapReport.setPageData(chartBase.getDatas());
        return chartBase;
    }

    private boolean needCompensationData(AgileReportECharts agileReportECharts, List<Map<String, Object>> datas, List<ChartBaseSeries> chartBaseSeriesList) {
        Point fieldPoint;
        List points;
        if (CollectionUtils.isEmpty(datas)) {
            return false;
        }
        if ("line".equals(agileReportECharts.getChartType())) {
            return true;
        }
        return "mixed".equals(agileReportECharts.getChartType()) && CollectionUtils.isNotEmpty((Collection)(points = chartBaseSeriesList.get(0).getPoints())) && (fieldPoint = (Point)points.stream().filter(point -> FieldTypeEnum.CHART_TYPE_ENUM_DATE.equals((Object)point.getDataType()) || FieldTypeEnum.CHART_TYPE_ENUM_DATETIME.equals((Object)point.getDataType())).findFirst().orElse(null)) != null;
    }

    private String getDoubleChartType(AgileReportECharts.EChartsData eChartsData, String field, AgileReportECharts agileReportECharts) {
        String chartType = "";
        Optional<AgileReportECharts.EChartsDataDefine> eChartsDataDefineOperationDTO = eChartsData.getValues().stream().filter(eChartsDataDefine -> StringUtils.equals((String)field, (String)eChartsDataDefine.getApplyToField())).findFirst();
        if (eChartsDataDefineOperationDTO.isPresent()) {
            chartType = eChartsDataDefineOperationDTO.get().getChart();
        }
        if (StringUtils.isEmpty((String)chartType)) {
            chartType = agileReportECharts.getChartType();
        }
        return chartType;
    }

    protected void setTitle(ThemeMapReport themeMapReport, Option option) {
    }

    protected void transShow(MetadataField metadataField, ChartBase chartBase, Option option, BuildContext buildContext) {
    }

    protected List<MetadataField> getChartMetadataField(String target, List<AgileReportECharts.EChartsDataDefine> eChartsDatas, BuildContext buildContext) {
        ArrayList metadataFields = Lists.newArrayList();
        for (AgileReportECharts.EChartsDataDefine eChartsData : eChartsDatas) {
            Map fieldMap = ConvertGetAgileData.getAgileData((String)target, (ApiMetadata)buildContext.getThemeMapReport().getApiMetadata());
            metadataFields.add(fieldMap.get(eChartsData.getApplyToField()));
        }
        return metadataFields;
    }
}

