/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.athena.show.service.impl;

import com.digiwin.athena.agiledataecho.proxy.adt.AdtService;
import com.digiwin.athena.appcore.util.JsonUtils;
import com.digiwin.athena.appcore.util.MessageUtils;
import com.digiwin.athena.show.assistant.EchoShowConstants;
import com.digiwin.athena.show.component.ComponentFormat;
import com.digiwin.athena.show.domain.agileDataDTO.AgileDataTag;
import com.digiwin.athena.show.domain.agileDataDTO.ConvertAgileDataUtils;
import com.digiwin.athena.show.domain.agileDataDTO.ConvertGetAgileData;
import com.digiwin.athena.show.domain.analysis.AnalysisDataDimensionDTO;
import com.digiwin.athena.show.domain.analysis.AnalysisDataSummaryDTO;
import com.digiwin.athena.show.domain.analysis.AnalysisDimensionRes;
import com.digiwin.athena.show.domain.analysis.AnalysisFluctuateReq;
import com.digiwin.athena.show.domain.analysis.AnalysisFluctuateRes;
import com.digiwin.athena.show.domain.analysis.AnalysisMetric;
import com.digiwin.athena.show.metadata.ApiMetadata;
import com.digiwin.athena.show.metadata.MetadataField;
import com.digiwin.athena.show.service.AgileDataAnalysisService;
import com.digiwin.athena.show.util.ApiMetadataUtil;
import com.github.houbb.heaven.util.lang.BeanUtil;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.collections.MapUtils;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class AgileDataAnalysisServiceImpl
implements AgileDataAnalysisService {
    private static final Logger log = LoggerFactory.getLogger(AgileDataAnalysisServiceImpl.class);
    @Autowired
    private AdtService adtService;
    private static final List<String> DIMENSION_METADATA_FIELD_NAME = Arrays.asList("DimensionValue", "ValueChange", "GrowthRate");
    private static final List<String> DIMENSION_QOQ_METADATA_FIELD_NAME = Arrays.asList("CurrentValue", "PreValue", "GrowthRate");

    public AnalysisDataSummaryDTO getAnalysisDataSummary(AnalysisFluctuateReq analysisFluctuateReq, String local) {
        Objects.requireNonNull(analysisFluctuateReq, "\u6570\u636e\u6ce2\u52a8\u5165\u53c2\u4e3a\u7a7a\uff01");
        AnalysisDataSummaryDTO analysisDataSummaryDTO = new AnalysisDataSummaryDTO();
        Map fluctuateParams = this.buildParams(analysisFluctuateReq, local);
        AnalysisFluctuateRes analysisFluctuateRes = this.adtService.getAnalysisFluctuateData(fluctuateParams, local);
        log.info("\u5f52\u56e0\u5206\u6790-\u6570\u636e\u6ce2\u52a8\uff0c\u8fd4\u56de\u7ed3\u679c\uff1a{}", (Object)JsonUtils.objectToString((Object)analysisFluctuateRes));
        if (analysisFluctuateRes == null) {
            analysisDataSummaryDTO.setDataResult(Boolean.valueOf(false));
            analysisDataSummaryDTO.setMessage(MessageUtils.getMessageByCurrentLanguage((Object)EchoShowConstants.getLanMap((String)"\u65e0\u4e0a\u671f\u503c\uff0c\u65e0\u6cd5\u8fdb\u884c\u5f52\u56e0\u5206\u6790\u3002", (String)"\u7121\u4e0a\u671f\u503c\uff0c\u7121\u6cd5\u9032\u884c\u6b78\u56e0\u5206\u6790\u3002", (String)"Without the previous period's value, attribution analysis cannot be conducted.")));
            return analysisDataSummaryDTO;
        }
        if (StringUtils.isNotEmpty((String)analysisFluctuateRes.getMsg())) {
            analysisDataSummaryDTO.setDataResult(Boolean.valueOf(false));
            analysisDataSummaryDTO.setMessage(analysisFluctuateRes.getMsg());
            return analysisDataSummaryDTO;
        }
        List analysisDataFluctuateList = this.parseAnalysisDataFluctuate(analysisFluctuateRes);
        if (CollectionUtils.isEmpty((Collection)analysisDataFluctuateList)) {
            analysisDataSummaryDTO.setDataResult(Boolean.valueOf(false));
            analysisDataSummaryDTO.setMessage(MessageUtils.getMessageByCurrentLanguage((Object)EchoShowConstants.getLanMap((String)"\u65e0\u4e0a\u671f\u503c\uff0c\u65e0\u6cd5\u8fdb\u884c\u5f52\u56e0\u5206\u6790\u3002", (String)"\u7121\u4e0a\u671f\u503c\uff0c\u7121\u6cd5\u9032\u884c\u6b78\u56e0\u5206\u6790\u3002", (String)"Without the previous period's value, attribution analysis cannot be conducted.")));
            return analysisDataSummaryDTO;
        }
        analysisDataSummaryDTO.setFluctuateData(analysisDataFluctuateList);
        analysisDataSummaryDTO.setAnalysisParams(this.buildAnalysisParams(fluctuateParams, analysisFluctuateRes));
        analysisDataSummaryDTO.setDataResult(Boolean.valueOf(true));
        return analysisDataSummaryDTO;
    }

    public AnalysisDataDimensionDTO getAnalysisDataDimension(AnalysisFluctuateReq analysisFluctuateReq, String local) {
        Objects.requireNonNull(analysisFluctuateReq, "\u6570\u636e\u6ce2\u52a8\u5165\u53c2\u4e3a\u7a7a\uff01");
        AnalysisDataDimensionDTO analysisDataDimensionDTO = new AnalysisDataDimensionDTO();
        AnalysisDimensionRes analysisDimensionRes = this.adtService.getAnalysisDataDimension(this.buildDimensionParams(analysisFluctuateReq, local), local);
        log.info("\u5f52\u56e0\u5206\u6790-\u5f52\u56e0\u5206\u6790\uff0c\u8fd4\u56de\u7ed3\u679c\uff1a{}", (Object)JsonUtils.objectToString((Object)analysisDimensionRes));
        if (analysisDimensionRes == null || CollectionUtils.isEmpty((Collection)analysisDimensionRes.getGroupedSolutionSteps())) {
            analysisDataDimensionDTO.setDataResult(Boolean.valueOf(false));
            analysisDataDimensionDTO.setMessage(MessageUtils.getMessageByCurrentLanguage((Object)EchoShowConstants.getLanMap((String)"\u65e0\u4e0a\u671f\u503c\uff0c\u65e0\u6cd5\u8fdb\u884c\u5f52\u56e0\u5206\u6790\u3002", (String)"\u7121\u4e0a\u671f\u503c\uff0c\u7121\u6cd5\u9032\u884c\u6b78\u56e0\u5206\u6790\u3002", (String)"Without the previous period's value, attribution analysis cannot be conducted.")));
            return analysisDataDimensionDTO;
        }
        if (StringUtils.isNotEmpty((String)analysisDimensionRes.getMsg())) {
            analysisDataDimensionDTO.setDataResult(Boolean.valueOf(false));
            analysisDataDimensionDTO.setMessage(analysisDimensionRes.getMsg());
            return analysisDataDimensionDTO;
        }
        List analysisDataAscribeList = this.parseAnalysisDataDimension(analysisDimensionRes);
        analysisDataDimensionDTO.setAscribe(analysisDataAscribeList);
        analysisDataDimensionDTO.setDataResult(Boolean.valueOf(true));
        return analysisDataDimensionDTO;
    }

    private Map<String, Object> buildDimensionParams(AnalysisFluctuateReq analysisFluctuateReq, String local) {
        HashMap params = Maps.newHashMap();
        params.put("snapshotId", analysisFluctuateReq.getSnapshotId());
        params.put("lang", local);
        if (MapUtils.isNotEmpty((Map)analysisFluctuateReq.getAnalysisParams())) {
            analysisFluctuateReq.getAnalysisParams().forEach((key, value) -> params.put(key, value));
        }
        return params;
    }

    private Map<String, Object> buildAnalysisParams(Map<String, Object> fluctuateParams, AnalysisFluctuateRes analysisFluctuateRes) {
        fluctuateParams.put("step", analysisFluctuateRes.getStep());
        fluctuateParams.put("pullData", analysisFluctuateRes.getPullData());
        fluctuateParams.put("datasetIds", analysisFluctuateRes.getDatasetIds());
        fluctuateParams.put("question", analysisFluctuateRes.getQuestion());
        fluctuateParams.put("questionDate", analysisFluctuateRes.getQuestionDate());
        fluctuateParams.put("orgOutPutSql", analysisFluctuateRes.getOrgOutPutSql());
        return fluctuateParams;
    }

    private Map<String, Object> buildParams(AnalysisFluctuateReq analysisFluctuateReq, String local) {
        Map questionWay;
        Map processStreamData;
        List dimensionData;
        Map params = BeanUtil.beanToMap((Object)analysisFluctuateReq);
        if (CollectionUtils.isNotEmpty((Collection)analysisFluctuateReq.getMeasurementData()) && CollectionUtils.isNotEmpty((Collection)(dimensionData = this.transName(analysisFluctuateReq.getMeasurementData())))) {
            params.put("metric", dimensionData.get(0));
        }
        if (CollectionUtils.isNotEmpty((Collection)analysisFluctuateReq.getDimensionData())) {
            params.put("dimension", this.transName(analysisFluctuateReq.getDimensionData()));
        }
        if (MapUtils.isNotEmpty((Map)(processStreamData = analysisFluctuateReq.getProcessStreamData())) && MapUtils.isNotEmpty((Map)(questionWay = MapUtils.getMap((Map)processStreamData, (Object)"questionWay")))) {
            params.put("step", MapUtils.getString((Map)questionWay, (Object)"content"));
        }
        params.put("lang", local);
        return params;
    }

    private List<Map<String, Object>> transName(List<AnalysisMetric> data) {
        ArrayList dataList = Lists.newArrayList();
        if (CollectionUtils.isNotEmpty(data)) {
            data.stream().forEach(field -> {
                HashMap transField = Maps.newHashMap();
                transField.put("field", field.getName());
                transField.put("value", field.getValue());
                dataList.add(transField);
            });
        }
        return dataList;
    }

    private List<AnalysisDataSummaryDTO.AnalysisDataFluctuate> parseAnalysisDataFluctuate(AnalysisFluctuateRes analysisFluctuateRes) {
        ArrayList analysisDataFluctuateList = Lists.newArrayList();
        if (analysisFluctuateRes != null && CollectionUtils.isNotEmpty((Collection)analysisFluctuateRes.getPullData())) {
            analysisFluctuateRes.getPullData().stream().forEach(pullData -> {
                if (MapUtils.isEmpty((Map)pullData.getMetadata())) {
                    return;
                }
                if (MapUtils.isEmpty((Map)pullData.getData())) {
                    return;
                }
                ApiMetadata apiMetadata = ConvertGetAgileData.transPullData((Map)pullData.getMetadata(), (String)pullData.getActionId());
                if (apiMetadata == null) {
                    return;
                }
                ApiMetadataUtil.flatMetaData((ApiMetadata)apiMetadata);
                List responseFields = ConvertGetAgileData.getTargetFiled((String)"data", (ApiMetadata)apiMetadata);
                List dataList = ConvertGetAgileData.trnasData((Map)pullData.getData());
                if (CollectionUtils.isEmpty((Collection)dataList)) {
                    return;
                }
                this.completionDataTag(pullData.getDataTag(), apiMetadata);
                responseFields = responseFields.stream().filter(metadataField -> DIMENSION_QOQ_METADATA_FIELD_NAME.contains(metadataField.getName())).collect(Collectors.toList());
                if (CollectionUtils.isEmpty((Collection)dataList)) {
                    return;
                }
                responseFields.stream().forEach(metadataField -> {
                    AnalysisDataSummaryDTO.AnalysisDataFluctuate fluctuate = new AnalysisDataSummaryDTO.AnalysisDataFluctuate();
                    fluctuate.setDescription(metadataField.getDescription());
                    fluctuate.setFormat(this.buildFormat(metadataField));
                    dataList.stream().forEach(dataMap -> {
                        fluctuate.setValue(dataMap.get(metadataField.getName()));
                        analysisDataFluctuateList.add(fluctuate);
                    });
                });
            });
        }
        return analysisDataFluctuateList;
    }

    private void completionDataTag(Map<String, Object> dataTag, ApiMetadata apiMetadata) {
        if (MapUtils.isEmpty(dataTag)) {
            return;
        }
        AgileDataTag agileDataTag = (AgileDataTag)JsonUtils.jsonToObject((String)JsonUtils.objectToString(dataTag), AgileDataTag.class);
        MetadataField rootMetadataField = ConvertGetAgileData.getRootMetadataField((ApiMetadata)apiMetadata);
        Map metadataMap = ConvertGetAgileData.getAgileData((String)rootMetadataField.getName(), (ApiMetadata)apiMetadata);
        agileDataTag.getFields().stream().forEach(valueField -> {
            String field = MapUtils.getString((Map)valueField, (Object)"field", (String)"");
            MetadataField metadataField = (MetadataField)metadataMap.get(field);
            if (metadataField != null) {
                metadataField.setBusinessType(MapUtils.getString((Map)valueField, (Object)"businessType", (String)""));
                metadataField.setDecimalRule(MapUtils.getString((Map)valueField, (Object)"decimalRule"));
                metadataField.setExplanation(MapUtils.getString((Map)valueField, (Object)"explanation", (String)""));
                metadataField.setUnit(MapUtils.getString((Map)valueField, (Object)"dataUnit"));
            }
        });
    }

    private List<AnalysisDataDimensionDTO.AnalysisDataAscribe> parseAnalysisDataDimension(AnalysisDimensionRes analysisDimensionRes) {
        ArrayList analysisDataAscribes = Lists.newArrayList();
        if (analysisDimensionRes != null && CollectionUtils.isNotEmpty((Collection)analysisDimensionRes.getGroupedSolutionSteps())) {
            analysisDimensionRes.getGroupedSolutionSteps().stream().forEach(step -> {
                AnalysisDataDimensionDTO.AnalysisDataAscribe analysisDataAscribe = new AnalysisDataDimensionDTO.AnalysisDataAscribe();
                analysisDataAscribe.setDimensionName(MapUtils.getString((Map)step, (Object)"dimension"));
                Map forwardMap = MapUtils.getMap((Map)step, (Object)"forward", (Map)MapUtils.EMPTY_MAP);
                Map reverseMap = MapUtils.getMap((Map)step, (Object)"reverse", (Map)MapUtils.EMPTY_MAP);
                analysisDataAscribe.setForward(this.parseAnalysisDataProgress(forwardMap));
                analysisDataAscribe.setReverse(this.parseAnalysisDataProgress(reverseMap));
                analysisDataAscribes.add(analysisDataAscribe);
            });
        }
        return analysisDataAscribes;
    }

    private List<AnalysisDataDimensionDTO.AnalysisDataProgress> parseAnalysisDataProgress(Map<String, Object> progressMap) {
        ArrayList progressList = Lists.newArrayList();
        Map metadataMap = MapUtils.getMap(progressMap, (Object)"metadata", (Map)MapUtils.EMPTY_MAP);
        Map dataMap = MapUtils.getMap(progressMap, (Object)"data", (Map)MapUtils.EMPTY_MAP);
        Map dataTag = MapUtils.getMap(progressMap, (Object)"dataTag", (Map)MapUtils.EMPTY_MAP);
        if (MapUtils.isEmpty((Map)metadataMap)) {
            return progressList;
        }
        if (MapUtils.isEmpty((Map)dataMap)) {
            return progressList;
        }
        ApiMetadata apiMetadata = ConvertGetAgileData.transPullData((Map)metadataMap, (String)"");
        if (apiMetadata == null) {
            return progressList;
        }
        ApiMetadataUtil.flatMetaData((ApiMetadata)apiMetadata);
        List responseFields = ConvertGetAgileData.getTargetFiled((String)"data", (ApiMetadata)apiMetadata);
        List dataList = ConvertGetAgileData.trnasData((Map)dataMap);
        if (CollectionUtils.isEmpty((Collection)dataList)) {
            return progressList;
        }
        this.completionDataTag(dataTag, apiMetadata);
        dataList.stream().forEach(data -> {
            AnalysisDataDimensionDTO.AnalysisDataProgress progress = new AnalysisDataDimensionDTO.AnalysisDataProgress();
            DIMENSION_METADATA_FIELD_NAME.stream().forEach(metadataFieldName -> {
                MetadataField metadataField = responseFields.stream().filter(field -> StringUtils.equals((String)field.getName(), (String)metadataFieldName)).findFirst().get();
                if (metadataField != null) {
                    switch (metadataFieldName) {
                        case "DimensionValue": {
                            AnalysisDataDimensionDTO.AnalysisDataDimensionData description = new AnalysisDataDimensionDTO.AnalysisDataDimensionData();
                            description.setValue(MapUtils.getObject((Map)data, (Object)metadataFieldName, (Object)""));
                            description.setFormat(this.buildFormat(metadataField));
                            progress.setDescription(description);
                            break;
                        }
                        case "ValueChange": {
                            AnalysisDataDimensionDTO.AnalysisDataDimensionData dimensionValue = new AnalysisDataDimensionDTO.AnalysisDataDimensionData();
                            dimensionValue.setValue(MapUtils.getObject((Map)data, (Object)metadataFieldName, (Object)""));
                            dimensionValue.setFormat(this.buildFormat(metadataField));
                            progress.setFieldValue(dimensionValue);
                            break;
                        }
                        case "GrowthRate": {
                            AnalysisDataDimensionDTO.AnalysisDataDimensionData dimensionAccount = new AnalysisDataDimensionDTO.AnalysisDataDimensionData();
                            dimensionAccount.setValue(MapUtils.getObject((Map)data, (Object)metadataFieldName, (Object)""));
                            dimensionAccount.setFormat(this.buildFormat(metadataField));
                            progress.setAccount(dimensionAccount);
                            break;
                        }
                    }
                }
            });
            progressList.add(progress);
        });
        return progressList;
    }

    private ComponentFormat buildFormat(MetadataField metadataField) {
        ComponentFormat componentFormat = new ComponentFormat();
        if (metadataField.getDecimal() != null && metadataField.getDecimal() == -1) {
            metadataField.setDecimal(null);
        }
        componentFormat.setDecimal(metadataField.getDecimal());
        componentFormat.setPercent(metadataField.getPercent());
        componentFormat.setBusinessType(metadataField.getBusinessType());
        componentFormat.setDecimalRule(ConvertAgileDataUtils.getDecimalRule((String)metadataField.getDecimalRule()));
        componentFormat.setUnit(ConvertAgileDataUtils.getUnitRule((String)metadataField.getUnit()));
        return componentFormat;
    }
}

