/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.athena.show.service.impl;

import com.digiwin.athena.appcore.util.JsonUtils;
import com.digiwin.athena.show.domain.BuildContext;
import com.digiwin.athena.show.domain.agileDataDTO.AgileDataAliasGrainDTO;
import com.digiwin.athena.show.domain.agileDataDTO.AgileDimensionInterval;
import com.digiwin.athena.show.domain.agileDataDTO.AgileReport;
import com.digiwin.athena.show.domain.showDefine.ThemeMapReport;
import com.digiwin.athena.show.service.AgileDataCompensateDataService;
import com.google.common.collect.Lists;
import digiwin.chartsdk.beans.sdk.chart.ChartBaseSeries;
import digiwin.chartsdk.beans.sdk.chart.Point;
import java.time.LocalDate;
import java.time.format.DateTimeFormatter;
import java.time.format.DateTimeParseException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicReference;
import java.util.stream.Collectors;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;

/*
 * Exception performing whole class analysis ignored.
 */
@Service
public class AgileDataCompensateDataServiceImpl
implements AgileDataCompensateDataService {
    private static final Logger log = LoggerFactory.getLogger(AgileDataCompensateDataServiceImpl.class);
    private static final DateTimeFormatter DATE_FORMATTER = DateTimeFormatter.ofPattern("yyyy-MM-dd");
    private static final String[] POSSIBLE_DEFAULT_PATTERN = new String[]{"yyyy", "yyyy-MM", "yyyyMM", "yyyy/MM", "yyyy.MM", "M", "MM", "yyyy-MM", "MM'\u6708'"};
    private static final String[] POSSIBLE_YEAR_PATTERN = new String[]{"yyyy"};
    private static final String[] POSSIBLE_MONTH_PATTERN = new String[]{"M", "MM", "yyyy-MM", "yyyyMM", "yyyy/MM", "yyyy.MM", "yyyy-MM", "MM'\u6708'"};
    private static final String[] POSSIBLE_DAY_PATTERN = new String[]{"d", "dd", "yyyy-MM-d", "yyyy-MM-dd", "yyyyMMdd", "yyyy.MM.dd", "yyyy/MM/dd"};
    private static final String[] POSSIBLE_WEEK_PATTERN = new String[]{"w", "ww", "yyyy-w", "yyyy-ww", "yyyy.w", "yyyy/w"};
    private static final String[] POSSIBLE_QUARTER_PATTERN = new String[]{"Q", "yyyy-Q", "yyyy-MM", "yyyyMM", "yyyy/MM", "yyyy.MM", "MM", "yyyy-MM"};
    private static final List<String> GRAIN_ARRAY = Arrays.asList("y", "Q", "M", "W", "d");
    private static final List<String> GRAIN_NAME = Arrays.asList("\u5e74", "\u6708", "\u65e5", "\u5468", "\u5b63\u5ea6", "\u9031", "\u5b63");

    public List<Map<String, Object>> compensateChartLineAgileData(List<ChartBaseSeries> chartBaseSeriesList, BuildContext buildContext, List<Map<String, Object>> datas, ThemeMapReport themeMapReport, String field) {
        List compensationData = Lists.newArrayList();
        Object dateType = datas.get(0).get(field);
        List dateList = this.getIntervalNumByIntervalData(buildContext.getAgileReport(), dateType, field, this.getDateFormat(buildContext, datas, field));
        if (datas.size() <= dateList.size() && CollectionUtils.isNotEmpty((Collection)dateList)) {
            compensationData = this.compensationDataByParams(datas, dateList, chartBaseSeriesList);
        }
        return compensationData;
    }

    private String getDateFormat(BuildContext buildContext, List<Map<String, Object>> datas, String field) {
        if (CollectionUtils.isEmpty(datas)) {
            return "";
        }
        AgileDataAliasGrainDTO grainDTO = null;
        String link = buildContext.getExecuteContext().getLink();
        if (CollectionUtils.isNotEmpty((Collection)buildContext.getAgileReport().getAliasGrain())) {
            grainDTO = buildContext.getAgileReport().getAliasGrain().stream().filter(aliasGrain -> StringUtils.equals((String)aliasGrain.getAlias(), (String)field)).findFirst().orElse(null);
        }
        if (StringUtils.equals((String)"2", (String)link) && grainDTO == null) {
            return "";
        }
        AgileDataAliasGrainDTO finalGrainDTO = grainDTO;
        AtomicReference<String> choseFormat = new AtomicReference<String>("");
        AtomicInteger index = new AtomicInteger(-1);
        datas.stream().forEach(data -> {
            int lastIndex;
            Object dateType = data.get(field);
            String grain = GRAIN_NAME.stream().filter(s -> dateType.toString().contains((CharSequence)s)).findFirst().orElse(null);
            String formatType = dateType.toString();
            if (StringUtils.isNotEmpty((String)grain) && (lastIndex = formatType.lastIndexOf(grain)) != -1) {
                formatType = formatType.substring(0, lastIndex);
            }
            String[] formatArray = AgileDataCompensateDataServiceImpl.choseFormatArray((AgileDataAliasGrainDTO)finalGrainDTO);
            String format = AgileDataCompensateDataServiceImpl.analyzeFormat((Object)formatType, (AgileDataAliasGrainDTO)finalGrainDTO);
            int fieldIndex = Arrays.asList(formatArray).indexOf(format);
            if (index.get() == -1 || fieldIndex < index.get()) {
                choseFormat.set(format);
                index.set(fieldIndex);
            }
        });
        return choseFormat.get();
    }

    public List<String> getIntervalNumByIntervalData(AgileReport agileReport, Object dateType, String field, String format) {
        LocalDate endDate;
        LocalDate startDate;
        if (dateType == null) {
            return new ArrayList<String>();
        }
        if (agileReport == null || agileReport.getDimensionInterval() == null) {
            return new ArrayList<String>();
        }
        String intervalJson = JsonUtils.objectToString((Object)agileReport.getDimensionInterval());
        log.info("getIntervalNumByIntervalData is param:{}", (Object)intervalJson);
        AgileDimensionInterval dimensionInterval = (AgileDimensionInterval)JsonUtils.jsonToObject((String)intervalJson, AgileDimensionInterval.class);
        if (CollectionUtils.isEmpty((Collection)dimensionInterval.getData())) {
            return new ArrayList<String>();
        }
        String param = ((AgileDimensionInterval.DimensionInterval)dimensionInterval.getData().get(0)).getInterval();
        if (param == null || !param.contains("#")) {
            log.error("Invalid interval format: {}", (Object)param);
            return new ArrayList<String>();
        }
        String[] dates = param.split("#");
        if (dates.length != 2) {
            log.error("Interval does not contain two dates: {}", (Object)param);
            return new ArrayList<String>();
        }
        AgileDataAliasGrainDTO grainDTO = null;
        if (CollectionUtils.isNotEmpty((Collection)agileReport.getAliasGrain())) {
            grainDTO = agileReport.getAliasGrain().stream().filter(aliasGrain -> StringUtils.equals((String)aliasGrain.getAlias(), (String)field)).findFirst().orElse(null);
        }
        try {
            startDate = LocalDate.parse(dates[0], DATE_FORMATTER);
            endDate = LocalDate.parse(dates[1], DATE_FORMATTER);
        }
        catch (Exception e) {
            log.error("Error parsing dates: ", (Throwable)e);
            return new ArrayList<String>();
        }
        ArrayList months = new ArrayList();
        while (!startDate.isAfter(endDate)) {
            try {
                String grain = GRAIN_NAME.stream().filter(s -> dateType.toString().contains((CharSequence)s)).findFirst().orElse(null);
                if (StringUtils.isEmpty((String)format)) {
                    months = Lists.newArrayList();
                    break;
                }
                String transDate = startDate.format(DateTimeFormatter.ofPattern(Objects.requireNonNull(format)));
                if (StringUtils.isNotEmpty((String)grain)) {
                    transDate = transDate + (grain == null ? "" : grain);
                }
                months.add(transDate);
                startDate = AgileDataCompensateDataServiceImpl.incrementalDate((LocalDate)startDate, (AgileDataAliasGrainDTO)grainDTO);
            }
            catch (Exception e) {
                log.error("\u8865\u9f50\u654f\u6377\u6570\u636e\u65e5\u671f\u5f02\u5e38\uff1a{}", (Object)e.getMessage());
                break;
            }
        }
        return months;
    }

    private List<Map<String, Object>> compensationDataByParams(List<Map<String, Object>> params, List<String> intervalList, List<ChartBaseSeries> chartBaseSeriesList) {
        String xKey = ((Point)chartBaseSeriesList.get(0).getPoints().get(0)).getName();
        ArrayList<Map<String, Object>> result = new ArrayList<Map<String, Object>>();
        Map<String, Map> collectMap = params.stream().collect(Collectors.toMap(map -> String.valueOf(map.get(xKey)), map -> map, (existing, replacement) -> existing));
        for (String monthString : intervalList) {
            HashMap<String, String> map2 = new HashMap<String, String>();
            Map monthData = collectMap.getOrDefault(monthString, null);
            if (monthData == null) {
                map2.put(xKey, monthString);
                chartBaseSeriesList.stream().forEach(chartBaseSeries -> chartBaseSeries.getValues().stream().forEach(value -> map2.put(value.getName(), (String)0.0)));
                result.add(map2);
                continue;
            }
            result.add(monthData);
        }
        return result;
    }

    public static String analyzeFormat(Object date, AgileDataAliasGrainDTO aliasGrain) {
        String formatResult = "";
        for (String pattern : AgileDataCompensateDataServiceImpl.choseFormatArray((AgileDataAliasGrainDTO)aliasGrain)) {
            try {
                DateTimeFormatter.ofPattern(pattern).parse(date.toString());
                formatResult = pattern;
            }
            catch (DateTimeParseException e) {
                log.error("analyzeFormat error:{}", (Object)e.getMessage());
            }
        }
        return formatResult;
    }

    public static String[] choseFormatArray(AgileDataAliasGrainDTO aliasGrain) {
        if (aliasGrain == null || StringUtils.isEmpty((String)aliasGrain.getAlias()) || !GRAIN_ARRAY.contains(aliasGrain.getGrain())) {
            return POSSIBLE_DEFAULT_PATTERN;
        }
        switch (aliasGrain.getGrain()) {
            case "y": {
                return POSSIBLE_YEAR_PATTERN;
            }
            case "d": {
                return POSSIBLE_DAY_PATTERN;
            }
            case "W": {
                return POSSIBLE_WEEK_PATTERN;
            }
            case "Q": {
                return POSSIBLE_QUARTER_PATTERN;
            }
        }
        return POSSIBLE_MONTH_PATTERN;
    }

    public static LocalDate incrementalDate(LocalDate startDate, AgileDataAliasGrainDTO aliasGrain) {
        LocalDate incrementalDate = null;
        if (aliasGrain == null || StringUtils.isEmpty((String)aliasGrain.getAlias()) || !GRAIN_ARRAY.contains(aliasGrain.getGrain())) {
            return startDate.plusMonths(1L).withDayOfMonth(1);
        }
        switch (aliasGrain.getGrain()) {
            case "y": {
                incrementalDate = startDate.plusYears(1L);
                break;
            }
            case "d": {
                incrementalDate = startDate.plusDays(1L);
                break;
            }
            case "W": {
                incrementalDate = startDate.plusWeeks(1L);
                break;
            }
            case "Q": {
                incrementalDate = startDate.plusMonths(3L);
                break;
            }
            default: {
                incrementalDate = startDate.plusMonths(1L).withDayOfMonth(1);
            }
        }
        return incrementalDate;
    }
}

