/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.athena.show.service.impl;

import com.digiwin.athena.show.analyzer.AgileReportPageDefineAnalyzer;
import com.digiwin.athena.show.assistant.ExecuteContext;
import com.digiwin.athena.show.component.AbstractComponent;
import com.digiwin.athena.show.component.echarts.EchartsComponent;
import com.digiwin.athena.show.domain.agileDataDTO.AgileReport;
import com.digiwin.athena.show.domain.queryDefine.SnapDataDTO;
import com.digiwin.athena.show.domain.showDefine.DynamicAgileData;
import com.digiwin.athena.show.service.AgileReportService;
import com.digiwin.athena.show.template.AgileReportPageTemplate;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.collections.MapUtils;
import org.apache.commons.lang.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class AgileReportServiceImpl
implements AgileReportService {
    @Autowired
    private AgileReportPageDefineAnalyzer agileReportPageDefineAnalyzer;
    @Autowired
    private List<AgileReportPageTemplate> pageDefines;

    public DynamicAgileData createAgileReportTemplateTable(ExecuteContext executeContext, SnapDataDTO snapDataDTO) {
        AgileReport agileReport = this.agileReportPageDefineAnalyzer.analysis(executeContext, snapDataDTO);
        return Objects.requireNonNull(this.getPageDefine(executeContext)).createAgileReport(executeContext, agileReport);
    }

    public String getShowType(DynamicAgileData dynamicAgileData, String defaultShowType) {
        String showType = null;
        if (dynamicAgileData != null) {
            List layout = dynamicAgileData.getLayout();
            if (CollectionUtils.isEmpty((Collection)layout)) {
                return showType;
            }
            for (AbstractComponent abstractComponent : layout) {
                switch (abstractComponent.getType()) {
                    case "STATISTIC": {
                        showType = "2";
                        break;
                    }
                    case "TABLE": {
                        showType = "0";
                        break;
                    }
                    case "ECHARTS": {
                        EchartsComponent echartsComponent;
                        if (!(abstractComponent instanceof EchartsComponent) || !StringUtils.equals((String)"4", (String)(showType = String.valueOf((echartsComponent = (EchartsComponent)abstractComponent).getChartType())))) break;
                        showType = defaultShowType;
                    }
                }
            }
        }
        return showType;
    }

    private AgileReportPageTemplate getPageDefine(ExecuteContext executeContext) {
        Map agileData = executeContext.getAgileData();
        String entry = MapUtils.getString((Map)agileData, (Object)"entry");
        entry = StringUtils.equals((String)"1", (String)entry) ? "SCREEN" : "GENERA";
        AgileReportPageTemplate agileReportPageTemplate = null;
        for (AgileReportPageTemplate template : this.pageDefines) {
            String supportKey = "AGILE_DATA_TEMPLATE_" + entry;
            if (!StringUtils.equals((String)template.supportKey(), (String)supportKey)) continue;
            agileReportPageTemplate = template;
            break;
        }
        return agileReportPageTemplate;
    }
}

