/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.athena.show.service.impl;

import com.digiwin.athena.agiledataecho.constant.ErrorCodeEnum;
import com.digiwin.athena.agiledataecho.domain.AgileDataUserDefine;
import com.digiwin.athena.agiledataecho.proxy.adt.AdtService;
import com.digiwin.athena.appcore.auth.domain.AuthoredUser;
import com.digiwin.athena.appcore.exception.BusinessException;
import com.digiwin.athena.appcore.util.MessageUtils;
import com.digiwin.athena.show.assistant.ExecuteContext;
import com.digiwin.athena.show.component.gridster.GridGroupDTO;
import com.digiwin.athena.show.component.index.AgileDataIndexComponent;
import com.digiwin.athena.show.domain.agileDataDTO.ConvertAgileDataRelation;
import com.digiwin.athena.show.domain.agileDataDTO.ConvertGetAgileData;
import com.digiwin.athena.show.domain.board.BoardLayoutDTO;
import com.digiwin.athena.show.domain.board.BoardLayoutMongoData;
import com.digiwin.athena.show.domain.board.BoardLayoutParamsDTO;
import com.digiwin.athena.show.domain.board.SnapShotInfo;
import com.digiwin.athena.show.domain.dynamicLayout.BordDynamicDTO;
import com.digiwin.athena.show.domain.queryDefine.SnapDataDTO;
import com.digiwin.athena.show.domain.showDefine.DynamicAgileData;
import com.digiwin.athena.show.manager.themeMap.ThemeAgileDataService;
import com.digiwin.athena.show.manager.themeMap.domain.ThemeMapBoardDTO;
import com.digiwin.athena.show.metadata.ApiMetadata;
import com.digiwin.athena.show.metadata.MetadataField;
import com.digiwin.athena.show.service.AgileDataBestShowRuleService;
import com.digiwin.athena.show.service.AgileReportService;
import com.digiwin.athena.show.service.DynamicLayoutBoardService;
import com.digiwin.athena.show.service.impl.AgileDataPageDefineThemeMapService;
import com.digiwin.athena.show.util.layout.AgileDataBoardComponentBuild;
import com.digiwin.athena.show.util.layout.AgileDataCheck;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.commons.collections.CollectionUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.data.mongodb.core.MongoTemplate;
import org.springframework.data.mongodb.core.query.Criteria;
import org.springframework.data.mongodb.core.query.CriteriaDefinition;
import org.springframework.data.mongodb.core.query.Query;
import org.springframework.data.mongodb.core.query.Update;
import org.springframework.data.mongodb.core.query.UpdateDefinition;
import org.springframework.stereotype.Service;

@Service
public class DynamicLayoutBoardServiceImpl
implements DynamicLayoutBoardService {
    @Autowired
    private AgileDataBestShowRuleService agileDataBestShowRuleService;
    @Autowired
    private ThemeAgileDataService themeAgileDataService;
    @Autowired
    private AdtService adtService;
    @Autowired
    private AgileReportService agileReportService;
    @Autowired
    private AgileDataPageDefineThemeMapService agileDataPageDefineThemeMapService;
    @Autowired
    private MessageUtils messageUtils;
    @Autowired
    @Qualifier(value="mongoAgileDataPageViewTemplate")
    private MongoTemplate mongoAgileDataPageViewTemplate;
    private static final String BOARD_LAYOUT_NAME = "agileData_board_layout";

    public List<GridGroupDTO> calcDynamicLayoutBoard(AuthoredUser user, BordDynamicDTO board, String local) {
        ThemeMapBoardDTO themeMapBoardDTO = this.themeAgileDataService.getThemeMapBoard(board.getBoardId());
        if (themeMapBoardDTO == null) {
            throw BusinessException.create((String)ErrorCodeEnum.BOARD_NO_DATA.getErrCode(), (String)this.messageUtils.getMessage("board.no.data"));
        }
        if (CollectionUtils.isEmpty((Collection)themeMapBoardDTO.getDataBoardQuestions())) {
            throw BusinessException.create((String)ErrorCodeEnum.BOARD_NO_DATA.getErrCode(), (String)this.messageUtils.getMessage("board.no.data"));
        }
        BoardLayoutMongoData userDefineLayout = this.getDynamicLayoutBoard(user, board.getBoardId());
        if (userDefineLayout != null) {
            HashMap orderMap = Maps.newHashMap();
            for (int i = 0; i < userDefineLayout.getBoardLayout().size(); ++i) {
                orderMap.put(((GridGroupDTO)userDefineLayout.getBoardLayout().get(i)).getId(), i);
            }
            HashMap originalIndexMap = Maps.newHashMap();
            for (int i = 0; i < themeMapBoardDTO.getDataBoardQuestions().size(); ++i) {
                originalIndexMap.put(themeMapBoardDTO.getDataBoardQuestions().get(i), i);
            }
            List dataBoardQuestions = themeMapBoardDTO.getDataBoardQuestions().stream().sorted(Comparator.comparingInt(item -> orderMap.containsKey(item.getQuestionId()) ? 0 : 1).thenComparing(Comparator.comparingInt(item -> orderMap.getOrDefault(item.getQuestionId(), Integer.MAX_VALUE)).thenComparing(item -> (Integer)originalIndexMap.get(item)))).collect(Collectors.toList());
            themeMapBoardDTO.setDataBoardQuestions(dataBoardQuestions);
        }
        ArrayList abstractComponents = Lists.newArrayList();
        themeMapBoardDTO.getDataBoardQuestions().stream().forEach(question -> {
            if (question.getShowType() == null) {
                question.setShowType(Integer.valueOf(0));
            }
            switch (question.getShowType()) {
                case 2: {
                    SnapDataDTO snapDataDTO = this.adtService.transAgileData(String.valueOf(question.getShowType()), question.getSnapshotId(), local);
                    AgileDataIndexComponent agileDataIndexComponent = this.getIndexComponent(question.getQuestionId(), snapDataDTO, local);
                    if (agileDataIndexComponent != null) {
                        abstractComponents.add(agileDataIndexComponent);
                        break;
                    }
                    abstractComponents.add(this.getEmptyIndexComponent(question.getQuestionId()));
                    break;
                }
                case 3: 
                case 4: 
                case 5: 
                case 6: {
                    abstractComponents.add(AgileDataBoardComponentBuild.buildBoardEcharts((String)question.getQuestionId()));
                    break;
                }
                default: {
                    abstractComponents.add(AgileDataBoardComponentBuild.buildBoardGrid((String)question.getQuestionId()));
                }
            }
        });
        List items = userDefineLayout != null ? ConvertAgileDataRelation.createUserDefineBoardItems((List)abstractComponents, (BoardLayoutMongoData)userDefineLayout) : ConvertAgileDataRelation.createBoardItems((List)abstractComponents, (BoardLayoutMongoData)userDefineLayout);
        return items;
    }

    private AgileDataIndexComponent getIndexComponent(String questionId, SnapDataDTO snapDataDTO, String local) {
        if (snapDataDTO == null) {
            return null;
        }
        String actionId = (String)snapDataDTO.getPageData().keySet().iterator().next();
        ExecuteContext executeContext = new ExecuteContext();
        executeContext.setLocale(local);
        ApiMetadata apiMetadata = this.agileDataPageDefineThemeMapService.getApiMetadata(snapDataDTO, executeContext, actionId);
        return AgileDataBoardComponentBuild.buildBoardIndex((String)questionId, (MetadataField)ConvertGetAgileData.getRootMetadataField((ApiMetadata)apiMetadata));
    }

    private AgileDataIndexComponent getEmptyIndexComponent(String questionId) {
        AgileDataIndexComponent agileDataIndexComponent = new AgileDataIndexComponent();
        agileDataIndexComponent.setType("STATISTIC");
        ArrayList group = Lists.newArrayList();
        group.add(new AgileDataIndexComponent.AgileDataIndex());
        agileDataIndexComponent.setGroup((List)group);
        agileDataIndexComponent.setId(questionId);
        return agileDataIndexComponent;
    }

    public Map<String, Object> generateBoardLayout(AuthoredUser user, BoardLayoutParamsDTO boardLayoutParamsDTO, String local) {
        ExecuteContext executeContext;
        HashMap result = Maps.newHashMap();
        SnapShotInfo snapShotInfo = this.adtService.getBoardData(boardLayoutParamsDTO, local);
        if (snapShotInfo == null) {
            return result;
        }
        String snapshotId = snapShotInfo.getSnapshotId();
        SnapDataDTO agileReportDTO = this.adtService.getAdtReportBySnapshotId(snapshotId, (executeContext = ExecuteContext.createByHttpRequest()).getLocale());
        if (AgileDataCheck.sceneBasicCheck((SnapDataDTO)agileReportDTO).booleanValue()) {
            return result;
        }
        executeContext.appendAgileDataPageInfo("agiledata-page", agileReportDTO, null, "0");
        DynamicAgileData dynamicAgileData = this.agileReportService.createAgileReportTemplateTable(executeContext, agileReportDTO);
        result.put("dsl", dynamicAgileData);
        Object dataTipMessage = snapShotInfo.getContext().getBizParams().get("dataTipMessage");
        if (dataTipMessage != null) {
            result.put("dataTipMessage", dynamicAgileData);
        }
        return result;
    }

    public Boolean saveDynamicLayoutBoard(AuthoredUser authoredUser, BoardLayoutDTO boardLayoutDTO) {
        if (CollectionUtils.isNotEmpty((Collection)boardLayoutDTO.getBoardLayout())) {
            Query query = Query.query((CriteriaDefinition)Criteria.where((String)"userId").is((Object)authoredUser.getUserId()).and("tenantId").is((Object)authoredUser.getTenantId()).and("boardId").is((Object)boardLayoutDTO.getBoardId()));
            BoardLayoutMongoData boardLayoutMongoData = (BoardLayoutMongoData)this.mongoAgileDataPageViewTemplate.findOne(query, BoardLayoutMongoData.class, BOARD_LAYOUT_NAME);
            if (boardLayoutMongoData == null) {
                boardLayoutMongoData = new BoardLayoutMongoData();
                boardLayoutMongoData.setBoardLayout(boardLayoutDTO.getBoardLayout());
                boardLayoutMongoData.setBoardId(boardLayoutDTO.getBoardId());
                boardLayoutMongoData.setUserId(authoredUser.getUserId());
                boardLayoutMongoData.setTenantId(authoredUser.getTenantId());
                this.mongoAgileDataPageViewTemplate.insert((Object)boardLayoutMongoData, BOARD_LAYOUT_NAME);
            } else {
                Update update = new Update();
                update.set("boardLayout", (Object)boardLayoutDTO.getBoardLayout());
                this.mongoAgileDataPageViewTemplate.upsert(query, (UpdateDefinition)update, AgileDataUserDefine.class, BOARD_LAYOUT_NAME);
            }
        }
        return true;
    }

    public BoardLayoutMongoData getDynamicLayoutBoard(AuthoredUser authoredUser, String boardId) {
        Query query = Query.query((CriteriaDefinition)Criteria.where((String)"userId").is((Object)authoredUser.getUserId()).and("tenantId").is((Object)authoredUser.getTenantId()).and("boardId").is((Object)boardId));
        return (BoardLayoutMongoData)this.mongoAgileDataPageViewTemplate.findOne(query, BoardLayoutMongoData.class, BOARD_LAYOUT_NAME);
    }
}

