/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.athena.show.util.layout;

import com.digiwin.athena.show.assistant.ExecuteContext;
import com.digiwin.athena.show.component.AbstractComponent;
import com.digiwin.athena.show.component.gridster.GridGroupDTO;
import com.digiwin.athena.show.domain.agileDataDTO.AgileDataBestShowRule;
import com.digiwin.athena.show.domain.agileDataDTO.AgileDataGridsterArea;
import com.digiwin.athena.show.domain.agileDataDTO.AgileDataGridsterArrange;
import com.digiwin.athena.show.domain.agileDataDTO.AgileDataGridsterGroup;
import com.digiwin.athena.show.domain.agileDataDTO.AgileDataRelationDTO;
import com.digiwin.athena.show.domain.agileDataDTO.AgileDataScreenModel;
import com.digiwin.athena.show.domain.agileDataDTO.ConvertAgileDataRelation;
import com.digiwin.athena.show.domain.agileDataDTO.ConvertAgileDataUtils;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.collections.MapUtils;
import org.apache.commons.lang.StringUtils;

/*
 * Exception performing whole class analysis ignored.
 */
public class AgileDataGridsterBestShow {
    private AgileDataGridsterBestShow() {
        throw new IllegalStateException("Utility class");
    }

    public static List<GridGroupDTO> createItems(List<AgileDataRelationDTO> relations, List<AbstractComponent> components, ExecuteContext executeContext) {
        executeContext.getAgileData();
        if (ConvertAgileDataUtils.isNeedDefaultModel((ExecuteContext)executeContext).booleanValue()) {
            return AgileDataGridsterBestShow.buildUserItems(components, (ExecuteContext)executeContext);
        }
        if (CollectionUtils.isEmpty(relations) || relations.size() < 2) {
            return AgileDataGridsterBestShow.createDefaultItems(relations, components);
        }
        List componentsRelation = relations.stream().filter(relation -> CollectionUtils.isEmpty((Collection)relation.getAbstractComponents())).collect(Collectors.toList());
        if (CollectionUtils.isNotEmpty(componentsRelation)) {
            return AgileDataGridsterBestShow.createDefaultItems(relations, components);
        }
        AgileDataGridsterBestShow.setEmptyRelation(relations, components);
        AgileDataGridsterBestShow.setRelationLevel(relations, (int)0);
        List arranges = AgileDataGridsterBestShow.initArrange(relations);
        ConvertAgileDataRelation.reSize((List)arranges);
        return ConvertAgileDataRelation.assembleGridster((List)arranges);
    }

    private static List<GridGroupDTO> buildUserItems(List<AbstractComponent> components, ExecuteContext executeContext) {
        ArrayList items = Lists.newArrayList();
        Map agileDataMap = executeContext.getAgileData();
        Object screenModelObj = MapUtils.getObject((Map)agileDataMap, (Object)"screenModel");
        String actionIds = MapUtils.getString((Map)agileDataMap, (Object)"screenActionIds");
        if (StringUtils.isEmpty((String)actionIds)) {
            return null;
        }
        if (screenModelObj == null) {
            return null;
        }
        ArrayList actionIdList = Lists.newArrayList((Object[])actionIds.split(","));
        AgileDataScreenModel screenModel = (AgileDataScreenModel)screenModelObj;
        List layoutModels = screenModel.getModels();
        for (int i = 0; i < layoutModels.size(); ++i) {
            String actionId = null;
            if (i < actionIdList.size()) {
                actionId = (String)actionIdList.get(i);
            }
            AgileDataScreenModel.ScreenModel layoutModel = (AgileDataScreenModel.ScreenModel)layoutModels.get(i);
            String finalActionId = actionId;
            AbstractComponent abstractComponent = null;
            if (finalActionId != null) {
                abstractComponent = components.stream().filter(component -> StringUtils.equals((String)finalActionId, (String)component.getId()) || StringUtils.equals((String)finalActionId, (String)component.getPath())).findFirst().orElse(null);
            }
            if (layoutModel == null) continue;
            GridGroupDTO item = new GridGroupDTO();
            if (abstractComponent == null) {
                item.setId("tempArea" + i);
            } else {
                item.setId(abstractComponent.getId());
                item.setType(abstractComponent.getType());
            }
            item.setCols(layoutModel.getCols());
            item.setRows(layoutModel.getRows());
            item.setX(layoutModel.getX());
            item.setY(layoutModel.getY());
            items.add(item);
        }
        return items;
    }

    private static void setEmptyRelation(List<AgileDataRelationDTO> relations, List<AbstractComponent> components) {
        Map relationDTOMap = AgileDataGridsterBestShow.getRelationMap(relations);
        components.stream().forEach(component -> {
            if (!relationDTOMap.containsKey(component.getId())) {
                AgileDataRelationDTO agileDataRelationDTO = new AgileDataRelationDTO();
                agileDataRelationDTO.setActionId(component.getId());
                agileDataRelationDTO.setSort(Integer.valueOf(99999));
                agileDataRelationDTO.setAbstractComponents((List)Lists.newArrayList((Object[])new AbstractComponent[]{component}));
                relations.add(agileDataRelationDTO);
            }
        });
    }

    private static Map<String, AgileDataRelationDTO> getRelationMap(List<AgileDataRelationDTO> relations) {
        HashMap relationDTOMap = Maps.newHashMap();
        relations.stream().forEach(relation -> {
            relationDTOMap.put(relation.getActionId(), relation);
            if (CollectionUtils.isNotEmpty((Collection)relation.getSubAction())) {
                relationDTOMap.putAll(AgileDataGridsterBestShow.getRelationMap((List)relation.getSubAction()));
            }
        });
        return relationDTOMap;
    }

    private static List<AgileDataGridsterArrange> initArrange(List<AgileDataRelationDTO> relations) {
        ArrayList arranges = Lists.newArrayList();
        relations = relations.stream().filter(relation -> 1 == relation.getLevel()).sorted(Comparator.comparing(AgileDataRelationDTO::getSort)).collect(Collectors.toList());
        relations.stream().forEach(relation -> {
            AgileDataGridsterArrange agileDataGridsterArrange = new AgileDataGridsterArrange();
            Map relationMap = AgileDataGridsterBestShow.groupByLevel((AgileDataRelationDTO)relation);
            relationMap.forEach((level, subRelations) -> {
                AgileDataGridsterGroup group = new AgileDataGridsterGroup();
                agileDataGridsterArrange.getGroups().add(group);
                subRelations.stream().forEach(subRelation -> subRelation.getAbstractComponents().stream().forEach(component -> {
                    AgileDataGridsterArea area = new AgileDataGridsterArea(component, subRelation.getType());
                    area.setSize();
                    HashSet nextLevel = Sets.newHashSet();
                    AgileDataGridsterBestShow.getNextLevel((AgileDataRelationDTO)subRelation, (Set)nextLevel);
                    area.setNextLevel((Set)nextLevel);
                    group.getAreas().add(area);
                    group.setSize();
                    group.setDirection("row");
                }));
            });
            agileDataGridsterArrange.setSize();
            arranges.add(agileDataGridsterArrange);
        });
        return arranges;
    }

    private static void getNextLevel(AgileDataRelationDTO relationDTO, Set<Integer> xIndex) {
        if (CollectionUtils.isNotEmpty((Collection)relationDTO.getSubAction())) {
            relationDTO.getSubAction().stream().forEach(subRelation -> {
                xIndex.add(subRelation.getLevel());
                if (CollectionUtils.isNotEmpty((Collection)subRelation.getSubAction())) {
                    AgileDataGridsterBestShow.getNextLevel((AgileDataRelationDTO)subRelation, (Set)xIndex);
                }
            });
        }
    }

    private static Map<Integer, List<AgileDataRelationDTO>> groupByLevel(AgileDataRelationDTO relation) {
        ArrayList relations = Lists.newArrayList();
        AgileDataGridsterBestShow.getAllRelation((AgileDataRelationDTO)relation, (List)relations);
        return relations.stream().collect(Collectors.groupingBy(AgileDataRelationDTO::getLevel, Collectors.collectingAndThen(Collectors.toList(), list -> {
            list.sort(Comparator.comparing(AgileDataRelationDTO::getSort));
            return list;
        })));
    }

    public static void getAllRelation(AgileDataRelationDTO relation, List<AgileDataRelationDTO> relations) {
        if (CollectionUtils.isNotEmpty((Collection)relation.getAbstractComponents())) {
            relations.add(relation);
        }
        if (CollectionUtils.isNotEmpty((Collection)relation.getSubAction())) {
            relation.getSubAction().stream().forEach(subRelation -> AgileDataGridsterBestShow.getAllRelation((AgileDataRelationDTO)subRelation, (List)relations));
        }
    }

    private static List<GridGroupDTO> createDefaultItems(List<AgileDataRelationDTO> relations, List<AbstractComponent> components) {
        ArrayList bestShowRules = Lists.newArrayList();
        Map<String, List<AbstractComponent>> abstractComponentMap = components.stream().collect(Collectors.groupingBy(AbstractComponent::getType));
        if (abstractComponentMap.containsKey("ECHARTS")) {
            int size = abstractComponentMap.get("ECHARTS").size();
            AgileDataBestShowRule bestShowRule = new AgileDataBestShowRule();
            bestShowRule.setRuleType("ECHARTS_NUM");
            switch (size) {
                case 1: 
                case 2: 
                case 3: 
                case 5: 
                case 6: {
                    bestShowRule.setRuleValue("3");
                    break;
                }
                case 4: {
                    bestShowRule.setRuleValue("2");
                    break;
                }
                case 7: {
                    bestShowRule.setRuleValue("4");
                    break;
                }
                default: {
                    bestShowRule.setRuleValue("2");
                }
            }
            bestShowRules.add(bestShowRule);
        }
        return ConvertAgileDataRelation.createItems(relations, (List)bestShowRules, components, null);
    }

    private static void setRelationLevel(List<AgileDataRelationDTO> relations, int index) {
        if (CollectionUtils.isEmpty(relations)) {
            return;
        }
        relations.stream().forEach(relation -> {
            relation.setLevel(Integer.valueOf(index + 1));
            if (relation.getSort() == null) {
                relation.setSort(Integer.valueOf(99999));
            }
            if (CollectionUtils.isNotEmpty((Collection)relation.getSubAction())) {
                AgileDataGridsterBestShow.setRelationLevel((List)relation.getSubAction(), (int)(index + 1));
            }
        });
    }
}

