/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.athena.agiledataecho.config.filter;

import ch.qos.logback.classic.util.LogbackMDCAdapter;
import com.digiwin.athena.agiledataecho.config.filter.SafeMdcTraceFilter;
import com.jugg.agile.framework.core.dapper.log.JaMDC;
import com.jugg.agile.framework.meta.adapter.JaCoreAdapter;
import java.io.IOException;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang.StringUtils;
import org.slf4j.MDC;
import org.slf4j.spi.MDCAdapter;
import org.springframework.stereotype.Component;

/*
 * Exception performing whole class analysis ignored.
 */
@Component
public class SafeMdcTraceFilter
implements Filter {
    private static final String JA_TRACE_ID = "ja-trace-id";
    private static final String JA_REQ_ID = "ja-req-id";
    private static final String TRACE_ID = "traceId";
    private static final String PTX_ID = "PtxId";
    private static final String UPSTREAM_TRACE_ID = "upstream-trace-id";
    private static final String APPLIED_ATTR = SafeMdcTraceFilter.class.getName() + ".APPLIED";
    private static final Set<String> BLOCKED_HEADERS = new HashSet<String>(Arrays.asList("x-transactionid", "x-spanid", "x-parentspanid", "x-sampled", "x-flags", "traceparent", "tracestate", "x-b3-traceid", "x-b3-spanid", "x-b3-parentspanid", "x-b3-sampled", "x-b3-flags"));

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void doFilter(ServletRequest request, ServletResponse response, FilterChain chain) throws IOException, ServletException {
        String reqId;
        if (!(request instanceof HttpServletRequest) || !(response instanceof HttpServletResponse)) {
            chain.doFilter(request, response);
            return;
        }
        HttpServletRequest req = (HttpServletRequest)request;
        HttpServletResponse resp = (HttpServletResponse)response;
        if (req.getAttribute(APPLIED_ATTR) != null) {
            chain.doFilter(request, response);
            return;
        }
        req.setAttribute(APPLIED_ATTR, (Object)Boolean.TRUE);
        System.out.println("\u8fd9\u662fmdc\u7684\u94fe\u8defID" + MDC.get((String)"PtxId"));
        System.out.println("\u8fd9\u662fJaMDC\u7684\u94fe\u8defID" + JaMDC.get((String)"PtxId"));
        System.out.println("\u8fd9\u662fJaCoreAdapter\u7684\u94fe\u8defID" + JaCoreAdapter.getTraceId());
        MDCAdapter mdc = MDC.getMDCAdapter();
        if (mdc instanceof LogbackMDCAdapter) {
            Map logback = ((LogbackMDCAdapter)mdc).getPropertyMap();
            System.out.println("\u8fd9\u662fLogbackMDCAdapter\u7684\u94fe\u8defID" + (String)logback.get("PtxId"));
        } else {
            Map contextMap = mdc.getCopyOfContextMap();
            System.out.println("\u8fd9\u662fcontextMap\u7684\u94fe\u8defID" + (String)contextMap.get("PtxId"));
        }
        String upstream = SafeMdcTraceFilter.firstNonBlank((String[])new String[]{SafeMdcTraceFilter.header((HttpServletRequest)req, (String)"ja-trace-id"), SafeMdcTraceFilter.header((HttpServletRequest)req, (String)"x-b3-traceid"), SafeMdcTraceFilter.header((HttpServletRequest)req, (String)"traceparent")});
        String traceId = mdc.get("PtxId");
        if (StringUtils.isBlank((String)traceId)) {
            traceId = "agiledataecho-" + SafeMdcTraceFilter.safeCreateTraceId();
        }
        if (SafeMdcTraceFilter.isBlank((String)(reqId = SafeMdcTraceFilter.firstNonBlank((String[])new String[]{SafeMdcTraceFilter.header((HttpServletRequest)req, (String)"ja-req-id"), SafeMdcTraceFilter.header((HttpServletRequest)req, (String)"x-request-id")})))) {
            reqId = SafeMdcTraceFilter.genId();
        }
        try {
            MDC.put((String)"ja-trace-id", (String)traceId);
            MDC.put((String)"PtxId", (String)traceId);
            MDC.put((String)"ja-req-id", (String)reqId);
            JaMDC.put((String)traceId);
            mdc.put("PtxId", traceId);
            if (!SafeMdcTraceFilter.isBlank((String)upstream)) {
                MDC.put((String)"upstream-trace-id", (String)upstream);
            }
            resp.setHeader("ja-trace-id", traceId);
            resp.setHeader("ja-req-id", reqId);
            HeaderMaskingRequest wrapped = new HeaderMaskingRequest(req, BLOCKED_HEADERS);
            chain.doFilter((ServletRequest)wrapped, response);
        }
        finally {
            MDC.remove((String)"ja-trace-id");
            MDC.remove((String)"ja-req-id");
            MDC.remove((String)"traceId");
            MDC.remove((String)"PtxId");
            MDC.remove((String)"upstream-trace-id");
            MDC.remove((String)"PtxId");
            JaMDC.remove();
            req.removeAttribute(APPLIED_ATTR);
        }
    }

    private static String header(HttpServletRequest req, String name) {
        String v = req.getHeader(name);
        return v == null ? null : v.trim();
    }

    private static String parseTraceParent(String traceparent) {
        if (SafeMdcTraceFilter.isBlank((String)traceparent)) {
            return null;
        }
        String[] parts = traceparent.split("-");
        if (parts.length >= 4) {
            return parts[1];
        }
        return null;
    }

    private static boolean isBlank(String v) {
        return v == null || v.trim().isEmpty();
    }

    private static String firstNonBlank(String ... arr) {
        if (arr == null) {
            return null;
        }
        for (String s : arr) {
            if (SafeMdcTraceFilter.isBlank((String)s)) continue;
            return s.trim();
        }
        return null;
    }

    private static String genId() {
        return UUID.randomUUID().toString().replace("-", "");
    }

    private static String safeCreateTraceId() {
        try {
            return JaMDC.createTraceId();
        }
        catch (Throwable ignore) {
            return SafeMdcTraceFilter.genId();
        }
    }
}

