/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.athena.agiledataecho.controller;

import com.digiwin.athena.agiledataecho.dto.aiBoard.AIBoardQueryReq;
import com.digiwin.athena.agiledataecho.dto.aiBoard.EchoAIBoardDTO;
import com.digiwin.athena.agiledataecho.service.aiBoard.EchoAiBoardService;
import com.digiwin.athena.appcore.auth.domain.AuthoredUser;
import com.digiwin.athena.appcore.util.ResponseEntityWrapper;
import java.util.List;
import javax.servlet.http.HttpServletRequest;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestAttribute;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/api/ai/agile/echo/aiBoard"})
public class EchoAIBoardController {
    @Autowired
    private EchoAiBoardService echoAiBoardService;

    @PostMapping(value={"getBoard"})
    public ResponseEntity<?> getBoard(@RequestBody AIBoardQueryReq aiBoardQueryReq, @RequestAttribute(value="digi-middleware-auth-user-data", required=false) AuthoredUser user) {
        return ResponseEntityWrapper.wrapperOk((Object)this.echoAiBoardService.queryAgileDataAIBoard(user, aiBoardQueryReq));
    }

    @PostMapping(value={"saveBoard"})
    public ResponseEntity<?> saveBoard(@RequestBody EchoAIBoardDTO echoAIBoardDTO, @RequestAttribute(value="digi-middleware-auth-user-data", required=false) AuthoredUser user) {
        return ResponseEntityWrapper.wrapperOk((Object)this.echoAiBoardService.saveAgileDataAIBoard(user, echoAIBoardDTO));
    }

    @PostMapping(value={"updateBoard"})
    public ResponseEntity<?> updateBoard(@RequestBody EchoAIBoardDTO echoAIBoardDTO, @RequestAttribute(value="digi-middleware-auth-user-data", required=false) AuthoredUser user) {
        return ResponseEntityWrapper.wrapperOk((Object)this.echoAiBoardService.updateAgileDataAIBoard(user, echoAIBoardDTO));
    }

    @PostMapping(value={"deleteBoard"})
    public ResponseEntity<?> deleteBoard(@RequestBody AIBoardQueryReq aiBoardQueryReq, @RequestAttribute(value="digi-middleware-auth-user-data", required=false) AuthoredUser user) {
        return ResponseEntityWrapper.wrapperOk((Object)this.echoAiBoardService.deleteAgileDataAIBoard(user, aiBoardQueryReq));
    }

    @PostMapping(value={"getPreviewLayout"})
    public ResponseEntity<?> getPreviewLayout(HttpServletRequest request, @RequestBody AIBoardQueryReq aiBoardQueryReq, @RequestAttribute(value="digi-middleware-auth-user-data", required=false) AuthoredUser user) {
        String locale = request.getHeader("locale");
        List a = this.echoAiBoardService.getPreviewLayout(user, aiBoardQueryReq, locale);
        return ResponseEntityWrapper.wrapperOk((Object)a);
    }
}

