/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.athena.agiledataecho.controller;

import com.digiwin.athena.agiledataecho.dto.mongodb.MongoDbAddDTO;
import com.digiwin.athena.agiledataecho.dto.mongodb.MongoDbDeleteDTO;
import com.digiwin.athena.agiledataecho.dto.mongodb.MongoDbQueryDTO;
import com.digiwin.athena.agiledataecho.dto.mongodb.MongoDbUpdateDTO;
import com.digiwin.athena.appcore.util.ResponseEntityWrapper;
import com.mongodb.BasicDBObject;
import com.mongodb.DBObject;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.validation.Valid;
import org.apache.commons.collections.MapUtils;
import org.apache.commons.lang3.ObjectUtils;
import org.apache.commons.lang3.StringUtils;
import org.bson.types.ObjectId;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.data.mongodb.core.MongoTemplate;
import org.springframework.data.mongodb.core.query.Criteria;
import org.springframework.data.mongodb.core.query.CriteriaDefinition;
import org.springframework.data.mongodb.core.query.Query;
import org.springframework.data.mongodb.core.query.Update;
import org.springframework.data.mongodb.core.query.UpdateDefinition;
import org.springframework.http.ResponseEntity;
import org.springframework.util.CollectionUtils;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/api/ai/agile/echo/mongodb"})
public class MongoDbController {
    @Autowired
    @Qualifier(value="mongoTemplate")
    private MongoTemplate mongoTemplate;

    @GetMapping(value={"/query"})
    public ResponseEntity<?> query(@Valid MongoDbQueryDTO dto) {
        List mongoDbList;
        if (StringUtils.isNotBlank((CharSequence)dto.getWordOfCommand()) && !"\u771f\u561f\u5047\u561f".equals(dto.getWordOfCommand())) {
            return ResponseEntityWrapper.wrapperFail((int)-1, (String)"\u53e3\u4ee4\u9519\u8bef");
        }
        Query query = new Query();
        if (StringUtils.isNotBlank((CharSequence)dto.getId())) {
            query.addCriteria((CriteriaDefinition)Criteria.where((String)"_id").is((Object)dto.getId()));
        }
        if (StringUtils.isNotBlank((CharSequence)dto.getIncludeField())) {
            query.fields().include(dto.getIncludeField());
        }
        if (ObjectUtils.isNotEmpty((Object)dto.getDeleted())) {
            query.addCriteria((CriteriaDefinition)Criteria.where((String)"deleted").is((Object)false));
        }
        if (CollectionUtils.isEmpty((Collection)(mongoDbList = this.mongoTemplate.find(query, Map.class, dto.getCollectionName())))) {
            return ResponseEntityWrapper.wrapperOk((Object)"\u6682\u65e0\u6570\u636e");
        }
        ArrayList list = new ArrayList(mongoDbList.size());
        for (Map map : mongoDbList) {
            if (map.containsKey("_id")) {
                map.put("_id", String.valueOf(map.get("_id")));
            }
            list.add(new HashMap(map));
        }
        return ResponseEntityWrapper.wrapperOk(list);
    }

    @PostMapping(value={"/update"})
    public ResponseEntity<?> updateLoggingLevel(@RequestBody @Valid MongoDbUpdateDTO dto) {
        Map map;
        if (!"\u771f\u561f\u5047\u561f".equals(dto.getWordOfCommand())) {
            return ResponseEntityWrapper.wrapperFail((int)-1, (String)"\u53e3\u4ee4\u9519\u8bef");
        }
        String id = MapUtils.getString((Map)dto.getMapData(), (Object)"_id");
        if (StringUtils.isBlank((CharSequence)id)) {
            return ResponseEntityWrapper.wrapperFail((int)-1, (String)"ID\u4e0d\u80fd\u4e3a\u7a7a");
        }
        Query query = new Query((CriteriaDefinition)Criteria.where((String)"_id").is((Object)id));
        Update update = new Update();
        if (ObjectUtils.isNotEmpty((Object)dto.getMapData())) {
            dto.getMapData().forEach((arg_0, arg_1) -> ((Update)update).set(arg_0, arg_1));
            this.mongoTemplate.updateFirst(query, (UpdateDefinition)update, dto.getCollectionName());
        }
        if ((map = (Map)this.mongoTemplate.findById((Object)id, Map.class, dto.getCollectionName())) == null) {
            return ResponseEntityWrapper.wrapperFail((int)-1, (String)"\u672a\u627e\u5230\u66f4\u65b0\u540e\u7684\u6570\u636e");
        }
        return ResponseEntityWrapper.wrapperOk((Object)map);
    }

    @PostMapping(value={"/add"})
    public ResponseEntity<?> add(@RequestBody @Valid MongoDbAddDTO dto) {
        if (!"\u771f\u561f\u5047\u561f".equals(dto.getWordOfCommand())) {
            return ResponseEntityWrapper.wrapperFail((int)-1, (String)"\u53e3\u4ee4\u9519\u8bef");
        }
        if (ObjectUtils.isEmpty((Object)dto.getMapData())) {
            return ResponseEntityWrapper.wrapperFail((int)-1, (String)"mapData\u4e3a\u7a7a");
        }
        String roleId = MapUtils.getString((Map)dto.getMapData(), (Object)"roleId");
        if (StringUtils.isNotBlank((CharSequence)roleId) && this.mongoTemplate.exists(new Query((CriteriaDefinition)Criteria.where((String)"roleId").is((Object)roleId)), dto.getCollectionName())) {
            return ResponseEntityWrapper.wrapperFail((int)-1, (String)"mapData\u4e2d\u5bf9\u5e94roleId\u5df2\u5b58\u5728,\u8bf7\u52ff\u91cd\u590d\u6dfb\u52a0");
        }
        try {
            BasicDBObject dbObject = new BasicDBObject(dto.getMapData());
            DBObject result = (DBObject)this.mongoTemplate.save((Object)dbObject, dto.getCollectionName());
            return ResponseEntityWrapper.wrapperOk((Object)result);
        }
        catch (Exception e) {
            return ResponseEntityWrapper.wrapperFail((int)-1, (String)("\u6dfb\u52a0\u6570\u636e\u5931\u8d25: " + e.getMessage()));
        }
    }

    @PostMapping(value={"/delete"})
    public ResponseEntity<?> delete(@RequestBody @Valid MongoDbDeleteDTO dto) {
        if (StringUtils.isNotBlank((CharSequence)dto.getWordOfCommand()) && !"\u771f\u561f\u5047\u561f".equals(dto.getWordOfCommand())) {
            return ResponseEntityWrapper.wrapperFail((int)-1, (String)"\u53e3\u4ee4\u9519\u8bef");
        }
        Map dataMap = (Map)this.mongoTemplate.findById((Object)new ObjectId(dto.getId()), Map.class, dto.getCollectionName());
        if (CollectionUtils.isEmpty((Map)dataMap)) {
            return ResponseEntityWrapper.wrapperFail((int)-1, (String)"\u6b64id\u5bf9\u5e94\u6570\u636e\u4e0d\u5b58\u5728");
        }
        Query query = new Query();
        query.addCriteria((CriteriaDefinition)Criteria.where((String)"_id").is((Object)dto.getId()));
        this.mongoTemplate.remove(query, dto.getCollectionName());
        return ResponseEntityWrapper.wrapperOk();
    }
}

