/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.athena.agiledataecho.proxy.knowledgemaps.impl;

import com.digiwin.athena.agiledataecho.app.env.EchoEnvProperties;
import com.digiwin.athena.agiledataecho.constant.ErrorCodeEnum;
import com.digiwin.athena.agiledataecho.proxy.AthenaDapApiResponse;
import com.digiwin.athena.agiledataecho.proxy.knowledgemaps.KnowledgeMapsService;
import com.digiwin.athena.agiledataecho.proxy.knowledgemaps.model.KMCommandIntentionsDTO;
import com.digiwin.athena.agiledataecho.proxy.knowledgemaps.model.KnowledgeMapsSceneIntentionModel;
import com.digiwin.athena.agiledataecho.proxy.knowledgemaps.model.KnowledgeMapsTenantPurchasedAgileDataApplicationModel;
import com.digiwin.athena.appcore.util.ExceptionUtil;
import java.util.Collections;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.core.ParameterizedTypeReference;
import org.springframework.http.HttpEntity;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpMethod;
import org.springframework.http.ResponseEntity;
import org.springframework.stereotype.Service;
import org.springframework.util.MultiValueMap;
import org.springframework.web.client.RestTemplate;

@Service
public class KnowledgeMapsServiceImpl
implements KnowledgeMapsService {
    private static final Logger log = LoggerFactory.getLogger(KnowledgeMapsServiceImpl.class);
    @Autowired
    EchoEnvProperties echoEnvProperties;
    @Autowired
    private RestTemplate restTemplate;
    @Value(value="${appToken:}")
    private String appToken;

    public List<KnowledgeMapsTenantPurchasedAgileDataApplicationModel> queryTenantPurchasedAgileDataApplicationList(String token, String tenantId) {
        String url = this.echoEnvProperties.getKnowledgeMapsUrl() + "knowledgegraph/tenant/tenantMetricApplication";
        HttpHeaders headers = new HttpHeaders();
        headers.add("digi-middleware-auth-user", token);
        headers.add("routerKey", tenantId);
        headers.add("digi-middleware-auth-app", this.appToken);
        HttpEntity httpEntity = new HttpEntity((MultiValueMap)headers);
        try {
            ResponseEntity response = this.restTemplate.exchange(url, HttpMethod.GET, httpEntity, (ParameterizedTypeReference)new /* Unavailable Anonymous Inner Class!! */, new Object[0]);
            if (response.getStatusCode().is2xxSuccessful() && response.getBody() != null) {
                return (List)((AthenaDapApiResponse)response.getBody()).getResponse();
            }
        }
        catch (Exception e) {
            log.error("{}\n,\u8bf7\u6c42url:{}\n, \u8bf7\u6c42token:{}\n,\u8bf7\u6c42tenantId:{}\n,\u62a5\u9519\u4fe1\u606f\uff1a{} ", new Object[]{ErrorCodeEnum.KM_QUERY_PURCHASED_AGILE_DATA_APPLICATION_FAIL.getErrCode(), url, token, tenantId, e.getMessage()});
            throw ExceptionUtil.wrap((String)ErrorCodeEnum.KM_QUERY_PURCHASED_AGILE_DATA_APPLICATION_FAIL.getErrCode(), (Exception)e);
        }
        return Collections.emptyList();
    }

    public List<KnowledgeMapsSceneIntentionModel> querySceneIntention(String token, String tenantId, String locale) {
        String url = this.echoEnvProperties.getKnowledgeMapsUrl() + "knowledgegraph/scene/querySceneIntention";
        HttpHeaders headers = new HttpHeaders();
        headers.add("digi-middleware-auth-user", token);
        headers.add("routerKey", tenantId);
        headers.add("digi-middleware-auth-app", this.appToken);
        headers.add("locale", locale);
        HttpEntity httpEntity = new HttpEntity((MultiValueMap)headers);
        try {
            ResponseEntity response = this.restTemplate.exchange(url, HttpMethod.POST, httpEntity, (ParameterizedTypeReference)new /* Unavailable Anonymous Inner Class!! */, new Object[0]);
            if (response.getStatusCode().is2xxSuccessful() && response.getBody() != null) {
                return (List)((AthenaDapApiResponse)response.getBody()).getResponse();
            }
        }
        catch (Exception e) {
            log.error("{}\n,\u8bf7\u6c42url:{}\n, \u8bf7\u6c42token:{}\n,\u8bf7\u6c42tenantId:{}\n,\u62a5\u9519\u4fe1\u606f\uff1a{} ", new Object[]{ErrorCodeEnum.KM_QUERY_SCENE_INTENTION_FAIL.getErrCode(), url, token, tenantId, e.getMessage()});
        }
        return Collections.emptyList();
    }

    public List<KMCommandIntentionsDTO> queryCommandIntentions(String token, String userId, String tenantId, String locale) {
        String url = this.echoEnvProperties.getKnowledgeMapsUrl() + "knowledgegraph/command/queryAllCommandIntentions?userId=" + userId;
        HttpHeaders headers = new HttpHeaders();
        headers.add("digi-middleware-auth-user", token);
        headers.add("routerKey", tenantId);
        headers.add("digi-middleware-auth-app", this.appToken);
        headers.add("locale", locale);
        HttpEntity httpEntity = new HttpEntity((MultiValueMap)headers);
        try {
            ResponseEntity response = this.restTemplate.exchange(url, HttpMethod.GET, httpEntity, (ParameterizedTypeReference)new /* Unavailable Anonymous Inner Class!! */, new Object[0]);
            if (response.getStatusCode().is2xxSuccessful() && response.getBody() != null) {
                return (List)((AthenaDapApiResponse)response.getBody()).getResponse();
            }
        }
        catch (Exception e) {
            log.error("{}\n,\u8bf7\u6c42url:{}\n, \u8bf7\u6c42token:{}\n,\u8bf7\u6c42tenantId:{}\n,\u62a5\u9519\u4fe1\u606f\uff1a{} ", new Object[]{ErrorCodeEnum.KM_QUERY_SCENE_INTENTION_FAIL.getErrCode(), url, token, tenantId, e.getMessage()});
        }
        return Collections.emptyList();
    }
}

