/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.athena.agiledataecho.proxy.scrumbi.dto;

import com.digiwin.athena.agiledataecho.dto.aiBoard.EchoAIBoardDTO;
import com.digiwin.athena.agiledataecho.proxy.scrumbi.dto.ScrumBILayoutReq;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.compress.utils.Lists;

public class ScrumBILayoutReq {
    private LayoutData data;

    public static ScrumBILayoutReq buildScrumBILayoutReq(EchoAIBoardDTO echoAIBoardDTO) {
        ScrumBILayoutReq scrumBILayoutReq = new ScrumBILayoutReq();
        LayoutData data = new LayoutData();
        scrumBILayoutReq.setData(data);
        data.setBoardTitle(echoAIBoardDTO.getBoardTitle());
        if (CollectionUtils.isNotEmpty((Collection)echoAIBoardDTO.getQuestionInfo())) {
            ArrayList boardDesigns = Lists.newArrayList();
            data.setBoardDesign((List)boardDesigns);
            echoAIBoardDTO.getQuestionInfo().stream().forEach(questionInfo -> {
                BoardDesign boardDesign = new BoardDesign();
                boardDesign.setId(questionInfo.getQuestionId());
                boardDesign.setChartTitle(questionInfo.getQuestion());
                boardDesign.setQuestion(questionInfo.getQuestion());
                boardDesign.setChartType(questionInfo.getShowType());
                boardDesign.setDataSetId(questionInfo.getDatasetIds());
                boardDesigns.add(boardDesign);
            });
        }
        return scrumBILayoutReq;
    }

    public LayoutData getData() {
        return this.data;
    }

    public void setData(LayoutData data) {
        this.data = data;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ScrumBILayoutReq)) {
            return false;
        }
        ScrumBILayoutReq other = (ScrumBILayoutReq)o;
        if (!other.canEqual((Object)this)) {
            return false;
        }
        LayoutData this$data = this.getData();
        LayoutData other$data = other.getData();
        return !(this$data == null ? other$data != null : !this$data.equals(other$data));
    }

    protected boolean canEqual(Object other) {
        return other instanceof ScrumBILayoutReq;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        LayoutData $data = this.getData();
        result = result * 59 + ($data == null ? 43 : $data.hashCode());
        return result;
    }

    public String toString() {
        return "ScrumBILayoutReq(data=" + this.getData() + ")";
    }
}

