/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.athena.agiledataecho.proxy.scrumbi.impl;

import com.digiwin.athena.agiledataecho.app.env.EchoEnvProperties;
import com.digiwin.athena.agiledataecho.dto.aiBoard.EchoAIBoardLayoutDTO;
import com.digiwin.athena.agiledataecho.dto.aiBoard.EchoAIBoardLayoutGroupDTO;
import com.digiwin.athena.agiledataecho.proxy.scrumbi.ScrumBIService;
import com.digiwin.athena.agiledataecho.proxy.scrumbi.dto.ScrumBILayoutReq;
import com.digiwin.athena.agiledataecho.proxy.scrumbi.dto.ScrumBILayoutRes;
import com.digiwin.athena.appcore.auth.domain.AuthoredUser;
import com.digiwin.athena.appcore.util.JsonUtils;
import com.fasterxml.jackson.core.type.TypeReference;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.core.ParameterizedTypeReference;
import org.springframework.http.HttpEntity;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpMethod;
import org.springframework.http.ResponseEntity;
import org.springframework.stereotype.Service;
import org.springframework.util.MultiValueMap;
import org.springframework.util.ObjectUtils;
import org.springframework.web.client.RestTemplate;

@Service
public class ScrumBIServiceImpl
implements ScrumBIService {
    private static final Logger log = LoggerFactory.getLogger(ScrumBIServiceImpl.class);
    @Autowired
    EchoEnvProperties echoEnvProperties;
    @Autowired
    private RestTemplate restTemplate;

    public List<EchoAIBoardLayoutDTO> getAIBoardLayout(AuthoredUser user, ScrumBILayoutReq aiBoardQueryReq, String locale) {
        String url = this.echoEnvProperties.getChatBIUrl() + "/scrumbi/layout/design";
        try {
            HttpHeaders headers = new HttpHeaders();
            headers.add("locale", locale);
            headers.add("routerkey", user.getTenantId());
            headers.add("token", user.getToken());
            headers.add("proxy_token", user.getToken());
            headers.add("security-token", null);
            HttpEntity requestEntity = new HttpEntity((Object)aiBoardQueryReq, (MultiValueMap)headers);
            ResponseEntity resultDTOResponseEntity = this.restTemplate.exchange(url, HttpMethod.POST, requestEntity, (ParameterizedTypeReference)new /* Unavailable Anonymous Inner Class!! */, new Object[0]);
            if (resultDTOResponseEntity.getBody() != null && Objects.equals(((ScrumBILayoutRes)resultDTOResponseEntity.getBody()).getCode(), "200")) {
                ScrumBILayoutRes.ScrumBILayoutData data = ((ScrumBILayoutRes)resultDTOResponseEntity.getBody()).getData();
                log.info("\u83b7\u53d6\u8bed\u4e49\u751f\u6210\u5e03\u5c40\u4fe1\u606f,{}", (Object)JsonUtils.objectToString((Object)data));
                if (!ObjectUtils.isEmpty((Object)data) && Objects.equals(data.getCode(), "0")) {
                    EchoAIBoardLayoutGroupDTO groupDTO = (EchoAIBoardLayoutGroupDTO)JsonUtils.jsonToObject((String)JsonUtils.objectToString((Object)data.getData()), EchoAIBoardLayoutGroupDTO.class);
                    if (ObjectUtils.isEmpty((Object)groupDTO.getLayout())) {
                        return new ArrayList<EchoAIBoardLayoutDTO>();
                    }
                    return (List)JsonUtils.jsonToObject((String)JsonUtils.objectToString((Object)groupDTO.getLayout()), (TypeReference)new /* Unavailable Anonymous Inner Class!! */);
                }
            }
            return new ArrayList<EchoAIBoardLayoutDTO>();
        }
        catch (Exception e) {
            log.error("\u83b7\u53d6\u8bed\u4e49\u751f\u6210\u5e03\u5c40\u5931\u8d25\uff0c{}", (Object)e.getMessage());
            return new ArrayList<EchoAIBoardLayoutDTO>();
        }
    }
}

