/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.athena.agiledataecho.service.aiBoard.impl;

import cn.hutool.json.JSONUtil;
import com.digiwin.athena.agiledataecho.dto.aiBoard.AIBoardLayout;
import com.digiwin.athena.agiledataecho.dto.aiBoard.AIBoardQueryReq;
import com.digiwin.athena.agiledataecho.dto.aiBoard.EchoAIBoardDTO;
import com.digiwin.athena.agiledataecho.proxy.scrumbi.ScrumBIService;
import com.digiwin.athena.agiledataecho.proxy.scrumbi.dto.ScrumBILayoutReq;
import com.digiwin.athena.agiledataecho.service.aiBoard.EchoAiBoardService;
import com.digiwin.athena.appcore.auth.domain.AuthoredUser;
import com.digiwin.athena.appcore.util.JsonUtils;
import com.digiwin.athena.show.component.gridster.GridGroupDTO;
import com.digiwin.athena.show.domain.agileDataDTO.ConvertAgileDataRelation;
import com.digiwin.athena.show.util.layout.BoardLayoutPlanner;
import com.mongodb.BasicDBObject;
import java.time.LocalTime;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.collections.MapUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.data.mongodb.core.MongoTemplate;
import org.springframework.data.mongodb.core.query.Criteria;
import org.springframework.data.mongodb.core.query.CriteriaDefinition;
import org.springframework.data.mongodb.core.query.Query;
import org.springframework.data.mongodb.core.query.Update;
import org.springframework.data.mongodb.core.query.UpdateDefinition;
import org.springframework.stereotype.Service;

@Service
public class EchoAiBoardServiceImpl
implements EchoAiBoardService {
    private static final Logger log = LoggerFactory.getLogger(EchoAiBoardServiceImpl.class);
    @Autowired
    @Qualifier(value="mongoAgileDataPageViewTemplate")
    private MongoTemplate mongoAgileDataPageViewTemplate;
    @Autowired
    private ScrumBIService scrumBIService;
    private static final String MONGODB_COLLECTION_NAME = "agile_data_aiBoard";

    public Boolean saveAgileDataAIBoard(AuthoredUser user, EchoAIBoardDTO echoAIBoardDTO) {
        if (echoAIBoardDTO == null) {
            return false;
        }
        echoAIBoardDTO.setTenantId(user.getTenantId());
        echoAIBoardDTO.setUserId(user.getUserId());
        echoAIBoardDTO.setCreateTime(LocalTime.now());
        this.mongoAgileDataPageViewTemplate.insert((Object)echoAIBoardDTO, MONGODB_COLLECTION_NAME);
        return true;
    }

    public Boolean updateAgileDataAIBoard(AuthoredUser user, EchoAIBoardDTO echoAIBoardDTO) {
        if (echoAIBoardDTO == null) {
            return false;
        }
        echoAIBoardDTO.setTenantId(user.getTenantId());
        echoAIBoardDTO.setUserId(user.getUserId());
        if (CollectionUtils.isNotEmpty((Collection)echoAIBoardDTO.getQuestionInfo())) {
            echoAIBoardDTO.getQuestionInfo().stream().forEach(questionInfo -> {
                Query query = new Query((CriteriaDefinition)Criteria.where((String)"messageId").is((Object)echoAIBoardDTO.getMessageId()).and("tenantId").is((Object)user.getTenantId()).and("questionInfo.questionId").is((Object)questionInfo.getQuestionId()).and("userId").is((Object)user.getUserId()));
                Update update = new Update();
                if (echoAIBoardDTO.getMessageStatus() != null) {
                    update.set("messageStatus", (Object)echoAIBoardDTO.getMessageStatus());
                }
                if (MapUtils.isNotEmpty((Map)questionInfo.getGetDataParams())) {
                    update.set("questionInfo.$.getDataParams", (Object)questionInfo.getGetDataParams());
                }
                if (questionInfo.getAnalyzeStatus() != null) {
                    update.set("questionInfo.$.analyzeStatus", (Object)questionInfo.getAnalyzeStatus());
                }
                if (questionInfo.getAnalyzeResult() != null) {
                    update.set("questionInfo.$.analyzeResult", (Object)questionInfo.getAnalyzeResult());
                }
                if (Objects.nonNull(questionInfo.getAnalyzeMessageId())) {
                    update.set("questionInfo.$.analyzeMessageId", (Object)questionInfo.getAnalyzeMessageId());
                }
                update.set("updateTime", (Object)LocalTime.now());
                this.mongoAgileDataPageViewTemplate.updateFirst(query, (UpdateDefinition)update, MONGODB_COLLECTION_NAME);
            });
        } else {
            Query query = new Query((CriteriaDefinition)Criteria.where((String)"messageId").is((Object)echoAIBoardDTO.getMessageId()).and("tenantId").is((Object)user.getTenantId()).and("userId").is((Object)user.getUserId()));
            Update update = new Update();
            if (echoAIBoardDTO.getMessageStatus() != null) {
                update.set("messageStatus", (Object)echoAIBoardDTO.getMessageStatus());
            }
            if (echoAIBoardDTO.getBoardLayout() != null) {
                update.set("boardLayout", (Object)echoAIBoardDTO.getBoardLayout());
            }
            if (echoAIBoardDTO.getPreviewLayout() != null) {
                update.set("previewLayout", (Object)echoAIBoardDTO.getPreviewLayout());
            }
            if (StringUtils.isNotEmpty((CharSequence)echoAIBoardDTO.getBoardId())) {
                update.set("boardId", (Object)echoAIBoardDTO.getBoardId());
            }
            update.set("updateTime", (Object)LocalTime.now());
            this.mongoAgileDataPageViewTemplate.updateFirst(query, (UpdateDefinition)update, MONGODB_COLLECTION_NAME);
        }
        return true;
    }

    public Boolean deleteAgileDataAIBoard(AuthoredUser user, AIBoardQueryReq aiBoardQueryReq) {
        if (aiBoardQueryReq == null) {
            return false;
        }
        Query query = Query.query((CriteriaDefinition)Criteria.where((String)"userId").is((Object)user.getUserId()).and("tenantId").is((Object)user.getTenantId()).and("messageId").is((Object)aiBoardQueryReq.getMessageId()));
        if (CollectionUtils.isNotEmpty((Collection)aiBoardQueryReq.getQuestionIds())) {
            BasicDBObject pullCondition = new BasicDBObject("questionId", (Object)new BasicDBObject("$in", (Object)aiBoardQueryReq.getQuestionIds()));
            Update update = new Update();
            update.pull("questionInfo", (Object)pullCondition);
            this.mongoAgileDataPageViewTemplate.updateFirst(query, (UpdateDefinition)update, MONGODB_COLLECTION_NAME);
        } else {
            this.mongoAgileDataPageViewTemplate.remove(query, MONGODB_COLLECTION_NAME);
        }
        return true;
    }

    public EchoAIBoardDTO queryAgileDataAIBoard(AuthoredUser user, AIBoardQueryReq aiBoardQueryReq) {
        if (aiBoardQueryReq == null) {
            return null;
        }
        if (aiBoardQueryReq.getMessageId() == null) {
            return null;
        }
        Query query = Query.query((CriteriaDefinition)Criteria.where((String)"userId").is((Object)user.getUserId()).and("tenantId").is((Object)user.getTenantId()).and("messageId").is((Object)aiBoardQueryReq.getMessageId()));
        EchoAIBoardDTO echoAIBoardDTO = (EchoAIBoardDTO)this.mongoAgileDataPageViewTemplate.findOne(query, EchoAIBoardDTO.class, MONGODB_COLLECTION_NAME);
        if (echoAIBoardDTO == null) {
            return null;
        }
        if (CollectionUtils.isNotEmpty((Collection)aiBoardQueryReq.getQuestionIds()) && CollectionUtils.isNotEmpty((Collection)echoAIBoardDTO.getQuestionInfo())) {
            echoAIBoardDTO.getQuestionInfo().removeIf(questionInfo -> !aiBoardQueryReq.getQuestionIds().contains(questionInfo.getQuestionId()));
        }
        return echoAIBoardDTO;
    }

    public List<GridGroupDTO> getPreviewLayout(AuthoredUser user, AIBoardQueryReq aiBoardQueryReq, String locale) {
        List gridGroupDTOS;
        log.info("\u9884\u89c8\u770b\u677f\u5e03\u5c40\uff0c\u5165\u53c2\uff1a{}", (Object)JsonUtils.objectToString((Object)aiBoardQueryReq));
        EchoAIBoardDTO echoAIBoardDTO = this.queryAgileDataAIBoard(user, aiBoardQueryReq);
        if (echoAIBoardDTO == null) {
            log.error("\u83b7\u53d6\u53ef\u751f\u6210\u770b\u677f\u6570\u636e\u4e3a\u7a7a,{}", (Object)aiBoardQueryReq.getMessageId());
            return null;
        }
        if (echoAIBoardDTO.getPreviewLayout() != null) {
            return ConvertAgileDataRelation.createAILayout((AIBoardLayout)echoAIBoardDTO.getPreviewLayout());
        }
        List layoutDTOList = this.scrumBIService.getAIBoardLayout(user, ScrumBILayoutReq.buildScrumBILayoutReq((EchoAIBoardDTO)echoAIBoardDTO), locale);
        if (CollectionUtils.isEmpty((Collection)layoutDTOList)) {
            return null;
        }
        log.info("layoutDTOList:{}", (Object)JSONUtil.toJsonStr((Object)layoutDTOList));
        AIBoardLayout aiBoardLayout = echoAIBoardDTO.getBoardLayout();
        aiBoardLayout = BoardLayoutPlanner.getAiBoardLayout((List)layoutDTOList, (EchoAIBoardDTO)echoAIBoardDTO, (AIBoardLayout)aiBoardLayout);
        boolean hasLightFields = aiBoardLayout.getCharts().stream().anyMatch(c -> c.getImportance() != null || c.getRow() != null);
        if (hasLightFields) {
            int layoutCols = aiBoardLayout.getOverallLayout() != null && aiBoardLayout.getOverallLayout().getLayoutCols() != null ? aiBoardLayout.getOverallLayout().getLayoutCols() : 12;
            int layoutRows = aiBoardLayout.getOverallLayout() != null && aiBoardLayout.getOverallLayout().getLayoutRows() != null ? aiBoardLayout.getOverallLayout().getLayoutRows() : 18;
            List seeds = BoardLayoutPlanner.getSeedList((AIBoardLayout)aiBoardLayout, (EchoAIBoardDTO)echoAIBoardDTO);
            if (!seeds.isEmpty()) {
                AIBoardLayout planned = BoardLayoutPlanner.plan((List)seeds, (int)layoutCols, (int)layoutRows);
                echoAIBoardDTO.setBoardLayout(planned);
                aiBoardLayout = planned;
            }
        }
        if (CollectionUtils.isEmpty((Collection)(gridGroupDTOS = ConvertAgileDataRelation.createAILayout((AIBoardLayout)aiBoardLayout)))) {
            return gridGroupDTOS;
        }
        this.updateAgileDataAIBoard(user, this.buildLayoutParams(aiBoardLayout, aiBoardQueryReq));
        return gridGroupDTOS;
    }

    private EchoAIBoardDTO buildLayoutParams(AIBoardLayout aiBoardLayout, AIBoardQueryReq aiBoardQueryReq) {
        EchoAIBoardDTO echoAIBoardDTO = new EchoAIBoardDTO();
        echoAIBoardDTO.setMessageId(aiBoardQueryReq.getMessageId());
        echoAIBoardDTO.setPreviewLayout(aiBoardLayout);
        return echoAIBoardDTO;
    }
}

