/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.athena.agiledataecho.service.autoData.impl;

import com.digiwin.athena.agiledataecho.dto.autoData.EchoAutoDataDTO;
import com.digiwin.athena.agiledataecho.service.autoData.EchoAutoDataService;
import com.digiwin.athena.appcore.auth.domain.AuthoredUser;
import java.time.LocalTime;
import org.apache.commons.lang.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.data.mongodb.core.MongoTemplate;
import org.springframework.data.mongodb.core.query.Criteria;
import org.springframework.data.mongodb.core.query.CriteriaDefinition;
import org.springframework.data.mongodb.core.query.Query;
import org.springframework.data.mongodb.core.query.Update;
import org.springframework.data.mongodb.core.query.UpdateDefinition;
import org.springframework.stereotype.Service;

@Service
public class EchoAutoDataServiceImpl
implements EchoAutoDataService {
    @Autowired
    @Qualifier(value="mongoAgileDataPageViewTemplate")
    private MongoTemplate mongoAgileDataPageViewTemplate;
    private static final String MONGODB_COLLECTION_NAME = "agile_data_autoData_report";

    public Boolean saveAgileDataAutoData(AuthoredUser user, EchoAutoDataDTO echoAutoDataDTO) {
        if (echoAutoDataDTO == null) {
            return false;
        }
        if (echoAutoDataDTO.getMessageId() == null) {
            return false;
        }
        echoAutoDataDTO.setUserId(user.getUserId());
        echoAutoDataDTO.setUserName(user.getUserName());
        echoAutoDataDTO.setTenantId(user.getTenantId());
        echoAutoDataDTO.setCreateTime(LocalTime.now());
        this.mongoAgileDataPageViewTemplate.insert((Object)echoAutoDataDTO, MONGODB_COLLECTION_NAME);
        return true;
    }

    public Boolean updateAgileDataAutoData(AuthoredUser user, EchoAutoDataDTO echoAutoDataDTO) {
        if (echoAutoDataDTO == null) {
            return false;
        }
        Query query = Query.query((CriteriaDefinition)Criteria.where((String)"userId").is((Object)user.getUserId()).and("tenantId").is((Object)user.getTenantId()).and("messageId").is((Object)echoAutoDataDTO.getMessageId()));
        Update update = new Update();
        if (StringUtils.isNotEmpty((String)echoAutoDataDTO.getStatus())) {
            update.set("status", (Object)echoAutoDataDTO.getStatus());
        }
        if (StringUtils.isNotEmpty((String)echoAutoDataDTO.getPdfUrl())) {
            update.set("pdfUrl", (Object)echoAutoDataDTO.getPdfUrl());
        }
        if (StringUtils.isNotEmpty((String)echoAutoDataDTO.getWordUrl())) {
            update.set("wordUrl", (Object)echoAutoDataDTO.getWordUrl());
        }
        if (StringUtils.isNotEmpty((String)echoAutoDataDTO.getLimitDay())) {
            update.set("limitDay", (Object)echoAutoDataDTO.getLimitDay());
        }
        if (StringUtils.isNotEmpty((String)echoAutoDataDTO.getPdfCreateDate())) {
            update.set("pdfCreateDate", (Object)echoAutoDataDTO.getPdfCreateDate());
        }
        if (StringUtils.isNotEmpty((String)echoAutoDataDTO.getWordCreateDate())) {
            update.set("wordCreateDate", (Object)echoAutoDataDTO.getWordCreateDate());
        }
        if (StringUtils.isNotEmpty((String)echoAutoDataDTO.getPdfExpireDate())) {
            update.set("pdfExpireDate", (Object)echoAutoDataDTO.getPdfExpireDate());
        }
        if (StringUtils.isNotEmpty((String)echoAutoDataDTO.getWordExpireDate())) {
            update.set("wordExpireDate", (Object)echoAutoDataDTO.getWordExpireDate());
        }
        if (StringUtils.isNotEmpty((String)echoAutoDataDTO.getShowDmcId())) {
            update.set("showDmcId", (Object)echoAutoDataDTO.getShowDmcId());
        }
        update.set("updateTime", (Object)LocalTime.now());
        this.mongoAgileDataPageViewTemplate.updateFirst(query, (UpdateDefinition)update, MONGODB_COLLECTION_NAME);
        return true;
    }

    public Boolean deleteAgileDataAutoData(AuthoredUser user, EchoAutoDataDTO echoAutoDataDTO) {
        if (echoAutoDataDTO == null) {
            return false;
        }
        Query query = Query.query((CriteriaDefinition)Criteria.where((String)"userId").is((Object)user.getUserId()).and("tenantId").is((Object)user.getTenantId()).and("messageId").is((Object)echoAutoDataDTO.getMessageId()));
        this.mongoAgileDataPageViewTemplate.remove(query, MONGODB_COLLECTION_NAME);
        return true;
    }

    public EchoAutoDataDTO queryAgileDataAutoData(AuthoredUser user, EchoAutoDataDTO echoAutoDataDTO) {
        if (echoAutoDataDTO == null) {
            return null;
        }
        Query query = Query.query((CriteriaDefinition)Criteria.where((String)"userId").is((Object)user.getUserId()).and("tenantId").is((Object)user.getTenantId()).and("messageId").is((Object)echoAutoDataDTO.getMessageId()));
        if (StringUtils.isNotEmpty((String)echoAutoDataDTO.getStatus())) {
            query.addCriteria((CriteriaDefinition)Criteria.where((String)"status").is((Object)echoAutoDataDTO.getStatus()));
        }
        return (EchoAutoDataDTO)this.mongoAgileDataPageViewTemplate.findOne(query, EchoAutoDataDTO.class, MONGODB_COLLECTION_NAME);
    }
}

