/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.athena.agiledataecho.service.imp;

import com.digiwin.athena.agiledataecho.constant.TroubleToolCodeEnum;
import com.digiwin.athena.agiledataecho.dao.EchoInformationMapper;
import com.digiwin.athena.agiledataecho.domain.EchoInformation;
import com.digiwin.athena.agiledataecho.dto.AgileDataAnalysisDTO;
import com.digiwin.athena.agiledataecho.dto.EchoInformationReqDTO;
import com.digiwin.athena.agiledataecho.dto.EchoInformationResDTO;
import com.digiwin.athena.agiledataecho.dto.EchoQueryBackIdReqDTO;
import com.digiwin.athena.agiledataecho.dto.EchoSelectMultipleReqDTO;
import com.digiwin.athena.agiledataecho.dto.mongodb.metric.MetricCheckResDTO;
import com.digiwin.athena.agiledataecho.mongodb.domain.EchoInfoMongoData;
import com.digiwin.athena.agiledataecho.mongodb.domain.EchoSelectMultiple;
import com.digiwin.athena.agiledataecho.mongodb.domain.MetricCheckMongoData;
import com.digiwin.athena.agiledataecho.proxy.ade.AgileDataEngineService;
import com.digiwin.athena.agiledataecho.proxy.ade.model.AgileDataEngineAnalysisModel;
import com.digiwin.athena.agiledataecho.proxy.iam.UserService;
import com.digiwin.athena.agiledataecho.service.AbsEchoService;
import com.digiwin.athena.agiledataecho.service.EchoInformationService;
import com.digiwin.athena.agiledataecho.util.LogUtils;
import com.digiwin.athena.appcore.auth.domain.AuthoredUser;
import com.digiwin.athena.appcore.util.JsonUtils;
import com.digiwin.athena.appcore.util.MessageUtils;
import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.CompletableFuture;
import java.util.function.Function;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.collections.MapUtils;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.data.mongodb.core.MongoTemplate;
import org.springframework.data.mongodb.core.query.Criteria;
import org.springframework.data.mongodb.core.query.CriteriaDefinition;
import org.springframework.data.mongodb.core.query.Query;
import org.springframework.data.mongodb.core.query.Update;
import org.springframework.data.mongodb.core.query.UpdateDefinition;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class EchoInformationServiceImpl
extends AbsEchoService
implements EchoInformationService {
    private static final Logger log = LoggerFactory.getLogger(EchoInformationServiceImpl.class);
    @Autowired
    @Qualifier(value="mongoTemplate")
    private MongoTemplate mongoTemplate;
    @Resource
    private EchoInformationMapper echoInformationMapper;
    @Autowired
    private UserService userService;
    @Autowired
    private MessageUtils messageUtils;
    @Autowired
    private AgileDataEngineService agileDataEngineService;

    @Transactional
    public void submit(EchoInformationReqDTO echoInformationReqDTO, AuthoredUser user) {
        EchoInformation echoInformation = EchoInformation.CopySubStrBean((EchoInformationReqDTO)echoInformationReqDTO);
        echoInformation.setCreateTime(new Date());
        AbsEchoService.TranslationService translationService = new AbsEchoService.TranslationService();
        ArrayList<String> translates = new ArrayList<String>();
        translates.add(echoInformation.getDescription());
        translates.add(echoInformation.getContent());
        translates.add(echoInformation.getExtend());
        translates.add(echoInformation.getAppName());
        List<CompletableFuture> translationFutures = translates.stream().map(arg_0 -> ((AbsEchoService.TranslationService)translationService).translate(arg_0)).collect(Collectors.toList());
        CompletableFuture<Void> allTranslations = CompletableFuture.allOf(translationFutures.toArray(new CompletableFuture[0]));
        ((CompletableFuture)allTranslations.thenRun(() -> {
            echoInformation.setComplexDescription((String)((CompletableFuture)translationFutures.get(0)).join());
            echoInformation.setComplexContent((String)((CompletableFuture)translationFutures.get(1)).join());
            echoInformation.setComplexExtend((String)((CompletableFuture)translationFutures.get(2)).join());
            echoInformation.setComplexAppName((String)((CompletableFuture)translationFutures.get(3)).join());
            this.echoInformationMapper.insert((Object)echoInformation);
        })).join();
    }

    public List<EchoInformationResDTO> getExceptionInfoByMessageId(String messageId, AuthoredUser user) {
        ArrayList<EchoInformationResDTO> results = new ArrayList<EchoInformationResDTO>();
        List echoInfos = this.echoInformationMapper.getExceptionInfoByMessageId(messageId);
        if (CollectionUtils.isEmpty((Collection)echoInfos)) {
            return new ArrayList<EchoInformationResDTO>();
        }
        String userLangName = this.userService.getUserLangNameByUserId(user.getUserId(), user.getTenantId(), user.getToken());
        for (EchoInformation res : echoInfos) {
            EchoInformationResDTO echo = new EchoInformationResDTO();
            if ("zh_TW".equals(userLangName)) {
                BeanUtils.copyProperties((Object)res, (Object)echo);
                echo.setDescription(res.getComplexDescription());
                echo.setContent(res.getComplexContent());
                echo.setExtend(res.getComplexExtend());
                echo.setAppName(res.getComplexAppName());
                results.add(echo);
                continue;
            }
            BeanUtils.copyProperties((Object)res, (Object)echo);
            results.add(echo);
        }
        return results;
    }

    @Transactional
    public void mongoSubmit(EchoInformationReqDTO echoInformationReqDTO, AuthoredUser user) {
        EchoInfoMongoData echoInformation = new EchoInfoMongoData();
        BeanUtils.copyProperties((Object)echoInformationReqDTO, (Object)echoInformation);
        long messageId = echoInformationReqDTO.getMessageId();
        echoInformation.setCreateTime(new Date());
        Query query = Query.query((CriteriaDefinition)Criteria.where((String)"messageId").is((Object)messageId));
        List results = this.mongoTemplate.find(query, EchoInfoMongoData.class);
        if (CollectionUtils.isNotEmpty((Collection)results)) {
            Update update = new Update();
            if (StringUtils.isEmpty((String)((EchoInfoMongoData)results.get(0)).getExtend())) {
                update.set("extend", (Object)echoInformation.getExtend());
            }
            if (CollectionUtils.isEmpty((Collection)((EchoInfoMongoData)results.get(0)).getStepAnalysis())) {
                update.set("stepAnalysis", (Object)echoInformation.getStepAnalysis());
            }
            if (CollectionUtils.isEmpty((Collection)((EchoInfoMongoData)results.get(0)).getStepFilterAnalysis())) {
                update.set("stepFilterAnalysis", (Object)echoInformation.getStepFilterAnalysis());
            }
            update.set("updateTime", (Object)LocalDateTime.now());
            this.mongoTemplate.updateFirst(query, (UpdateDefinition)update, EchoInfoMongoData.class);
        } else {
            this.mongoTemplate.insert((Object)echoInformation);
        }
    }

    public List<EchoInfoMongoData> getMongoDbEchoInfoByMessageId(String messageId, AuthoredUser user) {
        Query query = Query.query((CriteriaDefinition)Criteria.where((String)"messageId").is((Object)Long.valueOf(messageId)));
        return this.mongoTemplate.find(query, EchoInfoMongoData.class);
    }

    @Transactional
    public void sendMetricCheck(Map<String, Object> request, AuthoredUser user) {
        log.info("agiledataecho :\u4fdd\u5b58\u6392\u67e5\u63d0\u6548\u5165\u53c2\u4fe1\u606f\uff1a{},user:{}", (Object)JsonUtils.objectToString(request), (Object)JsonUtils.objectToString((Object)user));
        MetricCheckMongoData metricCheckMongoData = new MetricCheckMongoData();
        try {
            String messageId = String.valueOf(request.get("messageId"));
            String userLang = String.valueOf(request.get("userLang"));
            Map multilingualMap = this.getMultilingualByLang(userLang);
            Object metricRunningList = request.get("metricRunningList");
            Object metricRunningDetail = request.get("metricRunningDetail");
            List selectList = MetricCheckResDTO.replaceMetricNamesAndIds((List)(Objects.nonNull(metricRunningList) ? (List)metricRunningList : new ArrayList()));
            Map selectValue = Objects.nonNull(metricRunningDetail) ? (Map)request.get("metricRunningDetail") : new HashMap();
            MetricCheckResDTO metricCheckResDTO = new MetricCheckResDTO();
            ArrayList<MetricCheckResDTO.Tabs> tabs = new ArrayList<MetricCheckResDTO.Tabs>();
            MetricCheckResDTO.Tabs schemaExplain = MetricCheckResDTO.assembleSchemaExplain(request, (Map)multilingualMap);
            MetricCheckResDTO.Tabs processFlow = MetricCheckResDTO.assembleProcessFlow((List)selectList, selectValue, (Map)multilingualMap);
            MetricCheckResDTO.Tabs getSQL = MetricCheckResDTO.assembleGetSQL((List)selectList, selectValue, (Map)multilingualMap);
            tabs.add(schemaExplain);
            tabs.add(processFlow);
            tabs.add(getSQL);
            metricCheckResDTO.setTabs(tabs);
            BeanUtils.copyProperties((Object)metricCheckResDTO, (Object)metricCheckMongoData);
            metricCheckMongoData.setMessageId(Long.valueOf(messageId));
            metricCheckMongoData.setCreateTime(new Date());
            this.mongoTemplate.insert((Object)metricCheckMongoData);
            LogUtils.buildAgileLog((String)"adt", (String)"debugInfo", (String)"1", (String)JsonUtils.objectToString(request), (String)JsonUtils.objectToString((Object)metricCheckMongoData), (String)"");
            log.info("agiledataecho :\u4fdd\u5b58\u6392\u67e5\u63d0\u6548\u51fa\u53c2\u4fe1\u606f messageId\uff1a{}", (Object)messageId);
        }
        catch (Exception e) {
            LogUtils.buildAgileLog((String)"adt", (String)"debugInfo", (String)TroubleToolCodeEnum.ECHO_901_0001.getErrCode(), (String)JsonUtils.objectToString(request), (String)(TroubleToolCodeEnum.ECHO_901_0001.getErrMsg() + "\u9519\u8bef\u4fe1\u606f:\u3010" + JsonUtils.objectToString((Object)metricCheckMongoData) + "\u3011"), (String)TroubleToolCodeEnum.ECHO_901_0001.getSuggestion());
            log.error("agiledataecho :\u4fdd\u5b58\u6392\u67e5\u63d0\u6548\u4fe1\u606f\u62a5\u9519\uff1a{},", (Object)JsonUtils.objectToString((Object)e.getMessage()));
        }
    }

    public Map<String, String> getMultilingualByLang(String userLang) {
        HashMap<String, String> result = new HashMap<String, String>();
        String schema = this.messageUtils.getMessageByLangName("message.metric.check.schema", userLang);
        String sameWord = this.messageUtils.getMessageByLangName("message.metric.check.sameWord", userLang);
        String processFlow = this.messageUtils.getMessageByLangName("message.metric.check.processFlow", userLang);
        String getSql = this.messageUtils.getMessageByLangName("message.metric.check.getSql", userLang);
        String appName = this.messageUtils.getMessageByLangName("message.metric.check.appName", userLang);
        String appCode = this.messageUtils.getMessageByLangName("message.metric.check.appCode", userLang);
        String valueLogic = this.messageUtils.getMessageByLangName("message.metric.check.valueLogic", userLang);
        String idea = this.messageUtils.getMessageByLangName("message.metric.check.idea", userLang);
        String sql = this.messageUtils.getMessageByLangName("message.metric.check.sql", userLang);
        String matchTip = this.messageUtils.getMessageByLangName("message.metric.title.match", userLang);
        String entityTip = this.messageUtils.getMessageByLangName("message.metric.title.entity", userLang);
        String description = this.messageUtils.getMessageByLangName("message.metric.title.matchTarget", userLang);
        result.put("schema", schema);
        result.put("processFlow", processFlow);
        result.put("sameWord", sameWord);
        result.put("getSql", getSql);
        result.put("appName", appName);
        result.put("appCode", appCode);
        result.put("valueLogic", valueLogic);
        result.put("idea", idea);
        result.put("sql", sql);
        result.put("matchTip", matchTip);
        result.put("entityTip", entityTip);
        result.put("description", description);
        return result;
    }

    public List<MetricCheckMongoData> getMongoDbMetricInfoByMessageId(String messageId, AuthoredUser user) {
        Query query = Query.query((CriteriaDefinition)Criteria.where((String)"messageId").is((Object)Long.valueOf(messageId)));
        return this.mongoTemplate.find(query, MetricCheckMongoData.class);
    }

    public List<Map<String, Object>> queryPixBackendList(EchoQueryBackIdReqDTO echoQueryBackIdReqDTO, AuthoredUser user) {
        List messageIds = echoQueryBackIdReqDTO.getMessageIds();
        List pixIds = echoQueryBackIdReqDTO.getPixIds();
        if (CollectionUtils.isEmpty((Collection)messageIds) && CollectionUtils.isEmpty((Collection)pixIds)) {
            return new ArrayList<Map<String, Object>>();
        }
        ArrayList<Map<String, Object>> echoInfos = new ArrayList<Map<String, Object>>();
        if (CollectionUtils.isNotEmpty((Collection)messageIds)) {
            echoInfos.addAll(this.queryInfoByBatch(messageIds, 500, arg_0 -> ((EchoInformationMapper)this.echoInformationMapper).queryInfoMessageIdAndPixIdByMessageIds(arg_0)));
        } else {
            echoInfos.addAll(this.queryInfoByBatch(pixIds, 500, arg_0 -> ((EchoInformationMapper)this.echoInformationMapper).queryInfoMessageIdAndPixIdByPixIds(arg_0)));
        }
        return echoInfos;
    }

    public AgileDataAnalysisDTO getAgileDataAnalysis(Map<String, Object> params, AuthoredUser user, String local) {
        Map adeResult;
        Map multilingualMap;
        MetricCheckResDTO.AreaInfo areaInfo;
        if (MapUtils.isEmpty(params)) {
            return null;
        }
        AgileDataAnalysisDTO agileDataAnalysisDTO = new AgileDataAnalysisDTO();
        Map debugInfoData = MapUtils.getMap(params, (Object)"aiParams");
        if (MapUtils.isNotEmpty((Map)debugInfoData) && CollectionUtils.isNotEmpty((Collection)(areaInfo = MetricCheckResDTO.AreaInfo.assembleSameWord((Map)debugInfoData, (Map)(multilingualMap = this.getMultilingualByLang(local)))).getValues())) {
            MetricCheckResDTO.AreaInfo.ValueInfo valueInfo = (MetricCheckResDTO.AreaInfo.ValueInfo)areaInfo.getValues().get(0);
            agileDataAnalysisDTO.setNounMatching(valueInfo.getValue());
        }
        if (MapUtils.isNotEmpty((Map)(adeResult = MapUtils.getMap(params, (Object)"analysisParams")))) {
            agileDataAnalysisDTO.setAppCode(MapUtils.getString((Map)adeResult, (Object)"appCode"));
            List metricList = (List)MapUtils.getObject((Map)adeResult, (Object)"metricList");
            if (CollectionUtils.isNotEmpty((Collection)metricList)) {
                agileDataAnalysisDTO.setAppName(MapUtils.getString((Map)((Map)metricList.get(0)), (Object)"applicationName"));
            }
            agileDataAnalysisDTO.setExplain4Gpt(MapUtils.getString((Map)adeResult, (Object)"explain4Gpt"));
            AgileDataEngineAnalysisModel analysisModel = this.agileDataEngineService.getAnalysisData(user, adeResult, local);
            if (analysisModel != null) {
                agileDataAnalysisDTO.setValueLogic(analysisModel.getData().toString());
            }
        }
        return agileDataAnalysisDTO;
    }

    public List<Map<String, Object>> queryInfoByBatch(List<String> ids, int batchSize, Function<List<String>, List<Map<String, Object>>> queryFunction) {
        ArrayList<Map<String, Object>> result = new ArrayList<Map<String, Object>>();
        int startIndex = 0;
        int endIndex = Math.min(batchSize, ids.size());
        while (startIndex < ids.size()) {
            List<String> subIds = ids.subList(startIndex, endIndex);
            result.addAll((Collection<Map<String, Object>>)queryFunction.apply(subIds));
            startIndex = endIndex;
            endIndex = Math.min(startIndex + batchSize, ids.size());
        }
        return result;
    }

    @Transactional
    public void mongoMultipleSubmit(EchoSelectMultipleReqDTO echoSelectMultipleReqDTO, AuthoredUser user) {
        EchoSelectMultiple echoSelectMultiple = new EchoSelectMultiple();
        BeanUtils.copyProperties((Object)echoSelectMultipleReqDTO, (Object)echoSelectMultiple);
        long messageId = echoSelectMultiple.getMessageId();
        Query query = Query.query((CriteriaDefinition)Criteria.where((String)"messageId").is((Object)messageId));
        List results = this.mongoTemplate.find(query, EchoSelectMultiple.class);
        if (CollectionUtils.isNotEmpty((Collection)results)) {
            Update update = new Update();
            update.set("selectMultiple", (Object)echoSelectMultiple.getSelectMultiple());
            this.mongoTemplate.updateFirst(query, (UpdateDefinition)update, EchoSelectMultiple.class);
        } else {
            this.mongoTemplate.insert((Object)echoSelectMultiple);
        }
    }

    public List<EchoSelectMultiple> getMongoMultipleLogByMessageId(String messageId, AuthoredUser user) {
        Query query = Query.query((CriteriaDefinition)Criteria.where((String)"messageId").is((Object)Long.valueOf(messageId)));
        return this.mongoTemplate.find(query, EchoSelectMultiple.class);
    }
}

