/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.athena.agiledataecho.service.imp;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.digiwin.athena.agiledataecho.dao.EchoChargingMapper;
import com.digiwin.athena.agiledataecho.domain.EchoCharging;
import com.digiwin.athena.agiledataecho.proxy.adt.AdtService;
import com.digiwin.athena.agiledataecho.service.EchoLiteChargingService;
import com.digiwin.athena.agiledataecho.util.LogUtils;
import com.digiwin.athena.appcore.auth.domain.AuthoredUser;
import com.digiwin.athena.appcore.util.JsonUtils;
import java.time.LocalDateTime;
import java.util.concurrent.TimeUnit;
import javax.annotation.Resource;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.redis.core.StringRedisTemplate;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class EchoLiteChargingServiceImpl
implements EchoLiteChargingService {
    private static final Logger log = LoggerFactory.getLogger(EchoLiteChargingServiceImpl.class);
    @Resource
    private EchoChargingMapper echoChargingMapper;
    @Autowired
    private AdtService adtService;
    private static final Integer CHARGING_NUM = 1;
    private static final String CHARGING_TYPE = "lite";
    @Autowired
    private StringRedisTemplate stringRedisTemplate;
    private static final String AGILE_DATA_ECHO_CACHE = "agiledataecho:cache";
    private static final String CHARGING_REDIS_KEY = "charging_redis_key";

    @Transactional(rollbackFor={Exception.class})
    public Boolean changeCharging(AuthoredUser authoredUser, String chargingType) {
        EchoCharging echoCharging = new EchoCharging();
        try {
            QueryWrapper queryWrapper = new QueryWrapper();
            ((QueryWrapper)((QueryWrapper)queryWrapper.eq((Object)"user_id", (Object)authoredUser.getUserId())).eq((Object)"tenant_id", (Object)authoredUser.getTenantId())).eq((Object)"charging_type", (Object)(StringUtils.isEmpty((String)chargingType) ? CHARGING_TYPE : chargingType));
            echoCharging = (EchoCharging)this.echoChargingMapper.selectOne((Wrapper)queryWrapper);
            Integer userCharging = 0;
            String redisValue = (String)this.stringRedisTemplate.opsForValue().get((Object)("agiledataecho:cachecharging_redis_key" + authoredUser.getTenantId()));
            if (StringUtils.isNotEmpty((String)redisValue)) {
                userCharging = Integer.parseInt(redisValue);
            } else {
                userCharging = this.adtService.getChargingUserValue(authoredUser);
                this.stringRedisTemplate.opsForValue().set((Object)("agiledataecho:cachecharging_redis_key" + authoredUser.getTenantId()), (Object)String.valueOf(userCharging), 86400000L, TimeUnit.SECONDS);
            }
            if (echoCharging != null) {
                chargingType = chargingType == null ? CHARGING_TYPE : chargingType;
                this.echoChargingMapper.updateChargingRemain(authoredUser.getTenantId(), authoredUser.getUserId(), chargingType, LocalDateTime.now());
                boolean result = echoCharging.getChargingRemain() + 1 < userCharging;
                LogUtils.buildAgileLog((String)"agiledataecho", (String)"liteDeduction", (String)"1", (String)JsonUtils.objectToString((Object)echoCharging), (String)JsonUtils.objectToString((Object)result), (String)"");
                return result;
            }
            this.initCharging(authoredUser, chargingType, userCharging, Integer.valueOf(1));
        }
        catch (Exception e) {
            log.error("\u654f\u6570\u4f53\u9a8c\u6b21\u6570\u6263\u51cf\u5931\u8d25:{}", (Object)e.getMessage());
            LogUtils.buildAgileLog((String)"agiledataecho", (String)"liteDeduction", (String)"-1", (String)JsonUtils.objectToString((Object)echoCharging), (String)"ECHO\u654f\u6570\u4f53\u9a8c\u6b21\u6570\u6263\u51cf\u5931\u8d25", (String)"");
        }
        return true;
    }

    public void initCharging(AuthoredUser authoredUser, String chargingType, Integer chargingNum, Integer chargingRemain) {
        EchoCharging echoCharging = new EchoCharging();
        echoCharging.setUserId(authoredUser.getUserId());
        echoCharging.setUserName(authoredUser.getUserName());
        echoCharging.setTenantId(authoredUser.getTenantId());
        echoCharging.setTenantName(authoredUser.getTenantName());
        echoCharging.setChargingNum((chargingNum == null ? CHARGING_NUM : chargingNum).intValue());
        echoCharging.setChargingRemain((chargingRemain == null ? CHARGING_NUM : chargingRemain).intValue());
        echoCharging.setChargingType(StringUtils.isEmpty((String)chargingType) ? CHARGING_TYPE : chargingType);
        echoCharging.setCreateDate(LocalDateTime.now());
        echoCharging.setModifyDate(LocalDateTime.now());
        this.echoChargingMapper.insert((Object)echoCharging);
    }

    public void initChargingRemain(String userId, String tenantId, Integer chargingRemain, String chargingType) {
        chargingRemain = chargingRemain == null ? CHARGING_NUM : chargingRemain;
        chargingType = chargingType == null ? CHARGING_TYPE : chargingType;
        QueryWrapper queryWrapper = new QueryWrapper();
        ((QueryWrapper)((QueryWrapper)queryWrapper.eq((Object)"user_id", (Object)userId)).eq((Object)"tenant_id", (Object)tenantId)).eq((Object)"charging_type", (Object)chargingType);
        EchoCharging echoCharging = (EchoCharging)this.echoChargingMapper.selectOne((Wrapper)queryWrapper);
        if (echoCharging == null) {
            AuthoredUser authoredUser = new AuthoredUser();
            authoredUser.setUserId(userId);
            authoredUser.setTenantId(tenantId);
            this.initCharging(authoredUser, chargingType, chargingRemain, chargingRemain);
        } else {
            this.echoChargingMapper.reductionChargingRemain(tenantId, userId, chargingRemain, chargingType, LocalDateTime.now());
        }
    }
}

