/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.athena.agiledataecho.service.imp;

import com.digiwin.athena.agiledataecho.dto.EchoDataDetailUrlDTO;
import com.digiwin.athena.agiledataecho.proxy.ade.AgileDataEngineService;
import com.digiwin.athena.agiledataecho.proxy.ade.model.AgileDataEngineFileDownModel;
import com.digiwin.athena.agiledataecho.proxy.adt.AdtService;
import com.digiwin.athena.agiledataecho.service.EchoQueryDataDetailService;
import com.digiwin.athena.appcore.auth.domain.AuthoredUser;
import com.digiwin.athena.appcore.util.JsonUtils;
import com.digiwin.athena.appcore.util.MessageUtils;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.collections.MapUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class EchoQueryDataDetailServiceImpl
implements EchoQueryDataDetailService {
    private static final Logger log = LoggerFactory.getLogger(EchoQueryDataDetailServiceImpl.class);
    @Autowired
    private AdtService adtService;
    @Autowired
    private MessageUtils messageUtils;
    @Autowired
    private AgileDataEngineService agileDataEngineService;

    public EchoDataDetailUrlDTO getDataDetailUrl(AuthoredUser user, String snapshotId, String locale) {
        AgileDataEngineFileDownModel adeFileDown;
        EchoDataDetailUrlDTO echoDataDetailUrlDTO = new EchoDataDetailUrlDTO();
        Map snapshotInfo = this.adtService.getSnapShotInfo(user, snapshotId, locale);
        if (MapUtils.isEmpty((Map)snapshotInfo)) {
            this.buildErrorMessage(echoDataDetailUrlDTO, locale);
            return echoDataDetailUrlDTO;
        }
        Map adeParams = this.buildAdeParams(user, snapshotInfo, locale);
        String productVersion = MapUtils.getString((Map)adeParams, (Object)"productVersion");
        log.info("\u660e\u7ec6\u4e0b\u8f7d productVersion : {}", (Object)productVersion);
        if ("V1".equals(productVersion)) {
            adeFileDown = this.agileDataEngineService.getFileDownUrl(user, adeParams, locale);
            log.info("\u660e\u7ec6\u4e0b\u8f7dv1 : {}", (Object)JsonUtils.objectToString((Object)adeFileDown));
        } else {
            adeFileDown = this.agileDataEngineService.getFileDownUrlV2(user, adeParams, locale);
            log.info("\u660e\u7ec6\u4e0b\u8f7dv2 : {}", (Object)JsonUtils.objectToString((Object)adeFileDown));
        }
        if (adeFileDown == null) {
            this.buildErrorMessage(echoDataDetailUrlDTO, locale);
            return echoDataDetailUrlDTO;
        }
        echoDataDetailUrlDTO.setDataUrl(adeFileDown.getData());
        echoDataDetailUrlDTO.setResult(Boolean.valueOf(StringUtils.equals((CharSequence)"0", (CharSequence)adeFileDown.getCode())));
        echoDataDetailUrlDTO.setErrorMessage(adeFileDown.getMsg());
        return echoDataDetailUrlDTO;
    }

    private void buildErrorMessage(EchoDataDetailUrlDTO echoDataDetailUrlDTO, String locale) {
        echoDataDetailUrlDTO.setResult(Boolean.valueOf(false));
        echoDataDetailUrlDTO.setErrorMessage(this.messageUtils.getMessageByLangName("message.ade.dataUrl.error.msg", locale));
    }

    private Map<String, Object> buildAdeParams(AuthoredUser user, Map<String, Object> snapshotInfo, String locale) {
        Map context = MapUtils.getMap(snapshotInfo, (Object)"context");
        if (MapUtils.isEmpty((Map)context)) {
            return null;
        }
        Map bizParams = MapUtils.getMap((Map)context, (Object)"bizParams");
        if (MapUtils.isEmpty((Map)bizParams)) {
            return null;
        }
        Map adeParams = bizParams;
        List pullData = (List)MapUtils.getObject((Map)context, (Object)"pullData");
        if (CollectionUtils.isNotEmpty((Collection)pullData)) {
            ArrayList metricList = Lists.newArrayList();
            pullData.stream().forEach(map -> {
                HashMap metricMap = Maps.newHashMap();
                metricMap.put("actionId", MapUtils.getString((Map)map, (Object)"actionId"));
                metricMap.put("metricList", MapUtils.getObject((Map)map, (Object)"metricList"));
                metricList.add(metricMap);
            });
            adeParams.put("actionMetricList", metricList);
        }
        adeParams.put("userId", user.getUserId());
        return adeParams;
    }

    private List<Map<String, Object>> getListStructure(Object obj) {
        ArrayList resultList = Lists.newArrayList();
        if (obj instanceof List) {
            resultList.addAll((List)obj);
        }
        if (obj instanceof Map) {
            resultList.add((Map)obj);
        }
        return resultList;
    }
}

