/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.athena.show.assistant;

import com.digiwin.athena.appcore.auth.domain.AuthoredUser;
import com.digiwin.athena.show.assistant.ExecuteContext;
import com.digiwin.athena.show.domain.queryDefine.SnapDataDTO;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.jugg.agile.spring.boot.webmvc.util.JaSpringServletUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.compress.utils.Lists;
import org.springframework.util.StringUtils;

/*
 * Exception performing whole class analysis ignored.
 */
public class ExecuteContext {
    private String proxyToken;
    @JsonIgnore
    private AuthoredUser authoredUser;
    private String tenantId;
    private String locale;
    private String clientAgent;
    private String agentType;
    private String identity;
    private String pageCode;
    private Boolean isShared;
    private String traceId;
    private Map<String, Object> agileData;
    private String reportCode;
    private String snapshotId;
    private String performerId;
    private String queryType;
    private String messageId;
    private String entry;
    private String link;
    private String actionId;
    private String screenCode;
    private String module;
    private String transId;
    private String defineTitle;
    @JsonIgnore
    private Boolean isRowSpanTree;

    public Boolean getIsRowSpanTree() {
        if (this.isRowSpanTree == null) {
            this.isRowSpanTree = false;
        }
        return this.isRowSpanTree;
    }

    public void setIsRowSpanTree(Boolean isRowSpanTree) {
        this.isRowSpanTree = isRowSpanTree;
    }

    public <T extends ExecuteContext> void copyTo(T newExecuteContext) {
        newExecuteContext.setAuthoredUser(this.authoredUser);
        newExecuteContext.setClientAgent(this.clientAgent);
        newExecuteContext.setIsShared(this.isShared);
        newExecuteContext.setIdentity(this.identity);
        newExecuteContext.setLocale(this.locale);
        newExecuteContext.setPageCode(this.pageCode);
        newExecuteContext.setProxyToken(this.proxyToken);
        newExecuteContext.setTenantId(this.tenantId);
        newExecuteContext.setTraceId(this.traceId);
        newExecuteContext.setAgentType(this.agentType);
        newExecuteContext.setLink(this.link);
        newExecuteContext.setEntry(this.entry);
        newExecuteContext.setMessageId(this.messageId);
        newExecuteContext.setActionId(this.actionId);
    }

    public ExecuteContext clone() {
        ExecuteContext executeContext = new ExecuteContext();
        this.copyTo(executeContext);
        return executeContext;
    }

    public ExecuteContext appendHttpRequest(HttpServletRequest request) {
        String locale = request.getHeader("locale");
        String clientAgent = request.getHeader("client-agent");
        if (StringUtils.isEmpty((Object)clientAgent)) {
            clientAgent = request.getHeader("Client-Agent");
        }
        if (clientAgent == null) {
            clientAgent = "webplatform";
        }
        this.setClientAgent(clientAgent);
        this.setLocale(locale);
        AuthoredUser authoredUser = (AuthoredUser)request.getAttribute("digi-middleware-auth-user-data");
        this.setAuthoredUser(authoredUser);
        this.setTenantId(authoredUser.getTenantId());
        return this;
    }

    public static ExecuteContext createAppendByHttpRequest(ExecuteContext executeContext, HttpServletRequest request) {
        if (executeContext == null) {
            executeContext = ExecuteContext.createByHttpRequest((HttpServletRequest)request);
        } else {
            executeContext.appendHttpRequest(request);
        }
        return executeContext;
    }

    public static ExecuteContext createByHttpRequest() {
        return ExecuteContext.createByHttpRequest((HttpServletRequest)JaSpringServletUtil.getHttpServletRequest());
    }

    public static ExecuteContext createByHttpRequest(HttpServletRequest request) {
        String agentType;
        String locale = request.getHeader("locale");
        String clientAgent = request.getHeader("client-agent");
        String string = agentType = StringUtils.isEmpty((Object)request.getHeader("agent-type")) ? request.getHeader("Agent-Type") : request.getHeader("agent-type");
        if (StringUtils.isEmpty((Object)clientAgent)) {
            clientAgent = request.getHeader("Client-Agent");
        }
        if (clientAgent == null) {
            clientAgent = "webplatform";
        }
        AuthoredUser authoredUser = (AuthoredUser)request.getAttribute("digi-middleware-auth-user-data");
        return ExecuteContext.builder().clientAgent(clientAgent).locale(locale).authoredUser(authoredUser).tenantId(authoredUser.getTenantId()).agentType(agentType).build();
    }

    public void appendAgileDataPageInfo(String pageCode, SnapDataDTO agileReportDTO, String screenCode, String entry) {
        String actionId = agileReportDTO.getSnapData().getReportCode();
        if (StringUtils.isEmpty((Object)actionId)) {
            ArrayList actionIds = Lists.newArrayList();
            agileReportDTO.getPageData().forEach((k, v) -> actionIds.add(k));
            if (CollectionUtils.isNotEmpty((Collection)actionIds)) {
                actionId = (String)actionIds.get(0);
            }
        }
        this.setIdentity("performer");
        this.setPageCode(pageCode);
        this.setMessageId(agileReportDTO.getSnapData().getMessageId());
        this.setLink(agileReportDTO.getLink());
        this.setEntry(entry);
        this.setSnapshotId(agileReportDTO.getSnapData().getSnapshotId());
        this.setIsShared(Boolean.FALSE);
        this.actionId = actionId;
        this.screenCode = screenCode;
    }

    public void appendAgileDataPageInfo(String pageCode, SnapDataDTO agileReportDTO, String screenCode, String entry, String defineTitle) {
        String actionId = agileReportDTO.getSnapData().getReportCode();
        if (StringUtils.isEmpty((Object)actionId)) {
            ArrayList actionIds = Lists.newArrayList();
            agileReportDTO.getPageData().forEach((k, v) -> actionIds.add(k));
            if (CollectionUtils.isNotEmpty((Collection)actionIds)) {
                actionId = (String)actionIds.get(0);
            }
        }
        this.setIdentity("performer");
        this.setPageCode(pageCode);
        this.setMessageId(agileReportDTO.getSnapData().getMessageId());
        this.setLink(agileReportDTO.getLink());
        this.setEntry(entry);
        this.setSnapshotId(agileReportDTO.getSnapData().getSnapshotId());
        this.setIsShared(Boolean.FALSE);
        this.actionId = actionId;
        this.screenCode = screenCode;
        this.defineTitle = defineTitle;
    }

    public static ExecuteContextBuilder builder() {
        return new ExecuteContextBuilder();
    }

    public void setProxyToken(String proxyToken) {
        this.proxyToken = proxyToken;
    }

    public void setAuthoredUser(AuthoredUser authoredUser) {
        this.authoredUser = authoredUser;
    }

    public void setTenantId(String tenantId) {
        this.tenantId = tenantId;
    }

    public void setLocale(String locale) {
        this.locale = locale;
    }

    public void setClientAgent(String clientAgent) {
        this.clientAgent = clientAgent;
    }

    public void setAgentType(String agentType) {
        this.agentType = agentType;
    }

    public void setIdentity(String identity) {
        this.identity = identity;
    }

    public void setPageCode(String pageCode) {
        this.pageCode = pageCode;
    }

    public void setIsShared(Boolean isShared) {
        this.isShared = isShared;
    }

    public void setTraceId(String traceId) {
        this.traceId = traceId;
    }

    public void setAgileData(Map<String, Object> agileData) {
        this.agileData = agileData;
    }

    public void setReportCode(String reportCode) {
        this.reportCode = reportCode;
    }

    public void setSnapshotId(String snapshotId) {
        this.snapshotId = snapshotId;
    }

    public void setPerformerId(String performerId) {
        this.performerId = performerId;
    }

    public void setQueryType(String queryType) {
        this.queryType = queryType;
    }

    public void setMessageId(String messageId) {
        this.messageId = messageId;
    }

    public void setEntry(String entry) {
        this.entry = entry;
    }

    public void setLink(String link) {
        this.link = link;
    }

    public void setActionId(String actionId) {
        this.actionId = actionId;
    }

    public void setScreenCode(String screenCode) {
        this.screenCode = screenCode;
    }

    public void setModule(String module) {
        this.module = module;
    }

    public void setTransId(String transId) {
        this.transId = transId;
    }

    public void setDefineTitle(String defineTitle) {
        this.defineTitle = defineTitle;
    }

    public String getProxyToken() {
        return this.proxyToken;
    }

    public AuthoredUser getAuthoredUser() {
        return this.authoredUser;
    }

    public String getTenantId() {
        return this.tenantId;
    }

    public String getLocale() {
        return this.locale;
    }

    public String getClientAgent() {
        return this.clientAgent;
    }

    public String getAgentType() {
        return this.agentType;
    }

    public String getIdentity() {
        return this.identity;
    }

    public String getPageCode() {
        return this.pageCode;
    }

    public Boolean getIsShared() {
        return this.isShared;
    }

    public String getTraceId() {
        return this.traceId;
    }

    public Map<String, Object> getAgileData() {
        return this.agileData;
    }

    public String getReportCode() {
        return this.reportCode;
    }

    public String getSnapshotId() {
        return this.snapshotId;
    }

    public String getPerformerId() {
        return this.performerId;
    }

    public String getQueryType() {
        return this.queryType;
    }

    public String getMessageId() {
        return this.messageId;
    }

    public String getEntry() {
        return this.entry;
    }

    public String getLink() {
        return this.link;
    }

    public String getActionId() {
        return this.actionId;
    }

    public String getScreenCode() {
        return this.screenCode;
    }

    public String getModule() {
        return this.module;
    }

    public String getTransId() {
        return this.transId;
    }

    public String getDefineTitle() {
        return this.defineTitle;
    }

    public ExecuteContext(String proxyToken, AuthoredUser authoredUser, String tenantId, String locale, String clientAgent, String agentType, String identity, String pageCode, Boolean isShared, String traceId, Map<String, Object> agileData, String reportCode, String snapshotId, String performerId, String queryType, String messageId, String entry, String link, String actionId, String screenCode, String module, String transId, String defineTitle, Boolean isRowSpanTree) {
        this.proxyToken = proxyToken;
        this.authoredUser = authoredUser;
        this.tenantId = tenantId;
        this.locale = locale;
        this.clientAgent = clientAgent;
        this.agentType = agentType;
        this.identity = identity;
        this.pageCode = pageCode;
        this.isShared = isShared;
        this.traceId = traceId;
        this.agileData = agileData;
        this.reportCode = reportCode;
        this.snapshotId = snapshotId;
        this.performerId = performerId;
        this.queryType = queryType;
        this.messageId = messageId;
        this.entry = entry;
        this.link = link;
        this.actionId = actionId;
        this.screenCode = screenCode;
        this.module = module;
        this.transId = transId;
        this.defineTitle = defineTitle;
        this.isRowSpanTree = isRowSpanTree;
    }

    public ExecuteContext() {
    }
}

