/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.athena.show.component.gridster;

import com.digiwin.athena.show.assistant.ExecuteContext;
import com.digiwin.athena.show.component.AbstractComponent;
import com.digiwin.athena.show.component.gridster.AreaGroupDTO;
import com.digiwin.athena.show.component.gridster.GridGroupDTO;
import com.digiwin.athena.show.component.gridster.GridsterComponent;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.UUID;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.collections.MapUtils;
import org.springframework.stereotype.Service;

@Service(value="gridsterComponent")
public class GridsterComponentImpl {
    public AbstractComponent initComponent(List<AbstractComponent> components, AreaGroupDTO groupDTO, ExecuteContext executeContext) {
        ArrayList abstractComponents = Lists.newArrayList();
        ArrayList gridGroupDTOS = Lists.newArrayList();
        GridsterComponent gridsterComponent = new GridsterComponent();
        gridsterComponent.setId(UUID.randomUUID().toString());
        gridsterComponent.setType("GRIDSTER");
        gridsterComponent.setGroup((List)abstractComponents);
        if (CollectionUtils.isNotEmpty((Collection)groupDTO.getDashboard())) {
            gridsterComponent.setItems(groupDTO.getDashboard());
            ArrayList groupComponents = Lists.newArrayList();
            groupDTO.getDashboard().stream().forEach(dashboard -> {
                Optional<AbstractComponent> component = components.stream().filter(data -> Objects.equals(data.getId(), dashboard.getId())).findFirst();
                if (component.isPresent()) {
                    groupComponents.add(component.get());
                }
            });
            components.removeAll(groupComponents);
            if (CollectionUtils.isNotEmpty(components)) {
                groupComponents.addAll(components);
            }
            gridsterComponent.setGroup((List)groupComponents);
        } else {
            gridsterComponent.setItems((List)gridGroupDTOS);
        }
        gridsterComponent.setDataType("object");
        Map agileData = executeContext.getAgileData();
        gridsterComponent.setTitle(MapUtils.getString((Map)agileData, (Object)"title"));
        return gridsterComponent;
    }

    private List<AbstractComponent> getNoGroupComponent(List<List<AbstractComponent>> groupList, List<AbstractComponent> components, List<GridGroupDTO> gridGroupDTOS) {
        ArrayList noGroupComponentList = Lists.newArrayList();
        int maxLen = 0;
        for (int i = 0; i < groupList.size(); ++i) {
            maxLen = i;
            List<AbstractComponent> componentList = groupList.get(i);
            componentList.stream().forEach(component -> {
                if (!components.contains(component)) {
                    noGroupComponentList.add(component);
                }
            });
        }
        int size = noGroupComponentList.size();
        int dashboard = size / 2 < 3 ? 3 : size / 2;
        this.setDashboard(maxLen, 3, dashboard, (List)noGroupComponentList, gridGroupDTOS);
        return noGroupComponentList;
    }

    private void setDashboard(int index, int rows, int clos, List<AbstractComponent> abstractComponents, List<GridGroupDTO> gridGroupDTOS) {
        if (CollectionUtils.isNotEmpty(abstractComponents)) {
            int preX = 0;
            for (AbstractComponent abstractComponent : abstractComponents) {
                GridGroupDTO groupDTO = new GridGroupDTO();
                groupDTO.setRows(Integer.valueOf(rows));
                groupDTO.setCols(Integer.valueOf(clos));
                groupDTO.setX(Integer.valueOf(preX));
                groupDTO.setY(Integer.valueOf(index));
                groupDTO.setId(abstractComponent.getId());
                gridGroupDTOS.add(groupDTO);
                preX = groupDTO.getCols();
            }
        }
    }
}

