/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.athena.show.metadata;

import com.digiwin.athena.show.metadata.MetadataField;
import com.digiwin.athena.show.metadata.Precision;
import com.fasterxml.jackson.annotation.JsonIgnore;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.ArrayUtils;
import org.springframework.util.StringUtils;

public class MetadataField
implements Serializable {
    private String name;
    private String originalName;
    private String path;
    private boolean required;
    private String description;
    private String remark;
    private String dataKey;
    private boolean businessKey;
    private String dataType;
    private String businessType;
    private String explanation;
    private String decimalRule;
    private String unit;
    private Object originalData;
    @JsonIgnore
    private int displayWidth;
    private Precision precision;
    private Object objectData;
    private Boolean canSort;
    private String sort;
    private Boolean canFilter;
    private String fieldType;
    private boolean canEdit;
    private Integer themeMapTagOrder;
    private List<MetadataField> subFields;
    private List<MetadataField> originalFields;
    @JsonIgnore
    private List<MetadataField> exportTableFields;
    private boolean array;
    @JsonIgnore
    private String sourceApi;
    @JsonIgnore
    private boolean isHead;
    @JsonIgnore
    private String clientAgent;
    private String enumKey;
    @JsonIgnore
    private Map<String, MetadataField> fieldMap;
    @JsonIgnore
    private MetadataField parentField;
    private String percent;
    private Integer decimal;
    private Boolean isTime;
    private Boolean isGroupBy;
    private Boolean isMainDimension;
    private String uiBot;
    private Boolean isNavigate = Boolean.FALSE;

    @JsonIgnore
    public boolean isSimpleField() {
        if ("object".equals(this.getDataType())) {
            return false;
        }
        return !this.isArray();
    }

    @JsonIgnore
    public boolean isObjectField() {
        return "object".equals(this.getDataType());
    }

    @JsonIgnore
    public boolean isPercentField() {
        return StringUtils.hasText((String)this.getPercent()) && "percent".equals(this.getPercent());
    }

    public MetadataField findByFullPath(String fullName) {
        if (StringUtils.isEmpty((Object)fullName)) {
            return null;
        }
        if (this.getFullName().equals(fullName)) {
            return this;
        }
        if (fullName.startsWith(this.getName() + ".")) {
            String headName = this.getName() + ".";
            String path = fullName.substring(headName.length());
            return this.findByPath(path.split("\\."));
        }
        return null;
    }

    public void addField(MetadataField metadataField) {
        if (this.exist(metadataField.getName())) {
            return;
        }
        this.getSubFields().add(metadataField);
        if (this.getFieldMap() == null) {
            this.setFieldMap(new HashMap());
        }
        this.getFieldMap().put(metadataField.getName(), metadataField);
    }

    public MetadataField getField(String name) {
        if (this.exist(name)) {
            return null;
        }
        return (MetadataField)this.getFieldMap().get(name);
    }

    public boolean exist(String name) {
        if (this.getFieldMap() == null) {
            this.flatMetaData(this.getParentField());
        }
        return this.getFieldMap() != null && this.getFieldMap().containsKey(name);
    }

    public MetadataField clone(MetadataField parentMetadataField, List<MetadataField> sonTagFields) {
        MetadataField newMetadataField = new MetadataField();
        newMetadataField.setDataType(this.getDataType());
        newMetadataField.setDataKey(this.getDataKey());
        newMetadataField.setRemark(this.getRemark());
        newMetadataField.setDescription(this.getDescription());
        newMetadataField.setRequired(this.isRequired());
        newMetadataField.setName(this.getName());
        newMetadataField.setArray(this.isArray());
        newMetadataField.setCanEdit(this.isCanEdit());
        newMetadataField.setFieldType(this.getFieldType());
        newMetadataField.setSubFields(sonTagFields);
        newMetadataField.setPath(this.getPath());
        newMetadataField.setParentField(parentMetadataField);
        newMetadataField.setEnumKey(this.getEnumKey());
        newMetadataField.setThemeMapTagOrder(this.themeMapTagOrder);
        newMetadataField.setBusinessType(this.businessType);
        return newMetadataField;
    }

    public void flatMetaData(MetadataField parentField) {
        if (CollectionUtils.isEmpty((Collection)this.getSubFields())) {
            return;
        }
        LinkedHashMap<String, MetadataField> fieldMap = new LinkedHashMap<String, MetadataField>();
        this.setFieldMap(fieldMap);
        this.setParentField(parentField);
        for (MetadataField subField : this.getSubFields()) {
            fieldMap.put(subField.getName(), subField);
            String path = this.getFullName();
            subField.setPath(path);
            subField.flatMetaData(this);
        }
    }

    public void flatMetaDataNotFlatPath(MetadataField parentField) {
        if (CollectionUtils.isEmpty((Collection)this.getSubFields())) {
            return;
        }
        HashMap<String, MetadataField> fieldMap = new HashMap<String, MetadataField>();
        this.setFieldMap(fieldMap);
        this.setParentField(parentField);
        for (MetadataField subField : this.getSubFields()) {
            fieldMap.put(subField.getName(), subField);
            subField.setPath(subField.getPath());
            subField.flatMetaDataNotFlatPath(this);
        }
    }

    public MetadataField findByPath(String[] paths) {
        if (paths == null || paths.length == 0) {
            return null;
        }
        String firstPath = paths[0];
        if (this.getFieldMap() == null || !this.getFieldMap().containsKey(firstPath)) {
            return null;
        }
        if (paths.length == 1) {
            return (MetadataField)this.getFieldMap().get(firstPath);
        }
        return ((MetadataField)this.getFieldMap().get(firstPath)).findByPath((String[])ArrayUtils.subarray((Object[])paths, (int)1, (int)paths.length));
    }

    public static MetadataField createArrayField(String name, String description, String path, boolean canEdit) {
        MetadataField detailField = new MetadataField();
        detailField.setFieldType("object");
        detailField.setName(name);
        detailField.setDescription(description);
        detailField.setDataType("object");
        detailField.setArray(true);
        detailField.setCanEdit(canEdit);
        detailField.setSubFields(new ArrayList());
        detailField.setPath(StringUtils.isEmpty((Object)path) ? name : path + "." + name);
        return detailField;
    }

    public static MetadataField createObjectField(String name, String description, String path, boolean canEdit) {
        MetadataField detailField = new MetadataField();
        detailField.setFieldType("object");
        detailField.setName(name);
        detailField.setDescription(description);
        detailField.setDataType("object");
        detailField.setArray(false);
        detailField.setSubFields(new ArrayList());
        detailField.setCanEdit(canEdit);
        detailField.setPath(StringUtils.isEmpty((Object)path) ? name : path + "." + name);
        return detailField;
    }

    public static MetadataField createSimpleField(String name, String description, String type, String path, boolean canEdit) {
        MetadataField detailField = new MetadataField();
        detailField.setFieldType(type);
        detailField.setName(name);
        detailField.setDescription(description);
        detailField.setDataType(type);
        detailField.setArray(false);
        detailField.setCanEdit(canEdit);
        detailField.setPath(StringUtils.isEmpty((Object)path) ? name : path + "." + name);
        return detailField;
    }

    @JsonIgnore
    public String getFullName() {
        if (StringUtils.hasText((String)this.getPath())) {
            return this.getPath() + '.' + this.getName();
        }
        return this.getName();
    }

    public boolean isSingleHead() {
        return this.getPath() == null || this.getParentField() == null;
    }

    public boolean isNotSingleHead() {
        return !this.isSingleHead();
    }

    public String toString() {
        return this.getName();
    }

    public static MetadataFieldBuilder builder() {
        return new MetadataFieldBuilder();
    }

    public void setName(String name) {
        this.name = name;
    }

    public void setOriginalName(String originalName) {
        this.originalName = originalName;
    }

    public void setPath(String path) {
        this.path = path;
    }

    public void setRequired(boolean required) {
        this.required = required;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public void setRemark(String remark) {
        this.remark = remark;
    }

    public void setDataKey(String dataKey) {
        this.dataKey = dataKey;
    }

    public void setBusinessKey(boolean businessKey) {
        this.businessKey = businessKey;
    }

    public void setDataType(String dataType) {
        this.dataType = dataType;
    }

    public void setBusinessType(String businessType) {
        this.businessType = businessType;
    }

    public void setExplanation(String explanation) {
        this.explanation = explanation;
    }

    public void setDecimalRule(String decimalRule) {
        this.decimalRule = decimalRule;
    }

    public void setUnit(String unit) {
        this.unit = unit;
    }

    public void setOriginalData(Object originalData) {
        this.originalData = originalData;
    }

    public void setDisplayWidth(int displayWidth) {
        this.displayWidth = displayWidth;
    }

    public void setPrecision(Precision precision) {
        this.precision = precision;
    }

    public void setObjectData(Object objectData) {
        this.objectData = objectData;
    }

    public void setCanSort(Boolean canSort) {
        this.canSort = canSort;
    }

    public void setSort(String sort) {
        this.sort = sort;
    }

    public void setCanFilter(Boolean canFilter) {
        this.canFilter = canFilter;
    }

    public void setFieldType(String fieldType) {
        this.fieldType = fieldType;
    }

    public void setCanEdit(boolean canEdit) {
        this.canEdit = canEdit;
    }

    public void setThemeMapTagOrder(Integer themeMapTagOrder) {
        this.themeMapTagOrder = themeMapTagOrder;
    }

    public void setSubFields(List<MetadataField> subFields) {
        this.subFields = subFields;
    }

    public void setOriginalFields(List<MetadataField> originalFields) {
        this.originalFields = originalFields;
    }

    public void setExportTableFields(List<MetadataField> exportTableFields) {
        this.exportTableFields = exportTableFields;
    }

    public void setArray(boolean array) {
        this.array = array;
    }

    public void setSourceApi(String sourceApi) {
        this.sourceApi = sourceApi;
    }

    public void setHead(boolean isHead) {
        this.isHead = isHead;
    }

    public void setClientAgent(String clientAgent) {
        this.clientAgent = clientAgent;
    }

    public void setEnumKey(String enumKey) {
        this.enumKey = enumKey;
    }

    public void setFieldMap(Map<String, MetadataField> fieldMap) {
        this.fieldMap = fieldMap;
    }

    public void setParentField(MetadataField parentField) {
        this.parentField = parentField;
    }

    public void setPercent(String percent) {
        this.percent = percent;
    }

    public void setDecimal(Integer decimal) {
        this.decimal = decimal;
    }

    public void setIsTime(Boolean isTime) {
        this.isTime = isTime;
    }

    public void setIsGroupBy(Boolean isGroupBy) {
        this.isGroupBy = isGroupBy;
    }

    public void setIsMainDimension(Boolean isMainDimension) {
        this.isMainDimension = isMainDimension;
    }

    public void setUiBot(String uiBot) {
        this.uiBot = uiBot;
    }

    public void setIsNavigate(Boolean isNavigate) {
        this.isNavigate = isNavigate;
    }

    public String getName() {
        return this.name;
    }

    public String getOriginalName() {
        return this.originalName;
    }

    public String getPath() {
        return this.path;
    }

    public boolean isRequired() {
        return this.required;
    }

    public String getDescription() {
        return this.description;
    }

    public String getRemark() {
        return this.remark;
    }

    public String getDataKey() {
        return this.dataKey;
    }

    public boolean isBusinessKey() {
        return this.businessKey;
    }

    public String getDataType() {
        return this.dataType;
    }

    public String getBusinessType() {
        return this.businessType;
    }

    public String getExplanation() {
        return this.explanation;
    }

    public String getDecimalRule() {
        return this.decimalRule;
    }

    public String getUnit() {
        return this.unit;
    }

    public Object getOriginalData() {
        return this.originalData;
    }

    public int getDisplayWidth() {
        return this.displayWidth;
    }

    public Precision getPrecision() {
        return this.precision;
    }

    public Object getObjectData() {
        return this.objectData;
    }

    public Boolean getCanSort() {
        return this.canSort;
    }

    public String getSort() {
        return this.sort;
    }

    public Boolean getCanFilter() {
        return this.canFilter;
    }

    public String getFieldType() {
        return this.fieldType;
    }

    public boolean isCanEdit() {
        return this.canEdit;
    }

    public Integer getThemeMapTagOrder() {
        return this.themeMapTagOrder;
    }

    public List<MetadataField> getSubFields() {
        return this.subFields;
    }

    public List<MetadataField> getOriginalFields() {
        return this.originalFields;
    }

    public List<MetadataField> getExportTableFields() {
        return this.exportTableFields;
    }

    public boolean isArray() {
        return this.array;
    }

    public String getSourceApi() {
        return this.sourceApi;
    }

    public boolean isHead() {
        return this.isHead;
    }

    public String getClientAgent() {
        return this.clientAgent;
    }

    public String getEnumKey() {
        return this.enumKey;
    }

    public Map<String, MetadataField> getFieldMap() {
        return this.fieldMap;
    }

    public MetadataField getParentField() {
        return this.parentField;
    }

    public String getPercent() {
        return this.percent;
    }

    public Integer getDecimal() {
        return this.decimal;
    }

    public Boolean getIsTime() {
        return this.isTime;
    }

    public Boolean getIsGroupBy() {
        return this.isGroupBy;
    }

    public Boolean getIsMainDimension() {
        return this.isMainDimension;
    }

    public String getUiBot() {
        return this.uiBot;
    }

    public Boolean getIsNavigate() {
        return this.isNavigate;
    }

    public MetadataField(String name, String originalName, String path, boolean required, String description, String remark, String dataKey, boolean businessKey, String dataType, String businessType, String explanation, String decimalRule, String unit, Object originalData, int displayWidth, Precision precision, Object objectData, Boolean canSort, String sort, Boolean canFilter, String fieldType, boolean canEdit, Integer themeMapTagOrder, List<MetadataField> subFields, List<MetadataField> originalFields, List<MetadataField> exportTableFields, boolean array, String sourceApi, boolean isHead, String clientAgent, String enumKey, Map<String, MetadataField> fieldMap, MetadataField parentField, String percent, Integer decimal, Boolean isTime, Boolean isGroupBy, Boolean isMainDimension, String uiBot, Boolean isNavigate) {
        this.name = name;
        this.originalName = originalName;
        this.path = path;
        this.required = required;
        this.description = description;
        this.remark = remark;
        this.dataKey = dataKey;
        this.businessKey = businessKey;
        this.dataType = dataType;
        this.businessType = businessType;
        this.explanation = explanation;
        this.decimalRule = decimalRule;
        this.unit = unit;
        this.originalData = originalData;
        this.displayWidth = displayWidth;
        this.precision = precision;
        this.objectData = objectData;
        this.canSort = canSort;
        this.sort = sort;
        this.canFilter = canFilter;
        this.fieldType = fieldType;
        this.canEdit = canEdit;
        this.themeMapTagOrder = themeMapTagOrder;
        this.subFields = subFields;
        this.originalFields = originalFields;
        this.exportTableFields = exportTableFields;
        this.array = array;
        this.sourceApi = sourceApi;
        this.isHead = isHead;
        this.clientAgent = clientAgent;
        this.enumKey = enumKey;
        this.fieldMap = fieldMap;
        this.parentField = parentField;
        this.percent = percent;
        this.decimal = decimal;
        this.isTime = isTime;
        this.isGroupBy = isGroupBy;
        this.isMainDimension = isMainDimension;
        this.uiBot = uiBot;
        this.isNavigate = isNavigate;
    }

    public MetadataField() {
    }
}

