/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.athena.show.metadata;

import com.digiwin.athena.agiledataecho.app.env.EchoEnvProperties;
import com.digiwin.athena.agiledataecho.constant.ErrorCodeEnum;
import com.digiwin.athena.appcore.domain.BaseResultDTO;
import com.digiwin.athena.appcore.exception.BusinessException;
import com.digiwin.athena.appcore.util.HttpUtils;
import com.digiwin.athena.appcore.util.JsonUtils;
import com.digiwin.athena.appcore.util.MessageUtils;
import com.digiwin.athena.show.metadata.ApiMetadata;
import com.digiwin.athena.show.metadata.MetadataDataDTO;
import com.digiwin.athena.show.metadata.MetadataField;
import com.digiwin.athena.show.metadata.MetadataFieldDTO;
import com.digiwin.athena.show.metadata.MetadataResponseDTO;
import com.digiwin.athena.show.metadata.MetadataService;
import com.digiwin.athena.show.metadata.Precision;
import com.digiwin.athena.show.util.ClassResourceUtil;
import com.fasterxml.jackson.core.type.TypeReference;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import net.sf.json.JSONObject;
import org.apache.commons.collections.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.core.ParameterizedTypeReference;
import org.springframework.http.HttpEntity;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpMethod;
import org.springframework.http.ResponseEntity;
import org.springframework.stereotype.Service;
import org.springframework.util.MultiValueMap;
import org.springframework.util.StringUtils;
import org.springframework.web.client.RestTemplate;

/*
 * Exception performing whole class analysis ignored.
 */
@Service
public class MetadataServiceImpl
implements MetadataService {
    private static final Logger log = LoggerFactory.getLogger(MetadataServiceImpl.class);
    @Autowired
    private EchoEnvProperties envProperties;
    @Autowired
    private RestTemplate restTemplate;
    @Autowired
    MessageUtils messageUtils;
    private static final String patternStr = "^\\((?<length>\\d*?),(?<place>\\d*?)\\)$|^(?<size>\\d*?)$";
    private static final Pattern pattern = Pattern.compile("^\\((?<length>\\d*?),(?<place>\\d*?)\\)$|^(?<size>\\d*?)$");
    static String METADATA_URL = "knowledgegraph/Action/Metadata";
    static String MODEL_CENTER_METADATA_URL = "scene/modelCenterMetaData";

    public ApiMetadata getMetadata(String locale, String actionId) {
        if (!StringUtils.hasText((String)actionId)) {
            return null;
        }
        if (StringUtils.isEmpty((Object)locale)) {
            locale = "zh_CN";
        }
        String url = this.envProperties.getKnowledgeMapsUrl() + METADATA_URL + "?actionId=" + actionId;
        HttpHeaders headers = new HttpHeaders();
        headers.add("locale", locale);
        HttpEntity requestEntity = new HttpEntity(null, (MultiValueMap)headers);
        try {
            ResponseEntity respEntity = this.restTemplate.exchange(url, HttpMethod.GET, requestEntity, (ParameterizedTypeReference)new /* Unavailable Anonymous Inner Class!! */, new Object[0]);
            BaseResultDTO resultDTO = HttpUtils.descResponseRtnBody((String)url, null, (ResponseEntity)respEntity, (TypeReference)new /* Unavailable Anonymous Inner Class!! */);
            if (resultDTO == null) {
                throw BusinessException.create((String)ErrorCodeEnum.METADATA_GET_ERROR.getErrCode(), (String)String.format(this.messageUtils.getMessage("exception.metadata.error"), actionId));
            }
            MetadataDataDTO metadataDataDTO = (MetadataDataDTO)resultDTO.getResponse();
            if (null == metadataDataDTO) {
                throw BusinessException.create((String)ErrorCodeEnum.METADATA_GET_ERROR.getErrCode(), (String)String.format(this.messageUtils.getMessage("exception.metadata.error"), actionId));
            }
            return this.createApiMetadata(metadataDataDTO);
        }
        catch (Exception e) {
            log.error("url: {}, error: ", (Object)url, (Object)e);
            throw e;
        }
    }

    public ApiMetadata getModelMetadata(String locale, String modelId) {
        if (!StringUtils.hasText((String)modelId)) {
            return null;
        }
        if (StringUtils.isEmpty((Object)locale)) {
            locale = "zh_CN";
        }
        String url = this.envProperties.getKnowledgeMapsUrl() + MODEL_CENTER_METADATA_URL;
        HttpHeaders headers = new HttpHeaders();
        headers.add("locale", locale);
        HashMap body = Maps.newHashMap();
        body.put("modelIds", Lists.newArrayList((Object[])new String[]{modelId}));
        HttpEntity requestEntity = new HttpEntity((Object)body, (MultiValueMap)headers);
        try {
            ResponseEntity respEntity = this.restTemplate.exchange(url, HttpMethod.POST, requestEntity, (ParameterizedTypeReference)new /* Unavailable Anonymous Inner Class!! */, new Object[0]);
            BaseResultDTO resultDTO = HttpUtils.descResponseRtnBody((String)url, null, (ResponseEntity)respEntity, (TypeReference)new /* Unavailable Anonymous Inner Class!! */);
            if (resultDTO == null) {
                throw BusinessException.create((String)ErrorCodeEnum.METADATA_GET_ERROR.getErrCode(), (String)String.format(this.messageUtils.getMessage("exception.metadata.error"), modelId));
            }
            MetadataDataDTO metadataDataDTO = (MetadataDataDTO)resultDTO.getResponse();
            if (null == metadataDataDTO) {
                throw BusinessException.create((String)ErrorCodeEnum.METADATA_GET_ERROR.getErrCode(), (String)String.format(this.messageUtils.getMessage("exception.metadata.error"), modelId));
            }
            return this.createApiMetadata(metadataDataDTO);
        }
        catch (Exception e) {
            log.error("url: {}, error: ", (Object)url, (Object)e);
            throw e;
        }
    }

    public ApiMetadata getMockMetadata(String actionId) {
        log.info("=== getMockMetadata, actionId: {}", (Object)actionId);
        if (!StringUtils.hasText((String)actionId)) {
            return null;
        }
        String resourcePath = MessageFormat.format("mock/apiMetadata/{0}.json", actionId);
        if (StringUtils.isEmpty((Object)resourcePath)) {
            return null;
        }
        try {
            String apiMetadataStr = ClassResourceUtil.readFile((String)resourcePath);
            JSONObject jsonStr = (JSONObject)JsonUtils.jsonToObject((String)apiMetadataStr, JSONObject.class);
            if (jsonStr.containsKey((Object)"response")) {
                MetadataDataDTO metadataDataDTO = (MetadataDataDTO)JsonUtils.jsonToObject((String)jsonStr.get("response").toString(), MetadataDataDTO.class);
                return this.createApiMetadata(metadataDataDTO);
            }
            return null;
        }
        catch (Exception e) {
            return null;
        }
    }

    public ApiMetadata createApiMetadata(MetadataDataDTO metadataDataDTO) {
        ApiMetadata apiMetadata = new ApiMetadata();
        String actionId = metadataDataDTO.getActionId();
        String serviceName = metadataDataDTO.getServiceName();
        apiMetadata.setActionId(actionId);
        apiMetadata.setServiceName(serviceName);
        if (metadataDataDTO.getRequest() != null && metadataDataDTO.getRequest().getParameters() != null) {
            apiMetadata.setRequestFields(MetadataServiceImpl.createMetadataField(new ArrayList(), (List)metadataDataDTO.getRequest().getParameters()));
        }
        if (metadataDataDTO.getResponse() != null && metadataDataDTO.getResponse().getData() != null) {
            apiMetadata.setResponseFields(MetadataServiceImpl.createMetadataField(new ArrayList(), (MetadataFieldDTO)metadataDataDTO.getResponse().getData()));
        }
        apiMetadata.setSceneNodeType(metadataDataDTO.getSceneNodeType());
        apiMetadata.setShowType(metadataDataDTO.getShowType());
        apiMetadata.setName(metadataDataDTO.getName());
        return apiMetadata;
    }

    public ApiMetadata createApiMetadata(String actionId, String serviceName, Object apiMetadataObj) {
        MetadataDataDTO metadataDataDTO = new MetadataDataDTO();
        metadataDataDTO.setActionId(actionId);
        metadataDataDTO.setServiceName(serviceName);
        MetadataFieldDTO data = (MetadataFieldDTO)JsonUtils.jsonToObject((String)JsonUtils.objectToString((Object)apiMetadataObj), MetadataFieldDTO.class);
        MetadataResponseDTO responseDTO = new MetadataResponseDTO();
        responseDTO.setData(data);
        metadataDataDTO.setResponse(responseDTO);
        ApiMetadata apiMetadata = new ApiMetadata();
        apiMetadata.setActionId(actionId);
        apiMetadata.setServiceName(serviceName);
        if (metadataDataDTO.getRequest() != null && metadataDataDTO.getRequest().getParameters() != null) {
            apiMetadata.setRequestFields(MetadataServiceImpl.createMetadataField(new ArrayList(), (List)metadataDataDTO.getRequest().getParameters()));
        }
        if (metadataDataDTO.getResponse() != null && metadataDataDTO.getResponse().getData() != null) {
            apiMetadata.setResponseFields(MetadataServiceImpl.createMetadataField(new ArrayList(), (MetadataFieldDTO)metadataDataDTO.getResponse().getData()));
        }
        return apiMetadata;
    }

    private static List<MetadataField> createMetadataField(List<MetadataField> requestFields, List<MetadataFieldDTO> metadataFieldDTOs) {
        for (MetadataFieldDTO metadataFieldDTO : metadataFieldDTOs) {
            Matcher m;
            MetadataField metadataField = new MetadataField();
            metadataField.setName(metadataFieldDTO.getData_name());
            if (metadataFieldDTO.getRequired() == null) {
                metadataField.setRequired(false);
            } else {
                metadataField.setRequired(metadataFieldDTO.getRequired().booleanValue());
            }
            metadataField.setDescription(metadataFieldDTO.getDescription());
            metadataField.setRemark(metadataFieldDTO.getRemark());
            metadataField.setBusinessKey(metadataFieldDTO.is_businesskey());
            metadataField.setDataKey(metadataFieldDTO.getIs_datakey());
            metadataField.setDataType(metadataFieldDTO.getData_type());
            metadataField.setEnumKey(metadataFieldDTO.getEnum_key());
            metadataField.setCanFilter(metadataFieldDTO.getCan_filter());
            metadataField.setCanSort(metadataFieldDTO.getCan_sort());
            metadataField.setSort(metadataFieldDTO.getSort());
            metadataField.setPercent(metadataFieldDTO.getPercent());
            metadataField.setDecimal(metadataFieldDTO.getDecimal());
            metadataField.setOriginalData(metadataFieldDTO.getOriginalData());
            if (metadataFieldDTO.getPrecision() != null && (m = pattern.matcher(metadataFieldDTO.getPrecision())).matches()) {
                Precision precision = new Precision();
                if (m.group("size") != null) {
                    precision.setLength(Integer.valueOf(Integer.parseInt(m.group("size"))));
                    metadataField.setPrecision(precision);
                } else if (m.group("length") != null && m.group("place") != null) {
                    precision.setLength(Integer.valueOf(Integer.parseInt(m.group("length"))));
                    precision.setPlace(Integer.valueOf(Integer.parseInt(m.group("place"))));
                    metadataField.setPrecision(precision);
                }
            }
            metadataField.setArray(metadataFieldDTO.is_array());
            if (CollectionUtils.isNotEmpty((Collection)metadataFieldDTO.getField())) {
                ArrayList subRequestFields = new ArrayList();
                metadataField.setSubFields(MetadataServiceImpl.createMetadataField(subRequestFields, (List)metadataFieldDTO.getField()));
            }
            if (CollectionUtils.isNotEmpty((Collection)metadataFieldDTO.getOriginalFields())) {
                ArrayList orgRequestFields = new ArrayList();
                metadataField.setOriginalFields(MetadataServiceImpl.createMetadataField(orgRequestFields, (List)metadataFieldDTO.getOriginalFields()));
            }
            requestFields.add(metadataField);
        }
        return requestFields;
    }

    private static List<MetadataField> createMetadataField(List<MetadataField> requestFields, MetadataFieldDTO metadataFieldDTO) {
        MetadataField metadataField = new MetadataField();
        metadataField.setName(metadataFieldDTO.getData_name());
        if (metadataFieldDTO.getRequired() == null) {
            metadataField.setRequired(false);
        } else {
            metadataField.setRequired(metadataFieldDTO.getRequired().booleanValue());
        }
        metadataField.setDescription(metadataFieldDTO.getDescription());
        metadataField.setRemark(metadataFieldDTO.getRemark());
        metadataField.setDataKey(metadataFieldDTO.getIs_datakey());
        metadataField.setBusinessKey(metadataFieldDTO.is_businesskey());
        metadataField.setDataType(metadataFieldDTO.getData_type());
        metadataField.setArray(metadataFieldDTO.is_array());
        metadataField.setEnumKey(metadataFieldDTO.getEnum_key());
        metadataField.setCanFilter(metadataFieldDTO.getCan_filter());
        metadataField.setCanSort(metadataFieldDTO.getCan_sort());
        if (CollectionUtils.isNotEmpty((Collection)metadataFieldDTO.getField())) {
            ArrayList subRequestFields = new ArrayList();
            metadataField.setSubFields(MetadataServiceImpl.createMetadataField(subRequestFields, (List)metadataFieldDTO.getField()));
        }
        requestFields.add(metadataField);
        return requestFields;
    }
}

