/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.athena.show.service;

import com.digiwin.athena.show.assistant.ExecuteContext;
import com.digiwin.athena.show.domain.agileDataDTO.TargetDTO;
import com.digiwin.athena.show.domain.showDefine.AgileReportKMData;
import com.digiwin.athena.show.metadata.ApiMetadata;
import com.digiwin.athena.show.service.AgileDataThemeMapDefine;
import java.util.List;
import java.util.Map;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;

@Service
public class AgileDataGeneralThemeMapDefine
extends AgileDataThemeMapDefine {
    public String supportKey() {
        return "AGILE_DATA_DEFINE_0";
    }

    public void buildScreenModel(AgileReportKMData agileReportKMData, ExecuteContext executeContext) {
    }

    public Boolean judgeDefine(String judgeCode, ExecuteContext executeContext, ApiMetadata apiMetadata, List<Map<String, Object>> agileDataListList, TargetDTO targetDTO, List<Map<String, Object>> pageData) {
        switch (judgeCode) {
            case "metadata": {
                if (apiMetadata != null) break;
                return true;
            }
            case "agileData": {
                if (this.checkPageData(agileDataListList)) break;
                return true;
            }
            case "target": {
                if (targetDTO != null) break;
                return true;
            }
            case "pageData": {
                if (!CollectionUtils.isEmpty(pageData)) break;
                return true;
            }
            default: {
                return false;
            }
        }
        return false;
    }

    private boolean checkPageData(List<Map<String, Object>> agileDataListList) {
        if (CollectionUtils.isEmpty(agileDataListList)) {
            return false;
        }
        for (Map<String, Object> agileMap : agileDataListList) {
            if (agileMap.containsKey("data")) continue;
            return false;
        }
        return true;
    }
}

