/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.athena.show.service;

import com.digiwin.athena.agiledataecho.constant.ErrorCodeEnum;
import com.digiwin.athena.agiledataecho.dto.EchoInformationReqDTO;
import com.digiwin.athena.agiledataecho.service.EchoInformationService;
import com.digiwin.athena.appcore.exception.BusinessException;
import com.digiwin.athena.appcore.util.MessageUtils;
import com.digiwin.athena.show.assistant.ExecuteContext;
import com.digiwin.athena.show.domain.agileDataDTO.AgileReportDataFindDTO;
import com.digiwin.athena.show.domain.agileDataDTO.AgileReportEChartDefineDTO;
import com.digiwin.athena.show.domain.agileDataDTO.AgileReportRuleDTO;
import com.digiwin.athena.show.domain.agileDataDTO.AgileReportShow;
import com.digiwin.athena.show.domain.agileDataDTO.ConvertGetAgileData;
import com.digiwin.athena.show.domain.showDefine.AgileReportKMData;
import com.digiwin.athena.show.metadata.ApiMetadata;
import com.digiwin.athena.show.metadata.MetadataField;
import com.digiwin.athena.show.util.layout.AgileDataCheck;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;

@Service
public abstract class CompletionEchartsDefine {
    private static final Logger log = LoggerFactory.getLogger(CompletionEchartsDefine.class);
    @Autowired
    private EchoInformationService echoInformationService;
    @Autowired
    private MessageUtils messageUtils;
    private static final String AGILE_DATA_DESCRIPTION = "\u7f3a\u5c11%s\u5b57\u6bb5\u8bbe\u5b9a\uff0c\u65e0\u6cd5\u5448\u73b0\u56fe\u5f62";
    private static final String AGILE_DATA_CONTENT = "\u5f53\u524d\u53d6\u5f97\u7684\u5404\u4e2a\u5b57\u6bb5\u7684\u4e2d\u82f1\u6587\u540d\u79f0\u53ca\u5176\u5bf9\u5e94%s";
    private static final String AGILE_DATA_EXTEND = "\u56fe\u5f62\u9700\u7ef4\u5ea6\u5ea6\u91cf\u81f3\u5c11\u5404\u6709\u4e00\u4e2a\uff0c\u6307\u6807\u5361\u9700\u81f3\u5c11\u4e00\u4e2a\u5ea6\u91cf\uff0c\u624d\u53ef\u5448\u73b0\uff0c\u8bf7\u4fee\u6539\u5b57\u6bb5\u5bf9\u5e94\u7ef4\u5ea6/\u5ea6\u91cf\uff0c\u6216\u8005\u589e\u52a0\u65b0\u7684\u7ef4\u5ea6/\u5ea6\u91cf\u5b57\u6bb5";

    public abstract String supportKey();

    public void completionEchartsDefine(AgileReportShow showInfo, AgileReportKMData agileReportKMData, ApiMetadata apiMetadata, ExecuteContext executeContext, Integer dimensionRelationShip, AgileReportRuleDTO agileReportRuleDTO) {
        if (CollectionUtils.isEmpty((Collection)showInfo.getEChart())) {
            ArrayList eChartDefineDTOList = Lists.newArrayList();
            List xaxisMetadataFields = ConvertGetAgileData.getStringField((String)"numeric", (String)showInfo.getTargetSource(), (ApiMetadata)apiMetadata, (Boolean)false);
            if (CollectionUtils.isEmpty((Collection)xaxisMetadataFields)) {
                if (!AgileDataCheck.isScreen((ExecuteContext)executeContext).booleanValue()) {
                    EchoInformationReqDTO echoInformationReqDTO = new EchoInformationReqDTO();
                    echoInformationReqDTO.setMessageId(Long.valueOf(executeContext.getMessageId()).longValue());
                    echoInformationReqDTO.setDescription(String.format(AGILE_DATA_DESCRIPTION, "\u7ef4\u5ea6"));
                    echoInformationReqDTO.setContent(String.format(AGILE_DATA_CONTENT, "\u7ef4\u5ea6"));
                    echoInformationReqDTO.setExtend(AGILE_DATA_EXTEND);
                    this.echoInformationService.submit(echoInformationReqDTO, executeContext.getAuthoredUser());
                    agileReportKMData.getShow().remove(showInfo);
                    throw BusinessException.create((String)ErrorCodeEnum.AGILE_REPORT_DATA_ERROR.getErrCode(), (String)this.messageUtils.getMessage("exception.agileReport.chat.empty.data"));
                }
                return;
            }
            List xAxis = this.getXAxis(xaxisMetadataFields, dimensionRelationShip);
            List seriesMetadataFields = ConvertGetAgileData.getStringField((String)"numeric", (String)showInfo.getTargetSource(), (ApiMetadata)apiMetadata, (Boolean)true);
            if (CollectionUtils.isEmpty((Collection)seriesMetadataFields)) {
                if (!AgileDataCheck.isScreen((ExecuteContext)executeContext).booleanValue()) {
                    EchoInformationReqDTO echoInformationReqDTO = new EchoInformationReqDTO();
                    echoInformationReqDTO.setMessageId(Long.valueOf(executeContext.getMessageId()).longValue());
                    echoInformationReqDTO.setDescription(String.format(AGILE_DATA_DESCRIPTION, "\u5ea6\u91cf"));
                    echoInformationReqDTO.setContent(String.format(AGILE_DATA_CONTENT, "\u5ea6\u91cf"));
                    echoInformationReqDTO.setExtend(AGILE_DATA_EXTEND);
                    this.echoInformationService.submit(echoInformationReqDTO, executeContext.getAuthoredUser());
                    agileReportKMData.getShow().remove(showInfo);
                    throw BusinessException.create((String)ErrorCodeEnum.AGILE_REPORT_DATA_ERROR.getErrCode(), (String)this.messageUtils.getMessage("exception.agileReport.chat.empty.data"));
                }
                return;
            }
            this.getEcharts(seriesMetadataFields, agileReportRuleDTO, apiMetadata, showInfo, xAxis, (List)eChartDefineDTOList);
            showInfo.setEChart((List)eChartDefineDTOList);
        }
    }

    protected abstract List<AgileReportDataFindDTO> getXAxis(List<MetadataField> var1, Integer var2);

    protected abstract void getEcharts(List<MetadataField> var1, AgileReportRuleDTO var2, ApiMetadata var3, AgileReportShow var4, List<AgileReportDataFindDTO> var5, List<AgileReportEChartDefineDTO> var6);
}

