/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.athena.show.service.impl;

import com.digiwin.athena.appcore.util.JsonUtils;
import com.digiwin.athena.appcore.util.SpringUtil;
import com.digiwin.athena.show.assistant.ExecuteContext;
import com.digiwin.athena.show.domain.agileDataDTO.AgileDataTag;
import com.digiwin.athena.show.domain.agileDataDTO.AgileModelCenterDefine;
import com.digiwin.athena.show.domain.agileDataDTO.AgileModelCenterDimension;
import com.digiwin.athena.show.domain.agileDataDTO.AgileModelCenterFilter;
import com.digiwin.athena.show.domain.agileDataDTO.AgileModelCenterSortField;
import com.digiwin.athena.show.domain.agileDataDTO.AgileReportDataFindDTO;
import com.digiwin.athena.show.domain.agileDataDTO.AgileReportEChartDefineDTO;
import com.digiwin.athena.show.domain.agileDataDTO.AgileReportIndex;
import com.digiwin.athena.show.domain.agileDataDTO.AgileReportRuleInfoDTO;
import com.digiwin.athena.show.domain.agileDataDTO.AgileReportShow;
import com.digiwin.athena.show.domain.agileDataDTO.AgileReportShowTypeDTO;
import com.digiwin.athena.show.domain.agileDataDTO.AgileReportShowTypeInfoDTO;
import com.digiwin.athena.show.domain.agileDataDTO.ChartBITypeEnum;
import com.digiwin.athena.show.domain.agileDataDTO.ConvertGetAgileData;
import com.digiwin.athena.show.domain.agileDataDTO.TargetDTO;
import com.digiwin.athena.show.domain.queryDefine.SnapDataDTO;
import com.digiwin.athena.show.domain.showDefine.AgileReportKMData;
import com.digiwin.athena.show.domain.showDefine.ThemeMapReport;
import com.digiwin.athena.show.metadata.ApiMetadata;
import com.digiwin.athena.show.metadata.MetadataDataDTO;
import com.digiwin.athena.show.metadata.MetadataField;
import com.digiwin.athena.show.metadata.MetadataService;
import com.digiwin.athena.show.service.AgileDataPageDefineService;
import com.digiwin.athena.show.util.ApiMetadataUtil;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import org.apache.commons.collections.MapUtils;
import org.apache.commons.lang.StringUtils;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;

@Service
public class AgileDataPageDefineModelCenterService
extends AgileDataPageDefineService {
    public String supportKey() {
        return "AGILEDATA_DEFINE_1";
    }

    protected void buildScreenModel(AgileReportKMData agileReportKMData, ExecuteContext executeContext) {
    }

    protected Boolean judgeDefine(String judgeCode, ExecuteContext executeContext, ApiMetadata apiMetadata, List<Map<String, Object>> agileDataListList, TargetDTO targetDTO, List<Map<String, Object>> pageData) {
        return false;
    }

    protected AgileReportKMData getAgileReportDefine(ExecuteContext executeContext, SnapDataDTO snapDataDTO) {
        AgileReportKMData agileReportKMData = this.getAgileReportChartData(snapDataDTO, executeContext);
        return agileReportKMData;
    }

    protected ApiMetadata getApiMetadata(SnapDataDTO snapDataDTO, ExecuteContext executeContext, String actionId) {
        ApiMetadata apiMetadata = null;
        if (snapDataDTO.getPageData().get(actionId) != null) {
            Object obj = snapDataDTO.getPageData().get(actionId);
            Map actionMap = Maps.newHashMap();
            Map metadataMap = Maps.newHashMap();
            if (obj instanceof Map) {
                actionMap = (Map)obj;
            } else {
                List metadataList = (List)obj;
                if (!CollectionUtils.isEmpty((Collection)metadataList)) {
                    actionMap = (Map)metadataList.get(0);
                }
            }
            if (MapUtils.isNotEmpty((Map)actionMap) && actionMap.containsKey("metadata")) {
                metadataMap = MapUtils.getMap(actionMap, (Object)"metadata");
            }
            MetadataDataDTO metadataDataDTO = null;
            if (MapUtils.isNotEmpty((Map)metadataMap)) {
                metadataDataDTO = (MetadataDataDTO)JsonUtils.jsonToObject((String)JsonUtils.objectToString((Object)metadataMap), MetadataDataDTO.class);
            }
            if (metadataDataDTO != null) {
                apiMetadata = ((MetadataService)SpringUtil.getBean(MetadataService.class)).createApiMetadata(metadataDataDTO);
            }
        }
        if (apiMetadata == null) {
            apiMetadata = ((MetadataService)SpringUtil.getBean(MetadataService.class)).getModelMetadata(executeContext.getLocale(), actionId);
        }
        return apiMetadata;
    }

    protected AgileDataTag getAgileDataTag(SnapDataDTO snapDataDTO, ExecuteContext executeContext, String actionId) {
        return null;
    }

    protected String getTitle(AgileReportShowTypeInfoDTO agileShowType, SnapDataDTO snapDataDTO, ApiMetadata apiMetadata, ThemeMapReport themeMapReport, ExecuteContext executeContext) {
        String title = agileShowType.getTitle();
        String timeTitle = this.getModelCenterTitleDate(snapDataDTO, apiMetadata);
        title = timeTitle + title;
        String sortTitle = this.getModelCenterTitleSort(snapDataDTO, themeMapReport);
        title = title + sortTitle;
        return title;
    }

    private String getModelCenterTitleSort(SnapDataDTO snapDataDTO, ThemeMapReport themeMapReport) {
        String sortTitle = "";
        if (CollectionUtils.isEmpty((Collection)snapDataDTO.getQuerySchema().getSortFields())) {
            return sortTitle;
        }
        List sortFields = snapDataDTO.getQuerySchema().getSortFields();
        if (sortFields.size() == 1) {
            AgileModelCenterSortField agileModelCenterSortField = (AgileModelCenterSortField)sortFields.get(0);
            if (StringUtils.equals((String)"asc", (String)agileModelCenterSortField.getOrder())) {
                sortTitle = "TOP " + themeMapReport.getPageData().size();
            }
            if (StringUtils.equals((String)"desc", (String)agileModelCenterSortField.getOrder())) {
                sortTitle = "DOWN " + themeMapReport.getPageData().size();
            }
        }
        return sortTitle;
    }

    private String getModelCenterTitleDate(SnapDataDTO snapDataDTO, ApiMetadata apiMetadata) {
        String dateTitle = "";
        if (snapDataDTO.getQuerySchema().getFilter() == null) {
            return dateTitle;
        }
        Map apiMap = ConvertGetAgileData.getFiledMap((String)ConvertGetAgileData.getRootFiled((ApiMetadata)apiMetadata), (ApiMetadata)apiMetadata);
        ArrayList filterList = Lists.newArrayList();
        AgileModelCenterFilter agileModelCenterFilter = snapDataDTO.getQuerySchema().getFilter();
        if (agileModelCenterFilter == null) {
            return dateTitle;
        }
        MetadataField metadataField = (MetadataField)apiMap.get(agileModelCenterFilter.getLeftValue());
        if (metadataField != null && StringUtils.equals((String)"date", (String)metadataField.getDataType())) {
            filterList.add(agileModelCenterFilter);
        }
        if (!CollectionUtils.isEmpty((Collection)agileModelCenterFilter.getChildren())) {
            filterList.addAll(this.getDateField(agileModelCenterFilter.getChildren(), apiMap));
        }
        String startTime = "";
        String endTime = "";
        String time = "";
        int timeSize = 0;
        ArrayList lessOperator = Lists.newArrayList((Object[])new String[]{"lt", "le"});
        ArrayList greaterOperator = Lists.newArrayList((Object[])new String[]{"gt", "ge"});
        for (AgileModelCenterFilter modelCenterFilter : filterList) {
            if (greaterOperator.contains(modelCenterFilter.getOperator())) {
                if (StringUtils.isEmpty((String)startTime)) {
                    startTime = modelCenterFilter.getRightValue();
                    continue;
                }
                startTime = "";
                continue;
            }
            if (lessOperator.contains(modelCenterFilter.getOperator())) {
                if (StringUtils.isEmpty((String)endTime)) {
                    endTime = modelCenterFilter.getRightValue();
                    continue;
                }
                endTime = "";
                continue;
            }
            time = timeSize > 0 ? "" : modelCenterFilter.getRightValue();
            ++timeSize;
        }
        if (StringUtils.isNotEmpty((String)startTime) && StringUtils.isNotEmpty((String)endTime)) {
            dateTitle = startTime + "~" + endTime;
        } else if (StringUtils.isNotEmpty((String)time)) {
            dateTitle = time;
        }
        return dateTitle;
    }

    private List<AgileModelCenterFilter> getDateField(List<AgileModelCenterFilter> filterList, Map<String, MetadataField> apiMap) {
        ArrayList dateList = Lists.newArrayList();
        filterList.stream().forEach(filter -> {
            MetadataField metadataField = (MetadataField)apiMap.get(filter.getLeftValue());
            if (metadataField != null && StringUtils.equals((String)"date", (String)metadataField.getDataType())) {
                dateList.add(filter);
            }
            if (!CollectionUtils.isEmpty((Collection)filter.getChildren())) {
                dateList.addAll(this.getDateField(filter.getChildren(), apiMap));
            }
        });
        return dateList;
    }

    private AgileReportKMData getAgileReportChartData(SnapDataDTO snapDataDTO, ExecuteContext executeContext) {
        AgileReportKMData agileReportKMData = new AgileReportKMData();
        AgileModelCenterDefine agileModelCenterDefine = snapDataDTO.getQuerySchema();
        if (agileModelCenterDefine == null) {
            return null;
        }
        agileReportKMData.setActionId(agileModelCenterDefine.getModelId());
        AgileReportShowTypeDTO agileReportShowTypeDTO = new AgileReportShowTypeDTO();
        AgileReportShowTypeInfoDTO showType = new AgileReportShowTypeInfoDTO();
        String biValue = ChartBITypeEnum.getValue((String)agileModelCenterDefine.getChartType());
        showType.setBiValue(biValue);
        if (StringUtils.equals((String)"0", (String)biValue) || StringUtils.equals((String)"2", (String)biValue)) {
            showType.setValue(Integer.valueOf(biValue));
        } else {
            showType.setValue(Integer.valueOf(1));
        }
        showType.setTitle(snapDataDTO.getSnapData().getTitle());
        agileReportShowTypeDTO.setType((List)Lists.newArrayList((Object[])new AgileReportShowTypeInfoDTO[]{showType}));
        this.completionModelData(snapDataDTO, agileModelCenterDefine.getModelId());
        AgileReportShow agileReportShow = new AgileReportShow();
        agileReportShow.setActionId(agileModelCenterDefine.getModelId());
        ApiMetadata apiMetadata = this.getApiMetadata(snapDataDTO, executeContext, agileModelCenterDefine.getModelId());
        agileReportShow.setTargetSource(super.getTargetSource(apiMetadata));
        switch (showType.getValue()) {
            case 1: {
                this.buildEChartDefine(agileModelCenterDefine, agileReportShow, showType, apiMetadata);
                break;
            }
            case 2: {
                agileReportShow.setAgileReportIndex(this.buildIndexDefine(agileReportShow, apiMetadata));
                break;
            }
        }
        agileReportKMData.setShowType((List)Lists.newArrayList((Object[])new AgileReportShowTypeDTO[]{agileReportShowTypeDTO}));
        agileReportKMData.setShow((List)Lists.newArrayList((Object[])new AgileReportShow[]{agileReportShow}));
        return agileReportKMData;
    }

    private void buildEChartDefine(AgileModelCenterDefine agileModelCenterDefine, AgileReportShow agileReportShow, AgileReportShowTypeInfoDTO showType, ApiMetadata apiMetadata) {
        AgileReportEChartDefineDTO eChart = new AgileReportEChartDefineDTO();
        if (CollectionUtils.isEmpty((Collection)agileModelCenterDefine.getDimensions())) {
            showType.setValue(Integer.valueOf(0));
            return;
        }
        AgileReportDataFindDTO agileReportDataFindDTO = new AgileReportDataFindDTO();
        String applyToField = ConvertGetAgileData.getApiFiled((String)agileReportShow.getTargetSource(), (ApiMetadata)apiMetadata, (String)((AgileModelCenterDimension)agileModelCenterDefine.getDimensions().get(0)).getField());
        if (StringUtils.isEmpty((String)applyToField)) {
            List applyMetadataList = ConvertGetAgileData.getStringField((String)"numeric", (String)agileReportShow.getTargetSource(), (ApiMetadata)apiMetadata, (Boolean)false);
            if (!CollectionUtils.isEmpty((Collection)applyMetadataList) && applyMetadataList.size() > 1) {
                showType.setValue(Integer.valueOf(0));
                return;
            }
            MetadataField metadataField = (MetadataField)applyMetadataList.get(0);
            applyToField = metadataField.getName();
        }
        if (StringUtils.isEmpty((String)applyToField)) {
            showType.setValue(Integer.valueOf(0));
            return;
        }
        agileReportDataFindDTO.setApplyToField(applyToField);
        ArrayList seriesList = Lists.newArrayList();
        agileModelCenterDefine.getMeasures().stream().forEach(measures -> {
            String measureField = ConvertGetAgileData.getApiFiled((String)agileReportShow.getTargetSource(), (ApiMetadata)apiMetadata, (String)measures.getField());
            AgileReportDataFindDTO series = new AgileReportDataFindDTO();
            series.setApplyToField(measureField);
            seriesList.add(series);
        });
        if (CollectionUtils.isEmpty((Collection)seriesList)) {
            List applyMetadataList = ConvertGetAgileData.getStringField((String)"numeric", (String)agileReportShow.getTargetSource(), (ApiMetadata)apiMetadata, (Boolean)true);
            applyMetadataList.stream().forEach(serieMetadataField -> {
                AgileReportDataFindDTO seriesDTO = new AgileReportDataFindDTO();
                seriesDTO.setApplyToField(serieMetadataField.getName());
                seriesList.add(seriesDTO);
            });
            if (CollectionUtils.isEmpty((Collection)seriesList)) {
                showType.setValue(Integer.valueOf(0));
                return;
            }
        }
        eChart.setXAxis(Arrays.asList(agileReportDataFindDTO));
        eChart.setSeries((List)seriesList);
        agileReportShow.setEChart((List)Lists.newArrayList((Object[])new AgileReportEChartDefineDTO[]{eChart}));
    }

    private AgileReportIndex buildIndexDefine(AgileReportShow agileReportShow, ApiMetadata apiMetadata) {
        AgileReportIndex agileReportIndex = new AgileReportIndex();
        ArrayList indexes = Lists.newArrayList();
        ApiMetadata masterApi = ConvertGetAgileData.getMasterMetadata((String)agileReportShow.getTargetSource(), (ApiMetadata)apiMetadata);
        ApiMetadataUtil.flatMetaData((ApiMetadata)masterApi);
        List metadataFields = ConvertGetAgileData.getTargetFiled((String)agileReportShow.getTargetSource(), (ApiMetadata)masterApi);
        if (!CollectionUtils.isEmpty((Collection)metadataFields)) {
            metadataFields.stream().forEach(metadataField -> {
                AgileReportIndex.AgileDataDefineIndex agileDataDefineIndex = new AgileReportIndex.AgileDataDefineIndex();
                AgileReportRuleInfoDTO agileReportRuleInfoDTO = new AgileReportRuleInfoDTO();
                agileReportRuleInfoDTO.setApplyToField(metadataField.getName());
                agileDataDefineIndex.setTitle(agileReportRuleInfoDTO);
                agileDataDefineIndex.setValue(agileReportRuleInfoDTO);
                indexes.add(agileDataDefineIndex);
            });
        }
        agileReportIndex.setIndexes((List)indexes);
        return agileReportIndex;
    }

    private List<Map<String, Object>> completionModelData(SnapDataDTO snapDataDTO, String modelId) {
        List pullList = Lists.newArrayList();
        Map paData = snapDataDTO.getPageData();
        List pageList = Lists.newArrayList();
        Object pageObj = paData.get(modelId);
        if (pageObj instanceof Collection) {
            pageList = (List)pageObj;
        } else {
            pageList.add((Map)pageObj);
        }
        if (!CollectionUtils.isEmpty((Collection)pageList)) {
            for (Map data : pageList) {
                data.put("actionId", modelId);
                Object pullData = data.get("data");
                if (pullData instanceof Collection) {
                    pullList = (List)pullData;
                    continue;
                }
                pullList.add((Map)pullData);
            }
        }
        return pullList;
    }
}

