/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.athena.show.service.impl;

import com.digiwin.athena.show.domain.agileDataDTO.AgileReportDataFindDTO;
import com.digiwin.athena.show.domain.agileDataDTO.AgileReportEChartDefineDTO;
import com.digiwin.athena.show.domain.agileDataDTO.AgileReportEChartParamsDTO;
import com.digiwin.athena.show.domain.agileDataDTO.AgileReportShow;
import com.digiwin.athena.show.domain.agileDataDTO.AgileReportShowTypeDTO;
import com.digiwin.athena.show.domain.agileDataDTO.ConvertGetAgileData;
import com.digiwin.athena.show.metadata.ApiMetadata;
import com.digiwin.athena.show.metadata.MetadataField;
import com.digiwin.athena.show.service.AgileReportEChartBuildService;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.collections.MapUtils;
import org.apache.commons.lang.StringUtils;
import org.springframework.stereotype.Service;

@Service
public class AgileReportEChartBuildServiceImpl
implements AgileReportEChartBuildService {
    public Map<String, Object> getChartParams(AgileReportShow agileReportShow, AgileReportShowTypeDTO agileReportShowTypeDTO, ApiMetadata apiMetadata, List<Map<String, Object>> data) {
        Map chartTypeMap = Maps.newHashMap();
        chartTypeMap.put("reportRelationFir", "");
        chartTypeMap.put("reportRelationSec", "");
        chartTypeMap.put("reportRelationThi", "");
        chartTypeMap.put("reportRelationFou", "");
        String nodeType = agileReportShowTypeDTO.getSceneNodeType();
        if (StringUtils.isEmpty((String)nodeType)) {
            nodeType = apiMetadata.getSceneNodeType();
        }
        if (StringUtils.isNotEmpty((String)nodeType)) {
            switch (nodeType) {
                case "1": {
                    chartTypeMap = this.getCompareChartParams(chartTypeMap, nodeType, agileReportShow, apiMetadata, data);
                    break;
                }
                case "2": {
                    chartTypeMap = this.getDistributeChartParams(chartTypeMap, nodeType, agileReportShow);
                    break;
                }
                case "3": {
                    chartTypeMap = this.getConstituteChartParams(chartTypeMap, nodeType, agileReportShow, apiMetadata, data);
                    break;
                }
                case "4": {
                    chartTypeMap = this.getContactChartParams(chartTypeMap, nodeType, agileReportShow);
                    break;
                }
            }
        }
        return chartTypeMap;
    }

    private Map<String, Object> getContactChartParams(Map<String, Object> chartTypeMap, String sceneNodeType, AgileReportShow agileReportShow) {
        AgileReportEChartDefineDTO agileReportEChartDefineDTO = new AgileReportEChartDefineDTO();
        if (CollectionUtils.isEmpty((Collection)agileReportShow.getEChart())) {
            return null;
        }
        agileReportEChartDefineDTO = (AgileReportEChartDefineDTO)agileReportShow.getEChart().get(0);
        chartTypeMap.put("nodeType", sceneNodeType);
        List agileReportDataFindDTOList = agileReportEChartDefineDTO.getSeries();
        if (StringUtils.isNotEmpty((String)agileReportEChartDefineDTO.getShowParams().getReportRelationFir())) {
            chartTypeMap.put("reportRelationFir", agileReportEChartDefineDTO.getShowParams().getReportRelationFir());
        } else if (CollectionUtils.isNotEmpty((Collection)agileReportDataFindDTOList)) {
            chartTypeMap.put("reportRelationFir", agileReportDataFindDTOList.size() > 2 ? "3\u4e2a\u53d8\u91cf" : "2\u4e2a\u53d8\u91cf");
        }
        return chartTypeMap;
    }

    private Map<String, Object> getConstituteChartParams(Map<String, Object> chartTypeMap, String sceneNodeType, AgileReportShow agileReportShow, ApiMetadata apiMetadata, List<Map<String, Object>> data) {
        String firType;
        AgileReportEChartDefineDTO agileReportEChartDefineDTO = new AgileReportEChartDefineDTO();
        if (CollectionUtils.isNotEmpty((Collection)agileReportShow.getEChart())) {
            agileReportEChartDefineDTO = (AgileReportEChartDefineDTO)agileReportShow.getEChart().get(0);
        }
        chartTypeMap.put("nodeType", sceneNodeType);
        AgileReportEChartParamsDTO agileReportEChartParamsDTO = agileReportEChartDefineDTO.getShowParams();
        switch (firType = this.getMetadataType(agileReportShow, apiMetadata.getResponseFields())) {
            case "date": {
                chartTypeMap.put("reportRelationFir", "\u968f\u65f6\u95f4\u53d8\u5316");
                this.buildConstituteDate(chartTypeMap, agileReportShow, data);
                break;
            }
            default: {
                chartTypeMap.put("reportRelationFir", "\u9759\u6001");
                chartTypeMap.put("reportRelationSec", agileReportEChartParamsDTO != null ? agileReportEChartParamsDTO.getReportRelationSec() : "");
            }
        }
        return chartTypeMap;
    }

    private void buildConstituteDate(Map<String, Object> chartTypeMap, AgileReportShow agileReportShow, List<Map<String, Object>> data) {
        AgileReportDataFindDTO xAxis;
        AgileReportEChartDefineDTO agileReportEChartDefineDTO = new AgileReportEChartDefineDTO();
        if (CollectionUtils.isNotEmpty((Collection)agileReportShow.getEChart())) {
            agileReportEChartDefineDTO = (AgileReportEChartDefineDTO)agileReportShow.getEChart().get(0);
        }
        AgileReportEChartParamsDTO agileReportEChartParamsDTO = agileReportEChartDefineDTO.getShowParams();
        List xAxisList = agileReportEChartDefineDTO.getXAxis();
        AgileReportDataFindDTO agileReportDataFindDTO = xAxis = xAxisList.size() > 1 ? (AgileReportDataFindDTO)xAxisList.get(0) : null;
        if (StringUtils.isNotEmpty((String)agileReportEChartParamsDTO.getReportRelationSec())) {
            chartTypeMap.put("reportRelationSec", agileReportEChartParamsDTO.getReportRelationSec());
        } else if (xAxis != null) {
            List dataList = this.getData(agileReportShow.getTargetSource(), xAxis.getApplyToField(), data);
            chartTypeMap.put("reportRelationSec", (dataList = dataList.stream().distinct().collect(Collectors.toList())).size() > 12 ? "\u591a\u5468\u671f" : "\u5c11\u6570\u5468\u671f");
        }
        if (StringUtils.isNotEmpty((String)agileReportEChartParamsDTO.getReportRelationThi())) {
            chartTypeMap.put("reportRelationThi", agileReportEChartParamsDTO.getReportRelationThi());
        }
    }

    private Map<String, Object> getDistributeChartParams(Map<String, Object> chartTypeMap, String sceneNodeType, AgileReportShow agileReportShow) {
        AgileReportEChartDefineDTO agileReportEChartDefineDTO = new AgileReportEChartDefineDTO();
        if (CollectionUtils.isNotEmpty((Collection)agileReportShow.getEChart())) {
            agileReportEChartDefineDTO = (AgileReportEChartDefineDTO)agileReportShow.getEChart().get(0);
        }
        chartTypeMap.put("nodeType", sceneNodeType);
        AgileReportEChartParamsDTO agileReportEChartParamsDTO = agileReportEChartDefineDTO.getShowParams();
        if (agileReportEChartParamsDTO == null) {
            return null;
        }
        List seriesList = agileReportEChartDefineDTO.getSeries();
        if (CollectionUtils.isNotEmpty((Collection)seriesList)) {
            switch (seriesList.size()) {
                case 0: {
                    chartTypeMap.put("reportRelationFir", "\u5355\u4e2a\u53d8\u91cf");
                    break;
                }
                case 1: {
                    chartTypeMap.put("reportRelationFir", "2\u4e2a\u53d8\u91cf");
                    break;
                }
                default: {
                    chartTypeMap.put("reportRelationFir", "3\u4e2a\u53d8\u91cf");
                }
            }
        }
        if (StringUtils.isNotEmpty((String)agileReportEChartParamsDTO.getReportRelationSec())) {
            chartTypeMap.put("reportRelationSec", agileReportEChartParamsDTO.getReportRelationSec());
        }
        return chartTypeMap;
    }

    private Map<String, Object> getCompareChartParams(Map<String, Object> chartTypeMap, String sceneNodeType, AgileReportShow agileReportShow, ApiMetadata apiMetadata, List<Map<String, Object>> data) {
        chartTypeMap.put("nodeType", sceneNodeType);
        String firType = this.getMetadataType(agileReportShow, apiMetadata.getResponseFields());
        if (StringUtils.isEmpty((String)firType)) {
            return chartTypeMap;
        }
        switch (firType) {
            case "date": {
                chartTypeMap.put("reportRelationFir", "\u57fa\u4e8e\u65f6\u95f4");
                this.buildCompareDate(chartTypeMap, agileReportShow, data);
                break;
            }
            default: {
                chartTypeMap.put("reportRelationFir", "\u57fa\u4e8e\u5206\u7c7b");
                this.buildCompareClassify(chartTypeMap, agileReportShow, data);
            }
        }
        return chartTypeMap;
    }

    private void buildCompareClassify(Map<String, Object> chartTypeMap, AgileReportShow agileReportShow, List<Map<String, Object>> data) {
        AgileReportEChartDefineDTO agileReportEChartDefineDTO = new AgileReportEChartDefineDTO();
        if (CollectionUtils.isNotEmpty((Collection)agileReportShow.getEChart())) {
            agileReportEChartDefineDTO = (AgileReportEChartDefineDTO)agileReportShow.getEChart().get(0);
        }
        AgileReportEChartParamsDTO agileReportEChartParamsDTO = agileReportEChartDefineDTO.getShowParams();
        List agileReportDataFindDTOList = agileReportEChartDefineDTO.getSeries();
        if (CollectionUtils.isNotEmpty((Collection)agileReportDataFindDTOList)) {
            if (agileReportDataFindDTOList.size() > 1) {
                chartTypeMap.put("reportRelationSec", "\u6bcf\u9879\u76ee2\u4e2a\u53d8\u91cf");
            } else {
                chartTypeMap.put("reportRelationSec", "\u6bcf\u9879\u76ee1\u4e2a\u53d8\u91cf");
                chartTypeMap.put("reportRelationThi", "\u5c11\u6570\u5206\u7c7b");
                chartTypeMap.put("reportRelationFou", "\u5c11\u6570\u9879\u76ee");
            }
        }
    }

    private void buildCompareDate(Map<String, Object> chartTypeMap, AgileReportShow agileReportShow, List<Map<String, Object>> data) {
        AgileReportDataFindDTO xAxis;
        AgileReportEChartDefineDTO agileReportEChartDefineDTO = new AgileReportEChartDefineDTO();
        if (CollectionUtils.isNotEmpty((Collection)agileReportShow.getEChart())) {
            agileReportEChartDefineDTO = (AgileReportEChartDefineDTO)agileReportShow.getEChart().get(0);
        }
        AgileReportEChartParamsDTO agileReportEChartParamsDTO = agileReportEChartDefineDTO.getShowParams();
        List xAxisList = agileReportEChartDefineDTO.getXAxis();
        AgileReportDataFindDTO agileReportDataFindDTO = xAxis = xAxisList.size() > 1 ? (AgileReportDataFindDTO)xAxisList.get(0) : null;
        if (agileReportEChartParamsDTO != null && StringUtils.isNotEmpty((String)agileReportEChartParamsDTO.getReportRelationSec())) {
            chartTypeMap.put("reportRelationSec", agileReportEChartParamsDTO.getReportRelationSec());
        } else if (xAxis != null) {
            List dataList = this.getData(agileReportShow.getTargetSource(), xAxis.getApplyToField(), data);
            dataList = dataList.stream().distinct().collect(Collectors.toList());
            chartTypeMap.put("reportRelationSec", "\u5c11\u6570\u5468\u671f");
        }
        List agileReportDataFindDTOList = agileReportEChartDefineDTO.getSeries();
        if (agileReportEChartParamsDTO != null && StringUtils.isNotEmpty((String)agileReportEChartParamsDTO.getReportRelationThi())) {
            chartTypeMap.put("reportRelationThi", agileReportEChartParamsDTO.getReportRelationThi());
        } else if (CollectionUtils.isNotEmpty((Collection)agileReportDataFindDTOList)) {
            chartTypeMap.put("reportRelationThi", "\u591a\u79cd\u5206\u7c7b");
        }
    }

    private String getMetadataType(AgileReportShow agileReportShow, List<MetadataField> metadataFieldList) {
        String fieldType = "";
        ArrayList agileReportDataFindDTOList = Lists.newArrayList();
        agileReportShow.getEChart().stream().forEach(echart -> agileReportDataFindDTOList.addAll(echart.getXAxis()));
        for (AgileReportDataFindDTO agileReportDataFindDTO : agileReportDataFindDTOList) {
            fieldType = this.getFieldType(agileReportDataFindDTO.getApplyToField(), metadataFieldList);
        }
        return fieldType;
    }

    private List<Object> getData(String target, String field, List<Map<String, Object>> data) {
        ArrayList values = Lists.newArrayList();
        ArrayList dataList = Lists.newArrayList();
        if (CollectionUtils.isNotEmpty(data)) {
            data.stream().forEach(mapData -> {
                List obj = ConvertGetAgileData.targetValue((String)target, (Object)mapData);
                if (obj instanceof Collection) {
                    dataList.addAll(obj);
                } else if (obj instanceof Map) {
                    dataList.add((Map)((Object)obj));
                }
            });
        }
        if (CollectionUtils.isNotEmpty((Collection)dataList)) {
            dataList.stream().forEach(resData -> values.add(MapUtils.getObject((Map)resData, (Object)field)));
        }
        return values;
    }

    private String getFieldType(String field, List<MetadataField> metadataFieldList) {
        String type = "";
        for (MetadataField metadataField : metadataFieldList) {
            if ("object".equals(metadataField.getDataType())) {
                type = this.getFieldType(field, metadataField.getSubFields());
                continue;
            }
            if (!StringUtils.equals((String)metadataField.getName(), (String)field)) continue;
            type = metadataField.getDataType();
            break;
        }
        return type;
    }
}

