/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.athena.show.service.impl;

import cn.hutool.core.util.NumberUtil;
import com.digiwin.athena.appcore.util.JsonUtils;
import com.digiwin.athena.show.domain.ActionParameterMapping;
import com.digiwin.athena.show.domain.agileDataDTO.AgileReportRuleDTO;
import com.digiwin.athena.show.domain.agileDataDTO.AgileReportRuleInfoDTO;
import com.digiwin.athena.show.domain.agileDataDTO.ConvertGetAgileData;
import com.digiwin.athena.show.domain.showDefine.ThemeMapReport;
import com.digiwin.athena.show.metadata.ApiMetadata;
import com.digiwin.athena.show.metadata.MetadataField;
import com.digiwin.athena.show.service.AgileReportRuleService;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import digiwin.chartsdk.beans.sdk.chart.ChartBase;
import digiwin.chartsdk.beans.sdk.chart.ChartBaseSeries;
import digiwin.chartsdk.beans.sdk.chart.ChartFormat;
import digiwin.chartsdk.beans.sdk.chart.ChartPointInfo;
import digiwin.chartsdk.beans.sdk.chart.Option;
import digiwin.chartsdk.beans.sdk.chart.Value;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.collections.MapUtils;
import org.apache.commons.lang.StringUtils;
import org.springframework.stereotype.Service;

@Service
public class AgileReportRuleServiceImpl
implements AgileReportRuleService {
    private static final List<String> CHART_TYPE = Lists.newArrayList((Object[])new String[]{"line", "bar"});

    public void buildTableDataRule(List<Map<String, Object>> pageData, List<AgileReportRuleDTO> agileRules) {
        if (CollectionUtils.isEmpty(agileRules)) {
            return;
        }
        agileRules.stream().forEach(agileRule -> pageData.stream().forEach(data -> {
            switch (agileRule.getType()) {
                case "alertShow": {
                    for (AgileReportRuleInfoDTO agileReportRuleInfoDTO : agileRule.getRules()) {
                        Object objValue = MapUtils.getObject((Map)data, (Object)agileReportRuleInfoDTO.getApplyToField());
                        if (!(objValue instanceof Double)) continue;
                        Double value = Double.valueOf(objValue.toString());
                        ActionParameterMapping actionParameterMapping = agileReportRuleInfoDTO.getRuleValue();
                        Double compareValue = null;
                        switch (actionParameterMapping.getType()) {
                            case "row": {
                                compareValue = MapUtils.getDoubleValue((Map)data, (Object)actionParameterMapping.getValue());
                                break;
                            }
                            case "constant": {
                                compareValue = Double.valueOf(actionParameterMapping.getValue());
                                break;
                            }
                        }
                        if (!this.alertField(value, compareValue, agileReportRuleInfoDTO).booleanValue()) continue;
                        data.put("alertShow", true);
                    }
                    break;
                }
            }
        }));
    }

    public void buildChartDataRule(Option option, List<Map<String, Object>> pageData, ThemeMapReport themeMapReport) {
        List searsList = (List)JsonUtils.jsonToObject((String)JsonUtils.objectToString((Object)option.getSeries()), List.class);
        for (int i = 0; i < searsList.size(); ++i) {
            Map sears = (Map)searsList.get(i);
            if (!CHART_TYPE.contains(MapUtils.getString((Map)sears, (Object)"type"))) {
                return;
            }
            this.buildAlertShow(sears, pageData, themeMapReport, searsList, i);
            this.buildMarkLine(sears, themeMapReport);
        }
        option.setSeries((Object)searsList);
    }

    public void buildChartDataRule(ChartBase chartBase, ThemeMapReport themeMapReport) {
        for (ChartBaseSeries chartBarSeries : chartBase.getChartBaseSeries()) {
            if (!CHART_TYPE.contains(chartBarSeries.getType())) {
                return;
            }
            this.bindAlertShow(chartBase, chartBarSeries, themeMapReport);
            this.bindMarkLine(chartBarSeries, themeMapReport);
        }
    }

    private void bindAlertShow(ChartBase chartBase, ChartBaseSeries chartBarSeries, ThemeMapReport themeMapReport) {
        List agileRules = themeMapReport.getAgileRule();
        if (CollectionUtils.isEmpty((Collection)agileRules)) {
            return;
        }
        ArrayList markPointList = Lists.newArrayList();
        for (AgileReportRuleDTO agileRule : agileRules) {
            switch (agileRule.getType()) {
                case "alertShow": {
                    for (AgileReportRuleInfoDTO agileReportRuleInfoDTO : agileRule.getRules()) {
                        List barList = chartBarSeries.getValues().stream().filter(x -> StringUtils.equals((String)"bar", (String)x.getType())).collect(Collectors.toList());
                        if (CollectionUtils.isEmpty(barList) || barList.size() > 2) continue;
                        chartBarSeries.getValues().stream().forEach(pointValue -> {
                            ArrayList pointList = Lists.newArrayList();
                            for (int i = 0; i < chartBase.getDatas().size(); ++i) {
                                Map data = (Map)chartBase.getDatas().get(i);
                                Object objValue = MapUtils.getObject((Map)data, (Object)pointValue.getName());
                                if (!NumberUtil.isNumber((CharSequence)objValue.toString())) continue;
                                Double value = Double.valueOf(objValue.toString());
                                ActionParameterMapping actionParameterMapping = agileReportRuleInfoDTO.getRuleValue();
                                Double compareValue = null;
                                switch (actionParameterMapping.getType()) {
                                    case "row": {
                                        compareValue = MapUtils.getDoubleValue((Map)data, (Object)actionParameterMapping.getValue());
                                        break;
                                    }
                                    case "constant": {
                                        compareValue = Double.valueOf(actionParameterMapping.getValue());
                                        break;
                                    }
                                }
                                if (!this.alertField(value, compareValue, agileReportRuleInfoDTO).booleanValue()) continue;
                                HashMap markMap = Maps.newHashMap();
                                markMap.put("value", value);
                                markMap.put("xAxis", i);
                                markMap.put("yAxis", value);
                                markPointList.add(markMap);
                            }
                            ChartPointInfo chartPointInfo = new ChartPointInfo();
                            chartPointInfo.setPointValues((List)pointList);
                            ChartFormat chartFormat = new ChartFormat();
                            chartFormat.setPercent(pointValue.getPercent());
                            chartFormat.setDecimal(pointValue.getDecimal());
                            chartPointInfo.setFormat(chartFormat);
                            pointValue.setPointName(chartPointInfo);
                        });
                    }
                    break;
                }
                case "growthRate": {
                    List barList = chartBarSeries.getValues().stream().filter(x -> StringUtils.equals((String)"bar", (String)x.getType())).collect(Collectors.toList());
                    if (CollectionUtils.isEmpty(barList) || barList.size() > 2) break;
                    Value value = (Value)barList.get(1);
                    ChartPointInfo chartPointInfo = new ChartPointInfo();
                    ArrayList pointList = Lists.newArrayList();
                    ChartFormat pointFormat = new ChartFormat();
                    Map fieldMap = ConvertGetAgileData.getAgileData((String)themeMapReport.getActionId(), (ApiMetadata)themeMapReport.getApiMetadata());
                    agileRule.getRules().stream().forEach(growRule -> {
                        MetadataField growMetadataField = (MetadataField)fieldMap.get(growRule.getApplyToField());
                        pointFormat.setDecimal(growMetadataField.getDecimal());
                        pointFormat.setPercent(growMetadataField.getPercent());
                        for (int i = 0; i < chartBase.getDatas().size(); ++i) {
                            Object pointObj;
                            Map data = (Map)chartBase.getDatas().get(i);
                            HashMap pointMap = Maps.newHashMap();
                            if (growMetadataField == null || !StringUtils.isNotEmpty((String)growMetadataField.getPercent()) || !((pointObj = MapUtils.getObject((Map)data, (Object)growRule.getApplyToField())) instanceof Number)) continue;
                            BigDecimal pointBigDecimal = new BigDecimal(String.valueOf(pointObj));
                            int scaleNum = growMetadataField.getDecimal() == null ? 3 : growMetadataField.getDecimal();
                            Double formatValue = null;
                            if (StringUtils.isNotEmpty((String)growMetadataField.getDecimalRule())) {
                                switch (growMetadataField.getDecimalRule()) {
                                    case "up": {
                                        formatValue = pointBigDecimal.setScale(scaleNum, 0).doubleValue();
                                        break;
                                    }
                                    case "down": {
                                        formatValue = pointBigDecimal.setScale(scaleNum, 1).doubleValue();
                                        break;
                                    }
                                    case "round": {
                                        formatValue = pointBigDecimal.setScale(scaleNum, 4).doubleValue();
                                        break;
                                    }
                                    case "absUp": {
                                        pointBigDecimal = pointBigDecimal.abs();
                                        formatValue = pointBigDecimal.setScale(scaleNum, 0).doubleValue();
                                        break;
                                    }
                                    case "absDown": {
                                        pointBigDecimal = pointBigDecimal.abs();
                                        formatValue = pointBigDecimal.setScale(scaleNum, 1).doubleValue();
                                        break;
                                    }
                                }
                            } else {
                                formatValue = pointBigDecimal.setScale(scaleNum, 4).doubleValue();
                            }
                            pointMap.put("value", formatValue);
                            pointMap.put("xAxis", i);
                            pointMap.put("yAxis", MapUtils.getObject((Map)data, (Object)value.getName()));
                            pointList.add(pointMap);
                        }
                    });
                    chartPointInfo.setFormat(pointFormat);
                    chartPointInfo.setPointValues((List)pointList);
                    value.setPointName(chartPointInfo);
                    break;
                }
            }
        }
    }

    private void bindMarkLine(ChartBaseSeries chartBarSeries, ThemeMapReport themeMapReport) {
        AgileReportRuleDTO agileReportRule;
        List agileRules = themeMapReport.getAgileRule();
        if (CollectionUtils.isEmpty((Collection)agileRules)) {
            return;
        }
        Optional<AgileReportRuleDTO> agileReportRuleOpt = agileRules.stream().filter(x -> StringUtils.equals((String)"markLine", (String)x.getType())).findFirst();
        if (agileReportRuleOpt.isPresent() && CollectionUtils.isNotEmpty((Collection)(agileReportRule = agileReportRuleOpt.get()).getRules())) {
            Map<String, List<AgileReportRuleInfoDTO>> ruleMap = agileReportRule.getRules().stream().filter(t -> StringUtils.isNotEmpty((String)t.getApplyToField())).collect(Collectors.groupingBy(AgileReportRuleInfoDTO::getApplyToField));
            chartBarSeries.getValues().stream().forEach(value -> {
                List agileDataRules;
                if (MapUtils.isNotEmpty((Map)ruleMap) && ruleMap.containsKey(value.getName()) && CollectionUtils.isNotEmpty((Collection)(agileDataRules = (List)ruleMap.get(value.getName())))) {
                    ArrayList markLineList = Lists.newArrayList();
                    agileDataRules.stream().forEach(rule -> {
                        switch (rule.getType()) {
                            case "avg": {
                                markLineList.add("average");
                                break;
                            }
                            case "max": {
                                markLineList.add("max");
                                break;
                            }
                            case "min": {
                                markLineList.add("min");
                                break;
                            }
                        }
                    });
                    value.setMarkLine((List)markLineList);
                }
            });
        }
    }

    private void buildMarkLine(Map<String, Object> sears, ThemeMapReport themeMapReport) {
        List agileRules = themeMapReport.getAgileRule();
        if (CollectionUtils.isEmpty((Collection)agileRules)) {
            return;
        }
        Optional<AgileReportRuleDTO> agileReportRuleOpt = agileRules.stream().filter(x -> StringUtils.equals((String)"markLine", (String)x.getType())).findFirst();
        if (agileReportRuleOpt.isPresent()) {
            Map<String, List<AgileReportRuleInfoDTO>> ruleMap;
            HashMap markLineMap = Maps.newHashMap();
            ArrayList markLineList = Lists.newArrayList();
            AgileReportRuleDTO agileReportRule = agileReportRuleOpt.get();
            String schemaName = MapUtils.getString(sears, (Object)"name");
            List metadataFields = ConvertGetAgileData.getTargetFiled((String)themeMapReport.getActionId(), (ApiMetadata)themeMapReport.getApiMetadata());
            MetadataField markLineField = new MetadataField();
            for (MetadataField metadataField : metadataFields) {
                if (!StringUtils.equals((String)schemaName, (String)metadataField.getDescription())) continue;
                markLineField = metadataField;
                break;
            }
            List<Object> agileDataRules = Lists.newArrayList();
            if (CollectionUtils.isNotEmpty((Collection)agileReportRule.getRules()) && MapUtils.isNotEmpty(ruleMap = agileReportRule.getRules().stream().filter(t -> StringUtils.isNotEmpty((String)t.getApplyToField())).collect(Collectors.groupingBy(AgileReportRuleInfoDTO::getApplyToField))) && ruleMap.containsKey(markLineField.getName())) {
                agileDataRules = ruleMap.get(markLineField.getName());
            }
            if (CollectionUtils.isNotEmpty((Collection)agileDataRules)) {
                agileDataRules.forEach(rule -> {
                    switch (rule.getType()) {
                        case "avg": {
                            HashMap avgMap = Maps.newHashMap();
                            avgMap.put("type", "average");
                            avgMap.put("name", rule.getName());
                            markLineList.add(avgMap);
                            break;
                        }
                        case "max": {
                            HashMap maxMap = Maps.newHashMap();
                            maxMap.put("type", "max");
                            maxMap.put("name", rule.getName());
                            markLineList.add(maxMap);
                            break;
                        }
                        case "min": {
                            HashMap minMap = Maps.newHashMap();
                            minMap.put("type", "min");
                            minMap.put("name", rule.getName());
                            markLineList.add(minMap);
                            break;
                        }
                    }
                });
            }
            if (CollectionUtils.isNotEmpty((Collection)markLineList)) {
                markLineMap.put("data", markLineList);
                HashMap markLabelMap = Maps.newHashMap();
                markLabelMap.put("position", "insideEndTop");
                markLineMap.put("label", markLabelMap);
                sears.put("markLine", markLineMap);
            }
        }
    }

    private void buildAlertShow(Map<String, Object> sears, List<Map<String, Object>> pageData, ThemeMapReport themeMapReport, List<Map<String, Object>> searsList, int index) {
        List agileRules = themeMapReport.getAgileRule();
        ArrayList markPointList = Lists.newArrayList();
        List dataList = (List)MapUtils.getObject(sears, (Object)"data");
        if (CollectionUtils.isNotEmpty((Collection)dataList)) {
            String growthRateField = "";
            for (int i = 0; i < dataList.size(); ++i) {
                Object objValue = dataList.get(i);
                if (!NumberUtil.isNumber((CharSequence)objValue.toString())) continue;
                Double value = Double.valueOf(objValue.toString());
                Map<String, Object> compareMap = pageData.get(i);
                if (CollectionUtils.isEmpty((Collection)agileRules)) continue;
                for (AgileReportRuleDTO agileRule : agileRules) {
                    switch (agileRule.getType()) {
                        case "alertShow": {
                            for (AgileReportRuleInfoDTO agileReportRuleInfoDTO : agileRule.getRules()) {
                                ActionParameterMapping actionParameterMapping = agileReportRuleInfoDTO.getRuleValue();
                                Double compareValue = null;
                                switch (actionParameterMapping.getType()) {
                                    case "row": {
                                        compareValue = MapUtils.getDoubleValue((Map)compareMap, (Object)actionParameterMapping.getValue());
                                        break;
                                    }
                                    case "constant": {
                                        compareValue = Double.valueOf(actionParameterMapping.getValue());
                                        break;
                                    }
                                }
                                if (!this.alertField(value, compareValue, agileReportRuleInfoDTO).booleanValue()) continue;
                                HashMap markMap = Maps.newHashMap();
                                markMap.put("value", value);
                                markMap.put("xAxis", i);
                                markMap.put("yAxis", value);
                                markPointList.add(markMap);
                            }
                            break;
                        }
                        case "growthRate": {
                            List barList = searsList.stream().filter(x -> StringUtils.equals((String)"bar", (String)MapUtils.getString((Map)x, (Object)"type"))).collect(Collectors.toList());
                            if (CollectionUtils.isEmpty(barList) || barList.size() > 2 || index != 1) break;
                            String growthField = "";
                            if (!CollectionUtils.isEmpty((Collection)agileRule.getRules())) {
                                growthRateField = growthField = ((AgileReportRuleInfoDTO)agileRule.getRules().get(0)).getApplyToField();
                            }
                            Double growthValue = MapUtils.getDoubleValue((Map)compareMap, (Object)growthField);
                            HashMap markMap = Maps.newHashMap();
                            markMap.put("value", growthValue);
                            markMap.put("xAxis", i);
                            markMap.put("yAxis", value);
                            markPointList.add(markMap);
                            break;
                        }
                    }
                }
            }
            if (CollectionUtils.isNotEmpty((Collection)markPointList)) {
                HashMap markPoint = Maps.newHashMap();
                markPoint.put("data", markPointList);
                if (!StringUtils.isEmpty((String)growthRateField)) {
                    List metadataFields = ConvertGetAgileData.getTargetFiled((String)themeMapReport.getActionId(), (ApiMetadata)themeMapReport.getApiMetadata());
                    MetadataField growMetadataField = new MetadataField();
                    for (MetadataField metadataField : metadataFields) {
                        if (!StringUtils.equals((String)growthRateField, (String)metadataField.getName())) continue;
                        growMetadataField = metadataField;
                        break;
                    }
                    HashMap formatMap = Maps.newHashMap();
                    if (growMetadataField.getPercent() != null) {
                        formatMap.put("percent", growMetadataField.getPercent());
                        for (Map point : markPointList) {
                            Object pointObj = MapUtils.getObject((Map)point, (Object)"value");
                            if (!(pointObj instanceof Number)) continue;
                            BigDecimal pointBigDecimal = new BigDecimal(String.valueOf(pointObj));
                            int scaleNum = growMetadataField.getDecimal() == null ? 3 : growMetadataField.getDecimal();
                            Double formatValue = pointBigDecimal.setScale(scaleNum, 4).doubleValue();
                            point.put("value", formatValue);
                        }
                    }
                    if (growMetadataField.getDecimal() != null) {
                        formatMap.put("decimal", growMetadataField.getDecimal());
                    }
                    markPoint.put("format", formatMap);
                } else if (sears.containsKey("format")) {
                    markPoint.put("format", MapUtils.getObject(sears, (Object)"format"));
                }
                sears.put("markPoint", markPoint);
            }
        }
    }

    private Boolean alertField(Double value, Double compareValue, AgileReportRuleInfoDTO agileReportRuleInfoDTO) {
        Boolean isShow = false;
        if (!Double.isNaN(compareValue)) {
            switch (agileReportRuleInfoDTO.getOperation()) {
                case "gt": {
                    isShow = value.compareTo(compareValue) > 0;
                    break;
                }
                case "lt": {
                    isShow = value.compareTo(compareValue) < 0;
                    break;
                }
                case "eq": {
                    isShow = value.compareTo(compareValue) == 0;
                    break;
                }
            }
        }
        return isShow;
    }
}

