/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.athena.show.service.impl;

import com.digiwin.athena.agiledataecho.domain.AgileDataStandardReq;
import com.digiwin.athena.agiledataecho.proxy.adt.AdtService;
import com.digiwin.athena.show.analyzer.AgileReportPageDefineAnalyzer;
import com.digiwin.athena.show.assistant.ExecuteContext;
import com.digiwin.athena.show.component.AbstractComponent;
import com.digiwin.athena.show.component.echarts.EchartsComponent;
import com.digiwin.athena.show.domain.agileDataDTO.AgileReport;
import com.digiwin.athena.show.domain.agileDataDTO.AgileReportChartTypeEnum;
import com.digiwin.athena.show.domain.agileDataDTO.MobileDSLAgileData;
import com.digiwin.athena.show.domain.queryDefine.SnapDataDTO;
import com.digiwin.athena.show.domain.showDefine.AgileDataStandardComponent;
import com.digiwin.athena.show.domain.showDefine.AgileDataStandardShow;
import com.digiwin.athena.show.domain.showDefine.DynamicAgileData;
import com.digiwin.athena.show.domain.showDefine.MobileDSLAgileComponent;
import com.digiwin.athena.show.service.AgileReportService;
import com.digiwin.athena.show.template.AgileReportPageTemplate;
import com.digiwin.athena.show.util.layout.AgileDataCheck;
import com.google.common.collect.Maps;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.collections.MapUtils;
import org.apache.commons.compress.utils.Lists;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class AgileReportServiceImpl
implements AgileReportService {
    private static final Logger log = LoggerFactory.getLogger(AgileReportServiceImpl.class);
    @Autowired
    private AgileReportPageDefineAnalyzer agileReportPageDefineAnalyzer;
    @Autowired
    private List<AgileReportPageTemplate> pageDefines;
    @Autowired
    private AdtService adtService;

    public DynamicAgileData createAgileReportTemplateTable(ExecuteContext executeContext, SnapDataDTO snapDataDTO) {
        AgileReport agileReport = this.agileReportPageDefineAnalyzer.analysis(executeContext, snapDataDTO);
        return Objects.requireNonNull(this.getPageDefine(executeContext)).createAgileReport(executeContext, agileReport);
    }

    public String getShowType(DynamicAgileData dynamicAgileData, String defaultShowType) {
        String showType = null;
        if (dynamicAgileData != null) {
            List layout = dynamicAgileData.getLayout();
            if (CollectionUtils.isEmpty((Collection)layout)) {
                return showType;
            }
            for (AbstractComponent abstractComponent : layout) {
                if (abstractComponent instanceof MobileDSLAgileComponent) {
                    String chartType;
                    MobileDSLAgileData mobileDSLAgileData;
                    MobileDSLAgileComponent mobileDSLAgileComponent = (MobileDSLAgileComponent)abstractComponent;
                    if (!CollectionUtils.isNotEmpty((Collection)mobileDSLAgileComponent.getData()) || !StringUtils.equals((String)"1", (String)(showType = String.valueOf((mobileDSLAgileData = (MobileDSLAgileData)mobileDSLAgileComponent.getData().get(0)).getShowCategory()))) || mobileDSLAgileData.getChartRenderSetting() == null) continue;
                    switch (chartType = mobileDSLAgileData.getChartRenderSetting().getChartType()) {
                        case "mixed": {
                            showType = defaultShowType;
                            break;
                        }
                        default: {
                            showType = String.valueOf(AgileReportChartTypeEnum.getValueByType((String)chartType));
                        }
                    }
                    continue;
                }
                switch (abstractComponent.getType()) {
                    case "STATISTIC": {
                        showType = "2";
                        break;
                    }
                    case "TABLE": {
                        showType = "0";
                        break;
                    }
                    case "ECHARTS": {
                        EchartsComponent echartsComponent;
                        if (!(abstractComponent instanceof EchartsComponent) || !StringUtils.equals((String)"4", (String)(showType = String.valueOf((echartsComponent = (EchartsComponent)abstractComponent).getChartType())))) break;
                        showType = defaultShowType;
                    }
                }
            }
        }
        return showType;
    }

    public AgileDataStandardShow getAgileDataStandardShow(AgileDataStandardReq agileDataStandardReq) {
        AgileDataStandardShow agileDataStandardShow = new AgileDataStandardShow();
        HashMap typeMap = Maps.newHashMap();
        agileDataStandardShow.setTypeMap((Map)typeMap);
        ArrayList showDefine = Lists.newArrayList();
        agileDataStandardShow.setShowDefine((List)showDefine);
        ExecuteContext executeContext = ExecuteContext.createByHttpRequest();
        String entry = "0";
        if (CollectionUtils.isEmpty((Collection)agileDataStandardReq.getSnapshotIds())) {
            return null;
        }
        agileDataStandardReq.getSnapshotIds().stream().forEach(snapshotId -> {
            SnapDataDTO agileReportDTO = this.adtService.getAdtReportBySnapshotId(snapshotId, executeContext.getLocale());
            if (AgileDataCheck.sceneBasicCheck((SnapDataDTO)agileReportDTO).booleanValue()) {
                return;
            }
            executeContext.appendAgileDataPageInfo("Standard-page", agileReportDTO, agileReportDTO.getSnapData().getReportCode(), entry, null);
            try {
                DynamicAgileData agileData = this.createAgileReportTemplateTable(executeContext, agileReportDTO);
                if (CollectionUtils.isNotEmpty((Collection)agileData.getLayout())) {
                    agileData.getLayout().stream().forEach(component -> {
                        AgileDataStandardComponent agileDataStandardComponent = new AgileDataStandardComponent();
                        agileDataStandardComponent.setComponentId(component.getId());
                        agileDataStandardComponent.setAbstractComponent(component);
                        agileDataStandardComponent.setSnapshotId(snapshotId);
                        showDefine.add(agileDataStandardComponent);
                        switch (component.getType()) {
                            case "STATISTIC": {
                                agileDataStandardComponent.setShowType("2");
                                component.setType("2");
                                typeMap.put("2", "statistic");
                                break;
                            }
                            case "TABLE": {
                                agileDataStandardComponent.setShowType("0");
                                component.setType("0");
                                typeMap.put("0", "table");
                                break;
                            }
                            case "ECHARTS": {
                                EchartsComponent echartsComponent = (EchartsComponent)component;
                                component.setType(String.valueOf(echartsComponent.getChartType()));
                                agileDataStandardComponent.setShowType(String.valueOf(echartsComponent.getChartType()));
                                typeMap.put(String.valueOf(echartsComponent.getChartType()), AgileReportChartTypeEnum.getTypeByValue((Integer)echartsComponent.getChartType()));
                                break;
                            }
                        }
                    });
                }
            }
            catch (Exception e) {
                log.error("\u89e3\u6790\u5448\u73b0\u7ed3\u6784\u5f02\u5e38\uff1a{}", (Object)e.getMessage());
            }
        });
        return agileDataStandardShow;
    }

    private AgileReportPageTemplate getPageDefine(ExecuteContext executeContext) {
        Map agileData = executeContext.getAgileData();
        String entry = MapUtils.getString((Map)agileData, (Object)"entry");
        entry = StringUtils.equals((String)"1", (String)entry) ? "SCREEN" : "GENERA";
        AgileReportPageTemplate agileReportPageTemplate = null;
        for (AgileReportPageTemplate template : this.pageDefines) {
            String supportKey = "AGILE_DATA_TEMPLATE_" + entry;
            if (!StringUtils.equals((String)template.supportKey(), (String)supportKey)) continue;
            agileReportPageTemplate = template;
            break;
        }
        return agileReportPageTemplate;
    }
}

