/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.athena.show.service.impl;

import com.digiwin.athena.show.domain.agileDataDTO.AgileReportDataFindDTO;
import com.digiwin.athena.show.domain.agileDataDTO.AgileReportEChartDefineDTO;
import com.digiwin.athena.show.domain.agileDataDTO.AgileReportRuleDTO;
import com.digiwin.athena.show.domain.agileDataDTO.AgileReportShow;
import com.digiwin.athena.show.domain.agileDataDTO.ConvertGetAgileData;
import com.digiwin.athena.show.metadata.ApiMetadata;
import com.digiwin.athena.show.metadata.MetadataField;
import com.digiwin.athena.show.service.CompletionEchartsDefine;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;

@Service
public class CompletionMixDefineImpl
extends CompletionEchartsDefine {
    private static final Logger log = LoggerFactory.getLogger(CompletionMixDefineImpl.class);

    public String supportKey() {
        return "ECHARTS_DEFINE_4";
    }

    protected List<AgileReportDataFindDTO> getXAxis(List<MetadataField> xAxisMetadataFields, Integer dimensionRelationShip) {
        ArrayList xAxisArray = Lists.newArrayList();
        AgileReportDataFindDTO xAxis = new AgileReportDataFindDTO();
        MetadataField mainDimension = null;
        if (dimensionRelationShip != null && dimensionRelationShip == 0) {
            mainDimension = xAxisMetadataFields.stream().filter(metadataField -> metadataField.getIsMainDimension() != null && metadataField.getIsMainDimension() != false).findFirst().orElse(null);
        }
        if (mainDimension == null) {
            mainDimension = xAxisMetadataFields.get(0);
        }
        xAxis.setApplyToField(mainDimension.getName());
        xAxis.setTitle(mainDimension.getDescription());
        xAxisArray.add(xAxis);
        return xAxisArray;
    }

    protected void getEcharts(List<MetadataField> yAxisMetadataFields, AgileReportRuleDTO agileReportRuleDTO, ApiMetadata apiMetadata, AgileReportShow showInfo, List<AgileReportDataFindDTO> xAxis, List<AgileReportEChartDefineDTO> eChartDefineDTOList) {
        ApiMetadata masterMetadata = ConvertGetAgileData.getMasterMetadata((String)showInfo.getTargetSource(), (ApiMetadata)apiMetadata);
        Map filedMap = ConvertGetAgileData.getFiledMap((String)showInfo.getTargetSource(), (ApiMetadata)masterMetadata);
        agileReportRuleDTO.getRules().sort(Comparator.comparing(direction -> "left".equals(direction.getDirection()) ? 0 : 1));
        agileReportRuleDTO.getRules().stream().forEach(rule -> rule.getAreaDefine().stream().forEach(area -> {
            ArrayList series = Lists.newArrayList();
            AgileReportEChartDefineDTO eChart = new AgileReportEChartDefineDTO();
            eChart.setXAxis(xAxis);
            area.getApplyToFields().stream().forEach(areaField -> {
                MetadataField field = (MetadataField)filedMap.get(areaField);
                if (field == null) {
                    return;
                }
                AgileReportDataFindDTO seriesDTO = new AgileReportDataFindDTO();
                seriesDTO.setApplyToField(field.getName());
                seriesDTO.setTitle(field.getDescription());
                seriesDTO.setChart(area.getChart());
                series.add(seriesDTO);
            });
            eChart.setSeries((List)series);
            eChartDefineDTOList.add(eChart);
        }));
    }
}

