/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.athena.show.service.impl;

import cn.hutool.json.JSONUtil;
import com.digiwin.athena.agiledataecho.constant.ErrorCodeEnum;
import com.digiwin.athena.agiledataecho.domain.AgileDataUserDefine;
import com.digiwin.athena.agiledataecho.dto.aiBoard.AIBoardLayout;
import com.digiwin.athena.agiledataecho.dto.aiBoard.AIBoardQueryReq;
import com.digiwin.athena.agiledataecho.dto.aiBoard.AIBoardQuestionDTO;
import com.digiwin.athena.agiledataecho.dto.aiBoard.EchoAIBoardDTO;
import com.digiwin.athena.agiledataecho.proxy.adt.AdtService;
import com.digiwin.athena.agiledataecho.proxy.scrumbi.ScrumBIService;
import com.digiwin.athena.agiledataecho.proxy.scrumbi.dto.ScrumBILayoutReq;
import com.digiwin.athena.agiledataecho.service.aiBoard.EchoAiBoardService;
import com.digiwin.athena.appcore.auth.domain.AuthoredUser;
import com.digiwin.athena.appcore.exception.BusinessException;
import com.digiwin.athena.appcore.util.MessageUtils;
import com.digiwin.athena.show.assistant.EchoShowConstants;
import com.digiwin.athena.show.assistant.ExecuteContext;
import com.digiwin.athena.show.component.gridster.GridGroupDTO;
import com.digiwin.athena.show.component.index.AgileDataIndexComponent;
import com.digiwin.athena.show.domain.agileDataDTO.ConvertAgileDataRelation;
import com.digiwin.athena.show.domain.agileDataDTO.ConvertGetAgileData;
import com.digiwin.athena.show.domain.board.BoardLayoutDTO;
import com.digiwin.athena.show.domain.board.BoardLayoutMongoData;
import com.digiwin.athena.show.domain.board.BoardLayoutParamsDTO;
import com.digiwin.athena.show.domain.board.BoardSnapResultDTO;
import com.digiwin.athena.show.domain.board.SnapShotInfo;
import com.digiwin.athena.show.domain.dynamicLayout.BordDynamicDTO;
import com.digiwin.athena.show.domain.queryDefine.SnapDataDTO;
import com.digiwin.athena.show.domain.showDefine.DynamicAgileData;
import com.digiwin.athena.show.manager.themeMap.ThemeAgileDataService;
import com.digiwin.athena.show.manager.themeMap.domain.ThemeMapBoardDTO;
import com.digiwin.athena.show.metadata.ApiMetadata;
import com.digiwin.athena.show.metadata.MetadataField;
import com.digiwin.athena.show.service.AgileDataBestShowRuleService;
import com.digiwin.athena.show.service.AgileReportService;
import com.digiwin.athena.show.service.DynamicLayoutBoardService;
import com.digiwin.athena.show.service.impl.AgileDataPageDefineThemeMapService;
import com.digiwin.athena.show.service.impl.DynamicLayoutBoardServiceImpl;
import com.digiwin.athena.show.util.layout.AgileDataBoardComponentBuild;
import com.digiwin.athena.show.util.layout.AgileDataCheck;
import com.digiwin.athena.show.util.layout.BoardLayoutPlanner;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.atomic.AtomicReference;
import java.util.stream.Collectors;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.collections.MapUtils;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.data.mongodb.core.MongoTemplate;
import org.springframework.data.mongodb.core.query.Criteria;
import org.springframework.data.mongodb.core.query.CriteriaDefinition;
import org.springframework.data.mongodb.core.query.Query;
import org.springframework.data.mongodb.core.query.Update;
import org.springframework.data.mongodb.core.query.UpdateDefinition;
import org.springframework.stereotype.Service;

/*
 * Exception performing whole class analysis ignored.
 */
@Service
public class DynamicLayoutBoardServiceImpl
implements DynamicLayoutBoardService {
    private static final Logger log = LoggerFactory.getLogger(DynamicLayoutBoardServiceImpl.class);
    @Autowired
    private AgileDataBestShowRuleService agileDataBestShowRuleService;
    @Autowired
    private ThemeAgileDataService themeAgileDataService;
    @Autowired
    private AdtService adtService;
    @Autowired
    private AgileReportService agileReportService;
    @Autowired
    private AgileDataPageDefineThemeMapService agileDataPageDefineThemeMapService;
    @Autowired
    private MessageUtils messageUtils;
    @Autowired
    private EchoAiBoardService echoAiBoardService;
    @Autowired
    private ScrumBIService scrumBIService;
    @Autowired
    @Qualifier(value="mongoAgileDataPageViewTemplate")
    private MongoTemplate mongoAgileDataPageViewTemplate;
    private static final String BOARD_LAYOUT_NAME = "agileData_board_layout";
    private static final int DEFAULT_LAYOUT_COLS = 12;

    public List<GridGroupDTO> calcDynamicLayoutBoard(AuthoredUser user, BordDynamicDTO board, String local) {
        ThemeMapBoardDTO themeMapBoardDTO = this.themeAgileDataService.getThemeMapBoard(board.getBoardId());
        if (themeMapBoardDTO == null) {
            throw BusinessException.create((String)ErrorCodeEnum.BOARD_NO_DATA.getErrCode(), (String)this.messageUtils.getMessage("board.no.data"));
        }
        if (CollectionUtils.isEmpty((Collection)themeMapBoardDTO.getDataBoardQuestions())) {
            throw BusinessException.create((String)ErrorCodeEnum.BOARD_NO_DATA.getErrCode(), (String)this.messageUtils.getMessage("board.no.data"));
        }
        BoardLayoutMongoData userDefineLayout = this.getDynamicLayoutBoard(user, board.getBoardId());
        String entry = themeMapBoardDTO.getDataEntry();
        if (StringUtils.equals((String)"aiBoard", (String)entry)) {
            log.info("\u5f00\u59cb\u6784\u5efa\u770b\u677f\u5e03\u5c40\u4fe1\u606f\uff0c{}", (Object)board.getBoardId());
            return this.getAILayout(user, local, themeMapBoardDTO, userDefineLayout);
        }
        if (userDefineLayout != null) {
            HashMap orderMap = Maps.newHashMap();
            for (int i = 0; i < userDefineLayout.getBoardLayout().size(); ++i) {
                orderMap.put(((GridGroupDTO)userDefineLayout.getBoardLayout().get(i)).getId(), i);
            }
            HashMap originalIndexMap = Maps.newHashMap();
            for (int i = 0; i < themeMapBoardDTO.getDataBoardQuestions().size(); ++i) {
                originalIndexMap.put(themeMapBoardDTO.getDataBoardQuestions().get(i), i);
            }
            List dataBoardQuestions = themeMapBoardDTO.getDataBoardQuestions().stream().sorted(Comparator.comparingInt(item -> orderMap.containsKey(item.getQuestionId()) ? 0 : 1).thenComparing(Comparator.comparingInt(item -> orderMap.getOrDefault(item.getQuestionId(), Integer.MAX_VALUE)).thenComparing(item -> (Integer)originalIndexMap.get(item)))).collect(Collectors.toList());
            themeMapBoardDTO.setDataBoardQuestions(dataBoardQuestions);
        }
        ArrayList abstractComponents = Lists.newArrayList();
        themeMapBoardDTO.getDataBoardQuestions().stream().forEach(question -> {
            if (question.getShowType() == null) {
                question.setShowType(Integer.valueOf(0));
            }
            switch (question.getShowType()) {
                case 2: {
                    SnapDataDTO snapDataDTO = this.adtService.transAgileData(String.valueOf(question.getShowType()), question.getSnapshotId(), local);
                    AgileDataIndexComponent agileDataIndexComponent = this.getIndexComponent(question.getQuestionId(), snapDataDTO, local);
                    if (agileDataIndexComponent != null) {
                        abstractComponents.add(agileDataIndexComponent);
                        break;
                    }
                    abstractComponents.add(this.getEmptyIndexComponent(question.getQuestionId()));
                    break;
                }
                case 3: 
                case 4: 
                case 5: 
                case 6: {
                    abstractComponents.add(AgileDataBoardComponentBuild.buildBoardEcharts((String)question.getQuestionId()));
                    break;
                }
                default: {
                    abstractComponents.add(AgileDataBoardComponentBuild.buildBoardGrid((String)question.getQuestionId()));
                }
            }
        });
        List items = userDefineLayout != null ? ConvertAgileDataRelation.createUserDefineBoardItems((List)abstractComponents, (BoardLayoutMongoData)userDefineLayout) : ConvertAgileDataRelation.createBoardItems((List)abstractComponents, (BoardLayoutMongoData)userDefineLayout);
        return items;
    }

    private List<GridGroupDTO> getAILayout(AuthoredUser authoredUser, String local, ThemeMapBoardDTO themeMapBoardDTO, BoardLayoutMongoData userDefineLayout) {
        List items = Lists.newArrayList();
        if (themeMapBoardDTO.getMessageId() == null) {
            return items;
        }
        AIBoardQueryReq aiBoardQueryReq = new AIBoardQueryReq();
        aiBoardQueryReq.setMessageId(themeMapBoardDTO.getMessageId());
        EchoAIBoardDTO echoAIBoardDTO = this.echoAiBoardService.queryAgileDataAIBoard(authoredUser, aiBoardQueryReq);
        if (echoAIBoardDTO == null) {
            return items;
        }
        this.getAnalyzeResult(echoAIBoardDTO);
        AIBoardLayout aiBoardLayout = echoAIBoardDTO.getBoardLayout();
        if (aiBoardLayout == null) {
            List layoutDTOList = this.scrumBIService.getAIBoardLayout(authoredUser, ScrumBILayoutReq.buildScrumBILayoutReq((EchoAIBoardDTO)echoAIBoardDTO), local);
            log.info("layoutDTOList:{}", (Object)JSONUtil.toJsonStr((Object)layoutDTOList));
            if (CollectionUtils.isEmpty((Collection)layoutDTOList)) {
                return items;
            }
            boolean hasLightFields = (aiBoardLayout = BoardLayoutPlanner.getAiBoardLayout((List)layoutDTOList, (EchoAIBoardDTO)echoAIBoardDTO, (AIBoardLayout)aiBoardLayout)).getCharts().stream().anyMatch(c -> c.getImportance() != null || c.getRow() != null);
            if (hasLightFields) {
                int layoutCols = aiBoardLayout.getOverallLayout() != null && aiBoardLayout.getOverallLayout().getLayoutCols() != null ? aiBoardLayout.getOverallLayout().getLayoutCols() : 12;
                int layoutRows = aiBoardLayout.getOverallLayout() != null && aiBoardLayout.getOverallLayout().getLayoutRows() != null ? aiBoardLayout.getOverallLayout().getLayoutRows() : 18;
                List seeds = BoardLayoutPlanner.getSeedList((AIBoardLayout)aiBoardLayout, (EchoAIBoardDTO)echoAIBoardDTO);
                if (!seeds.isEmpty()) {
                    AIBoardLayout planned = BoardLayoutPlanner.plan((List)seeds, (int)layoutCols, (int)layoutRows);
                    log.info("seeds:{}", (Object)JSONUtil.toJsonStr((Object)seeds));
                    log.info("planned:{}", (Object)JSONUtil.toJsonStr((Object)planned));
                    EchoAIBoardDTO updateAIBoardDTO = new EchoAIBoardDTO();
                    updateAIBoardDTO.setMessageId(themeMapBoardDTO.getMessageId());
                    updateAIBoardDTO.setBoardLayout(planned);
                    this.echoAiBoardService.updateAgileDataAIBoard(authoredUser, updateAIBoardDTO);
                    echoAIBoardDTO.setBoardLayout(planned);
                    aiBoardLayout = planned;
                }
            }
        } else {
            List newQuestions = this.resolveNewQuestions(themeMapBoardDTO, userDefineLayout, aiBoardLayout);
            if (CollectionUtils.isNotEmpty((Collection)newQuestions)) {
                boolean userLayoutUpdated = this.updateUserDefineLayout(authoredUser, themeMapBoardDTO, userDefineLayout, aiBoardLayout, newQuestions, echoAIBoardDTO);
                if (userLayoutUpdated) {
                    this.persistUserLayout(authoredUser, themeMapBoardDTO.getBoardId(), userDefineLayout);
                } else {
                    boolean boardLayoutUpdated = this.updateBoardLayout(themeMapBoardDTO, echoAIBoardDTO, aiBoardLayout, newQuestions);
                    if (boardLayoutUpdated) {
                        EchoAIBoardDTO updateAIBoardDTO = new EchoAIBoardDTO();
                        updateAIBoardDTO.setMessageId(themeMapBoardDTO.getMessageId());
                        updateAIBoardDTO.setBoardLayout(aiBoardLayout);
                        this.echoAiBoardService.updateAgileDataAIBoard(authoredUser, updateAIBoardDTO);
                    }
                }
            }
        }
        items = ConvertAgileDataRelation.createAIUserDefineLayout((ThemeMapBoardDTO)themeMapBoardDTO, (AIBoardLayout)aiBoardLayout, (BoardLayoutMongoData)userDefineLayout);
        return items;
    }

    private List<ThemeMapBoardDTO.DataBoardQuestion> resolveNewQuestions(ThemeMapBoardDTO themeMapBoardDTO, BoardLayoutMongoData userDefineLayout, AIBoardLayout aiBoardLayout) {
        if (themeMapBoardDTO == null || CollectionUtils.isEmpty((Collection)themeMapBoardDTO.getDataBoardQuestions())) {
            return Lists.newArrayList();
        }
        HashSet existedIds = Sets.newHashSet();
        if (userDefineLayout != null && CollectionUtils.isNotEmpty((Collection)userDefineLayout.getBoardLayout())) {
            userDefineLayout.getBoardLayout().forEach(item -> {
                if (item == null) {
                    return;
                }
                String id = item.getId();
                if (StringUtils.isNotBlank((String)id)) {
                    existedIds.add(id);
                }
            });
        }
        if (CollectionUtils.isEmpty((Collection)existedIds) && aiBoardLayout != null && CollectionUtils.isNotEmpty((Collection)aiBoardLayout.getCharts())) {
            aiBoardLayout.getCharts().forEach(chart -> {
                if (chart == null) {
                    return;
                }
                String chartId = chart.getChartId();
                if (StringUtils.isNotBlank((String)chartId)) {
                    existedIds.add(chartId);
                }
            });
        }
        if (CollectionUtils.isEmpty((Collection)existedIds)) {
            return Lists.newArrayList((Iterable)themeMapBoardDTO.getDataBoardQuestions());
        }
        return themeMapBoardDTO.getDataBoardQuestions().stream().filter(question -> {
            String questionId = question.getQuestionId();
            if (StringUtils.isNotBlank((String)questionId) && existedIds.contains(questionId)) {
                return false;
            }
            String resolvedId = this.resolveBoardChartId(question);
            return !StringUtils.isNotBlank((String)resolvedId) || !existedIds.contains(resolvedId);
        }).collect(Collectors.toList());
    }

    private boolean updateUserDefineLayout(AuthoredUser authoredUser, ThemeMapBoardDTO themeMapBoardDTO, BoardLayoutMongoData userDefineLayout, AIBoardLayout aiBoardLayout, List<ThemeMapBoardDTO.DataBoardQuestion> newQuestions, EchoAIBoardDTO echoAIBoardDTO) {
        if (userDefineLayout == null) {
            return false;
        }
        List layout = userDefineLayout.getBoardLayout();
        if (layout == null) {
            layout = Lists.newArrayList();
            userDefineLayout.setBoardLayout(layout);
        }
        boolean updated = this.removeInvalidUserLayoutItems(layout, themeMapBoardDTO);
        int nextRowStart = this.calculateNextRowStart(layout);
        for (ThemeMapBoardDTO.DataBoardQuestion question : newQuestions) {
            if (layout.stream().anyMatch(item -> StringUtils.equals((String)item.getId(), (String)question.getQuestionId()))) continue;
            String showType = this.resolveChartShowType(question, echoAIBoardDTO);
            LayoutSize layoutSize = this.resolveLayoutSize(showType, question.getSnapshotId());
            GridGroupDTO gridGroupDTO = this.buildUserLayoutGroup(question, showType, nextRowStart, layoutSize);
            layout.add(gridGroupDTO);
            nextRowStart += layoutSize.getRows();
            updated = true;
        }
        return updated;
    }

    private boolean updateBoardLayout(ThemeMapBoardDTO themeMapBoardDTO, EchoAIBoardDTO echoAIBoardDTO, AIBoardLayout aiBoardLayout, List<ThemeMapBoardDTO.DataBoardQuestion> newQuestions) {
        if (aiBoardLayout == null) {
            return false;
        }
        List charts = aiBoardLayout.getCharts();
        if (charts == null) {
            charts = Lists.newArrayList();
            aiBoardLayout.setCharts(charts);
        }
        boolean updated = this.removeInvalidBoardCharts(aiBoardLayout, themeMapBoardDTO);
        int nextRowStart = this.calculateNextRowStart(aiBoardLayout);
        for (ThemeMapBoardDTO.DataBoardQuestion question : newQuestions) {
            if (question == null) continue;
            String matchedChartId = this.resolveBoardChartId(question);
            if (charts.stream().anyMatch(chart -> StringUtils.equals((String)chart.getChartId(), (String)matchedChartId))) continue;
            String showType = this.resolveChartShowType(question, echoAIBoardDTO);
            LayoutSize layoutSize = this.resolveLayoutSize(showType, question.getSnapshotId());
            AIBoardLayout.layoutArea layoutArea2 = this.buildLayoutArea(themeMapBoardDTO, echoAIBoardDTO, question, matchedChartId, showType, nextRowStart, layoutSize);
            charts.add(layoutArea2);
            nextRowStart += layoutSize.getRows();
            updated = true;
        }
        if (updated) {
            aiBoardLayout.getOverallLayout().setLayoutRows(Integer.valueOf(nextRowStart));
        }
        return updated;
    }

    private boolean removeInvalidUserLayoutItems(List<GridGroupDTO> layout, ThemeMapBoardDTO themeMapBoardDTO) {
        if (CollectionUtils.isEmpty(layout)) {
            return false;
        }
        if (themeMapBoardDTO == null || CollectionUtils.isEmpty((Collection)themeMapBoardDTO.getDataBoardQuestions())) {
            return false;
        }
        Set validQuestionIds = themeMapBoardDTO.getDataBoardQuestions().stream().map(ThemeMapBoardDTO.DataBoardQuestion::getQuestionId).filter(StringUtils::isNotBlank).collect(Collectors.toSet());
        if (validQuestionIds.isEmpty()) {
            return false;
        }
        return layout.removeIf(item -> item == null || StringUtils.isBlank((String)item.getId()) || !validQuestionIds.contains(item.getId()));
    }

    private boolean removeInvalidBoardCharts(AIBoardLayout aiBoardLayout, ThemeMapBoardDTO themeMapBoardDTO) {
        if (aiBoardLayout == null || CollectionUtils.isEmpty((Collection)aiBoardLayout.getCharts())) {
            return false;
        }
        if (themeMapBoardDTO == null || CollectionUtils.isEmpty((Collection)themeMapBoardDTO.getDataBoardQuestions())) {
            return false;
        }
        Set validChartIds = themeMapBoardDTO.getDataBoardQuestions().stream().map(arg_0 -> this.resolveBoardChartId(arg_0)).filter(StringUtils::isNotBlank).collect(Collectors.toSet());
        if (validChartIds.isEmpty()) {
            return false;
        }
        return aiBoardLayout.getCharts().removeIf(chart -> chart == null || StringUtils.isBlank((String)chart.getChartId()) || !validChartIds.contains(chart.getChartId()));
    }

    private void persistUserLayout(AuthoredUser authoredUser, String boardId, BoardLayoutMongoData userDefineLayout) {
        if (userDefineLayout == null || CollectionUtils.isEmpty((Collection)userDefineLayout.getBoardLayout())) {
            return;
        }
        Query query = Query.query((CriteriaDefinition)Criteria.where((String)"userId").is((Object)authoredUser.getUserId()).and("tenantId").is((Object)authoredUser.getTenantId()).and("boardId").is((Object)boardId));
        Update update = new Update();
        update.set("boardLayout", (Object)userDefineLayout.getBoardLayout());
        this.mongoAgileDataPageViewTemplate.upsert(query, (UpdateDefinition)update, BoardLayoutMongoData.class, "agileData_board_layout");
    }

    private GridGroupDTO buildUserLayoutGroup(ThemeMapBoardDTO.DataBoardQuestion question, String showType, int rowStart, LayoutSize layoutSize) {
        GridGroupDTO gridGroupDTO = new GridGroupDTO();
        gridGroupDTO.setId(question.getQuestionId());
        gridGroupDTO.setType(showType);
        gridGroupDTO.setX(Integer.valueOf(0));
        gridGroupDTO.setY(Integer.valueOf(rowStart));
        gridGroupDTO.setCols(Integer.valueOf(layoutSize.getCols()));
        gridGroupDTO.setRows(Integer.valueOf(layoutSize.getRows()));
        return gridGroupDTO;
    }

    private AIBoardLayout.layoutArea buildLayoutArea(ThemeMapBoardDTO themeMapBoardDTO, EchoAIBoardDTO echoAIBoardDTO, ThemeMapBoardDTO.DataBoardQuestion question, String chartId, String showType, int rowStart, LayoutSize layoutSize) {
        AIBoardLayout.layoutArea layoutArea2 = new AIBoardLayout.layoutArea();
        layoutArea2.setChartId(chartId);
        layoutArea2.setShowType(showType);
        layoutArea2.setTitle(this.resolveChartTitle(themeMapBoardDTO, question, echoAIBoardDTO));
        AIBoardLayout.layoutDimensions dimensions = new AIBoardLayout.layoutDimensions();
        dimensions.setAreaCols(Integer.valueOf(layoutSize.getCols()));
        dimensions.setAreaRow(Integer.valueOf(layoutSize.getRows()));
        layoutArea2.setDimensions(dimensions);
        AIBoardLayout.layoutPosition position = new AIBoardLayout.layoutPosition();
        AIBoardLayout.layoutIndex colIndex = new AIBoardLayout.layoutIndex();
        colIndex.setStart(Integer.valueOf(0));
        colIndex.setEnd(Integer.valueOf(layoutSize.getCols()));
        position.setLayoutCol(colIndex);
        AIBoardLayout.layoutIndex rowIndex = new AIBoardLayout.layoutIndex();
        rowIndex.setStart(Integer.valueOf(rowStart));
        rowIndex.setEnd(Integer.valueOf(rowStart + layoutSize.getRows()));
        position.setLayoutRow(rowIndex);
        layoutArea2.setPosition(position);
        return layoutArea2;
    }

    private String resolveChartShowType(ThemeMapBoardDTO.DataBoardQuestion question, EchoAIBoardDTO echoAIBoardDTO) {
        if (echoAIBoardDTO != null && CollectionUtils.isNotEmpty((Collection)echoAIBoardDTO.getQuestionInfo())) {
            for (AIBoardQuestionDTO questionInfo : echoAIBoardDTO.getQuestionInfo()) {
                if (!StringUtils.equals((String)String.valueOf(questionInfo.getQuestionId()), (String)question.getQuestionId()) || !StringUtils.isNotBlank((String)questionInfo.getShowType())) continue;
                return questionInfo.getShowType();
            }
        }
        return question.getShowType() == null ? null : String.valueOf(question.getShowType());
    }

    private String resolveChartTitle(ThemeMapBoardDTO themeMapBoardDTO, ThemeMapBoardDTO.DataBoardQuestion question, EchoAIBoardDTO echoAIBoardDTO) {
        if (echoAIBoardDTO != null && CollectionUtils.isNotEmpty((Collection)echoAIBoardDTO.getQuestionInfo())) {
            for (AIBoardQuestionDTO questionInfo : echoAIBoardDTO.getQuestionInfo()) {
                if (!StringUtils.equals((String)String.valueOf(questionInfo.getQuestionId()), (String)question.getQuestionId()) || !StringUtils.isNotBlank((String)questionInfo.getChartTitle())) continue;
                return questionInfo.getChartTitle();
            }
        }
        if (themeMapBoardDTO != null && CollectionUtils.isNotEmpty((Collection)themeMapBoardDTO.getDataBoardQuestions())) {
            return question.getQuestion();
        }
        return null;
    }

    private int calculateNextRowStart(List<GridGroupDTO> layout) {
        if (CollectionUtils.isEmpty(layout)) {
            return 0;
        }
        return layout.stream().mapToInt(item -> (item.getY() == null ? 0 : item.getY()) + (item.getRows() == null ? 0 : item.getRows())).max().orElse(0);
    }

    private int calculateNextRowStart(AIBoardLayout aiBoardLayout) {
        if (aiBoardLayout == null || CollectionUtils.isEmpty((Collection)aiBoardLayout.getCharts())) {
            return 0;
        }
        return aiBoardLayout.getCharts().stream().mapToInt(chart -> {
            AIBoardLayout.layoutPosition position = chart.getPosition();
            Integer rowStart = null;
            Integer rowEnd = null;
            if (position != null && position.getLayoutRow() != null) {
                rowStart = position.getLayoutRow().getStart();
                rowEnd = position.getLayoutRow().getEnd();
            }
            if (rowEnd != null) {
                return rowStart + chart.getDimensions().getAreaRow();
            }
            int start = rowStart == null ? 0 : rowStart;
            return start + this.extractRowHeight(chart, null);
        }).max().orElse(0);
    }

    private int extractRowHeight(AIBoardLayout.layoutArea chart, String snapshotId) {
        Integer areaRow;
        if (chart == null) {
            return 0;
        }
        Integer n = areaRow = chart.getDimensions() == null ? null : chart.getDimensions().getAreaRow();
        if (areaRow != null && areaRow > 0) {
            return areaRow;
        }
        if (chart.getPosition() != null && chart.getPosition().getLayoutRow() != null) {
            AIBoardLayout.layoutIndex row = chart.getPosition().getLayoutRow();
            Integer start = row.getStart();
            Integer end = row.getEnd();
            if (end != null) {
                if (start != null) {
                    return Math.max(0, end - start);
                }
                return end;
            }
        }
        LayoutSize layoutSize = this.resolveLayoutSize(chart.getShowType(), null);
        return layoutSize.getRows();
    }

    private LayoutSize resolveLayoutSize(String showType, String snapshotId) {
        if (StringUtils.equals((String)"2", (String)showType)) {
            if (StringUtils.isEmpty((String)snapshotId)) {
                return LayoutSize.of((int)2, (int)2);
            }
            SnapDataDTO snapDataDTO = this.adtService.transAgileData(String.valueOf(showType), snapshotId, "zh_CN");
            AgileDataIndexComponent agileDataIndexComponent = this.getIndexComponent(snapshotId, snapDataDTO, "zh_CN");
            if (agileDataIndexComponent != null && CollectionUtils.isNotEmpty((Collection)agileDataIndexComponent.getGroup())) {
                int size = agileDataIndexComponent.getGroup().size() * 2;
                int rows = (size + 12 - 1) / 12;
                if (rows > 1) {
                    size = 12;
                }
                return LayoutSize.of((int)size, (int)(rows * 2));
            }
            return LayoutSize.of((int)2, (int)2);
        }
        if (StringUtils.equals((String)"0", (String)showType)) {
            return LayoutSize.of((int)12, (int)6);
        }
        return LayoutSize.of((int)6, (int)6);
    }

    private int ensureLayoutCols(AIBoardLayout aiBoardLayout) {
        Integer layoutCols;
        if (aiBoardLayout.getOverallLayout() == null) {
            AIBoardLayout.layoutAll layoutAll2 = new AIBoardLayout.layoutAll();
            layoutAll2.setLayoutCols(Integer.valueOf(12));
            layoutAll2.setLayoutRows(Integer.valueOf(0));
            aiBoardLayout.setOverallLayout(layoutAll2);
        }
        if ((layoutCols = aiBoardLayout.getOverallLayout().getLayoutCols()) == null || layoutCols < 12) {
            aiBoardLayout.getOverallLayout().setLayoutCols(Integer.valueOf(12));
            return 12;
        }
        return layoutCols;
    }

    private String resolveBoardChartId(ThemeMapBoardDTO.DataBoardQuestion question) {
        Object chartId;
        if (question == null) {
            return null;
        }
        Map dataParam = question.getDataParam();
        if (MapUtils.isNotEmpty((Map)dataParam) && (chartId = dataParam.get("questionId")) != null) {
            return String.valueOf(chartId);
        }
        return question.getQuestionId();
    }

    private void getAnalyzeResult(EchoAIBoardDTO echoAIBoardDTO) {
        List filteredQuestions = echoAIBoardDTO.getQuestionInfo().stream().filter(question -> question.getAnalyzeStatus() != null && question.getAnalyzeStatus() == 0).collect(Collectors.toList());
        echoAIBoardDTO.setQuestionInfo(filteredQuestions);
    }

    private AgileDataIndexComponent getIndexComponent(String questionId, SnapDataDTO snapDataDTO, String local) {
        if (snapDataDTO == null) {
            return null;
        }
        String actionId = (String)snapDataDTO.getPageData().keySet().iterator().next();
        ExecuteContext executeContext = new ExecuteContext();
        executeContext.setLocale(local);
        ApiMetadata apiMetadata = this.agileDataPageDefineThemeMapService.getApiMetadata(snapDataDTO, executeContext, actionId);
        return AgileDataBoardComponentBuild.buildBoardIndex((String)questionId, (MetadataField)ConvertGetAgileData.getRootMetadataField((ApiMetadata)apiMetadata));
    }

    private AgileDataIndexComponent getEmptyIndexComponent(String questionId) {
        AgileDataIndexComponent agileDataIndexComponent = new AgileDataIndexComponent();
        agileDataIndexComponent.setType("STATISTIC");
        ArrayList group = Lists.newArrayList();
        group.add(new AgileDataIndexComponent.AgileDataIndex());
        agileDataIndexComponent.setGroup((List)group);
        agileDataIndexComponent.setId(questionId);
        return agileDataIndexComponent;
    }

    public Map<String, Object> generateBoardLayout(AuthoredUser user, BoardLayoutParamsDTO boardLayoutParamsDTO, String local) {
        HashMap result = Maps.newHashMap();
        BoardSnapResultDTO boardData = this.adtService.getBoardData(boardLayoutParamsDTO, local);
        if (boardData.getSnapShotDTO() == null) {
            result.put("result", false);
            result.put("msg", boardData.getMsg());
            result.put("title", boardData.getTitle());
            return result;
        }
        String snapshotId = boardData.getSnapShotDTO().getSnapshotId();
        ExecuteContext executeContext = ExecuteContext.createByHttpRequest();
        SnapDataDTO agileReportDTO = this.adtService.getAdtReportBySnapshotId(snapshotId, executeContext.getLocale());
        this.getDefineTitle(boardData.getSnapShotDTO(), executeContext);
        if (AgileDataCheck.sceneBasicCheck((SnapDataDTO)agileReportDTO).booleanValue()) {
            result.put("result", false);
            result.put("title", executeContext.getDefineTitle());
            result.put("msg", MessageUtils.getMessageByCurrentLanguage((Object)EchoShowConstants.getLanMap((String)"\u67e5\u8be2\u7ed3\u679c\u4e3a\u7a7a\uff0c\u8bf7\u786e\u8ba4\u67e5\u8be2\u6761\u4ef6\u662f\u5426\u6b63\u786e\u3002", (String)"\u67e5\u8a62\u7d50\u679c\u70ba\u7a7a\uff0c\u8acb\u78ba\u8a8d\u67e5\u8a62\u689d\u4ef6\u662f\u5426\u6b63\u78ba\u3002", (String)"no data")));
            return result;
        }
        executeContext.appendAgileDataPageInfo("agiledata-page", agileReportDTO, null, "0");
        DynamicAgileData dynamicAgileData = this.agileReportService.createAgileReportTemplateTable(executeContext, agileReportDTO);
        result.put("dsl", dynamicAgileData);
        if (dynamicAgileData != null) {
            result.put("result", true);
        } else {
            result.put("result", false);
        }
        Object dataTipMessage = boardData.getSnapShotDTO().getContext().getBizParams().get("dataTipMessage");
        if (dataTipMessage != null) {
            result.put("dataTipMessage", dynamicAgileData);
        }
        return result;
    }

    private void getDefineTitle(SnapShotInfo boardInfo, ExecuteContext executeContext) {
        if (boardInfo == null) {
            return;
        }
        SnapShotInfo.SnapShotInfoContext context = boardInfo.getContext();
        if (context == null) {
            return;
        }
        Map bizParams = context.getBizParams();
        if (MapUtils.isEmpty((Map)bizParams)) {
            return;
        }
        Map showDefine = MapUtils.getMap((Map)bizParams, (Object)"showDefine");
        if (MapUtils.isEmpty((Map)showDefine)) {
            return;
        }
        List showType = (List)MapUtils.getObject((Map)showDefine, (Object)"showType");
        if (CollectionUtils.isEmpty((Collection)showType)) {
            return;
        }
        AtomicReference<String> title = new AtomicReference<String>("");
        showType.stream().forEach(showTypeDTO -> {
            List typeList = (List)MapUtils.getObject((Map)showTypeDTO, (Object)"type");
            if (CollectionUtils.isNotEmpty((Collection)typeList)) {
                typeList.stream().forEach(type -> title.set(MapUtils.getString((Map)type, (Object)"title")));
            }
        });
        executeContext.setDefineTitle(title.get());
    }

    public Boolean saveDynamicLayoutBoard(AuthoredUser authoredUser, BoardLayoutDTO boardLayoutDTO) {
        if (CollectionUtils.isNotEmpty((Collection)boardLayoutDTO.getBoardLayout())) {
            Query query = Query.query((CriteriaDefinition)Criteria.where((String)"userId").is((Object)authoredUser.getUserId()).and("tenantId").is((Object)authoredUser.getTenantId()).and("boardId").is((Object)boardLayoutDTO.getBoardId()));
            BoardLayoutMongoData boardLayoutMongoData = (BoardLayoutMongoData)this.mongoAgileDataPageViewTemplate.findOne(query, BoardLayoutMongoData.class, "agileData_board_layout");
            if (boardLayoutMongoData == null) {
                boardLayoutMongoData = new BoardLayoutMongoData();
                boardLayoutMongoData.setBoardLayout(boardLayoutDTO.getBoardLayout());
                boardLayoutMongoData.setBoardId(boardLayoutDTO.getBoardId());
                boardLayoutMongoData.setUserId(authoredUser.getUserId());
                boardLayoutMongoData.setTenantId(authoredUser.getTenantId());
                this.mongoAgileDataPageViewTemplate.insert((Object)boardLayoutMongoData, "agileData_board_layout");
            } else {
                Update update = new Update();
                update.set("boardLayout", (Object)boardLayoutDTO.getBoardLayout());
                this.mongoAgileDataPageViewTemplate.upsert(query, (UpdateDefinition)update, AgileDataUserDefine.class, "agileData_board_layout");
            }
        }
        return true;
    }

    public BoardLayoutMongoData getDynamicLayoutBoard(AuthoredUser authoredUser, String boardId) {
        Query query = Query.query((CriteriaDefinition)Criteria.where((String)"userId").is((Object)authoredUser.getUserId()).and("tenantId").is((Object)authoredUser.getTenantId()).and("boardId").is((Object)boardId));
        return (BoardLayoutMongoData)this.mongoAgileDataPageViewTemplate.findOne(query, BoardLayoutMongoData.class, "agileData_board_layout");
    }
}

