/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.athena.show.service.ppt.impl;

import com.digiwin.athena.appcore.auth.domain.AuthoredUser;
import com.digiwin.athena.appcore.util.JsonUtils;
import com.digiwin.athena.show.domain.ppt.AgileDataFileDTO;
import com.digiwin.athena.show.domain.ppt.AgileDataFileQueryReq;
import com.digiwin.athena.show.service.ppt.AgileDataFileManagerService;
import com.google.common.collect.Maps;
import com.mongodb.BasicDBObject;
import java.time.LocalTime;
import java.util.Collection;
import java.util.HashMap;
import java.util.Objects;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.data.mongodb.core.MongoTemplate;
import org.springframework.data.mongodb.core.query.Criteria;
import org.springframework.data.mongodb.core.query.CriteriaDefinition;
import org.springframework.data.mongodb.core.query.Query;
import org.springframework.data.mongodb.core.query.Update;
import org.springframework.data.mongodb.core.query.UpdateDefinition;
import org.springframework.stereotype.Service;

@Service
public class AgileDataFileManagerServiceImpl
implements AgileDataFileManagerService {
    private static final Logger log = LoggerFactory.getLogger(AgileDataFileManagerServiceImpl.class);
    @Autowired
    @Qualifier(value="mongoAgileDataPageViewTemplate")
    private MongoTemplate mongoAgileDataPageViewTemplate;
    private static final String MONGODB_COLLECTION_NAME = "agile_data_file_analyze";

    public AgileDataFileDTO queryAgileDataFile(AuthoredUser user, AgileDataFileQueryReq agileDataFileQueryReq) {
        if (agileDataFileQueryReq == null) {
            return null;
        }
        if (agileDataFileQueryReq.getMessageId() == null) {
            return null;
        }
        Query query = Query.query((CriteriaDefinition)Criteria.where((String)"userId").is((Object)user.getUserId()).and("tenantId").is((Object)user.getTenantId()).and("messageId").is((Object)agileDataFileQueryReq.getMessageId()));
        AgileDataFileDTO agileDataFileDTO = (AgileDataFileDTO)this.mongoAgileDataPageViewTemplate.findOne(query, AgileDataFileDTO.class, MONGODB_COLLECTION_NAME);
        if (agileDataFileDTO == null) {
            return null;
        }
        if (CollectionUtils.isNotEmpty((Collection)agileDataFileQueryReq.getQuestionIds()) && CollectionUtils.isNotEmpty((Collection)agileDataFileDTO.getQuestionInfo())) {
            agileDataFileDTO.getQuestionInfo().removeIf(questionInfo -> !agileDataFileQueryReq.getQuestionIds().contains(questionInfo.getQuestionId()));
        }
        return agileDataFileDTO;
    }

    public Boolean saveAgileDataFile(AuthoredUser user, AgileDataFileDTO agileDataFileDTO) {
        if (agileDataFileDTO == null) {
            return false;
        }
        agileDataFileDTO.setTenantId(user.getTenantId());
        agileDataFileDTO.setUserId(user.getUserId());
        agileDataFileDTO.setCreateTime(LocalTime.now());
        this.mongoAgileDataPageViewTemplate.insert((Object)agileDataFileDTO, MONGODB_COLLECTION_NAME);
        return true;
    }

    public Boolean updateAgileDataFile(AuthoredUser user, AgileDataFileDTO agileDataFileDTO) {
        if (agileDataFileDTO == null) {
            return false;
        }
        agileDataFileDTO.setTenantId(user.getTenantId());
        agileDataFileDTO.setUserId(user.getUserId());
        if (CollectionUtils.isNotEmpty((Collection)agileDataFileDTO.getQuestionInfo())) {
            agileDataFileDTO.getQuestionInfo().stream().forEach(questionInfo -> {
                Query query = new Query((CriteriaDefinition)Criteria.where((String)"messageId").is((Object)agileDataFileDTO.getMessageId()).and("tenantId").is((Object)user.getTenantId()).and("questionInfo.questionId").is((Object)questionInfo.getQuestionId()).and("userId").is((Object)user.getUserId()));
                Update update = new Update();
                if (agileDataFileDTO.getMessageStatus() != null) {
                    update.set("messageStatus", (Object)agileDataFileDTO.getMessageStatus());
                }
                if (questionInfo.getLock() != null) {
                    update.set("questionInfo.$.lock", (Object)questionInfo.getLock());
                }
                if (StringUtils.isNotEmpty((String)questionInfo.getQuestion())) {
                    log.info("\u66f4\u65b0PPT\u95ee\u53e5\u4fe1\u606f\uff0c{}", (Object)JsonUtils.objectToString((Object)agileDataFileDTO));
                    update.set("questionInfo.$.question", (Object)questionInfo.getQuestion());
                    update.set("questionInfo.$.title", null);
                    update.set("questionInfo.$.datasetIds", null);
                }
                if (questionInfo.getAnalyzeStatus() != null) {
                    update.set("questionInfo.$.analyzeStatus", (Object)questionInfo.getAnalyzeStatus());
                }
                if (questionInfo.getAnalyzeResult() != null) {
                    update.set("questionInfo.$.analyzeResult", (Object)questionInfo.getAnalyzeResult());
                }
                if (StringUtils.isNotEmpty((String)questionInfo.getSnapshotId())) {
                    update.set("questionInfo.$.snapshotId", (Object)questionInfo.getSnapshotId());
                }
                if (StringUtils.isNotEmpty((String)questionInfo.getSummarizeData())) {
                    update.set("questionInfo.$.summarizeData", (Object)questionInfo.getSummarizeData());
                }
                if (Objects.nonNull(questionInfo.getAnalyzeMessageId())) {
                    update.set("questionInfo.$.analyzeMessageId", (Object)questionInfo.getAnalyzeMessageId());
                }
                update.set("updateTime", (Object)LocalTime.now());
                this.mongoAgileDataPageViewTemplate.updateFirst(query, (UpdateDefinition)update, MONGODB_COLLECTION_NAME);
            });
        } else if (CollectionUtils.isNotEmpty((Collection)agileDataFileDTO.getPptInfo())) {
            agileDataFileDTO.getPptInfo().stream().forEach(pptInfo -> {
                Query query = new Query((CriteriaDefinition)Criteria.where((String)"messageId").is((Object)agileDataFileDTO.getMessageId()).and("tenantId").is((Object)user.getTenantId()).and("userId").is((Object)user.getUserId()).and("pptInfo.pptId").is((Object)pptInfo.getPptId()));
                AgileDataFileDTO agileDataFile = (AgileDataFileDTO)this.mongoAgileDataPageViewTemplate.findOne(query, AgileDataFileDTO.class, MONGODB_COLLECTION_NAME);
                if (agileDataFile != null) {
                    Query updateQuery = new Query((CriteriaDefinition)Criteria.where((String)"messageId").is((Object)agileDataFileDTO.getMessageId()).and("tenantId").is((Object)user.getTenantId()).and("userId").is((Object)user.getUserId()).and("pptInfo.pptId").is((Object)pptInfo.getPptId()));
                    Update update = new Update();
                    if (StringUtils.isNotEmpty((String)pptInfo.getGenerateStatus())) {
                        update.set("pptInfo.$.generateStatus", (Object)pptInfo.getGenerateStatus());
                    }
                    if (StringUtils.isNotEmpty((String)pptInfo.getPptUrl())) {
                        update.set("pptInfo.$.pptUrl", (Object)pptInfo.getPptUrl());
                    }
                    if (StringUtils.isNotEmpty((String)pptInfo.getPptPreviewUrl())) {
                        update.set("pptInfo.$.pptPreviewUrl", (Object)pptInfo.getPptPreviewUrl());
                    }
                    if (StringUtils.isNotEmpty((String)pptInfo.getPptDocId())) {
                        update.set("pptInfo.$.pptDocId", (Object)pptInfo.getPptDocId());
                    }
                    if (StringUtils.isNotEmpty((String)pptInfo.getPptName())) {
                        update.set("pptInfo.$.pptName", (Object)pptInfo.getPptName());
                    }
                    if (StringUtils.isNotEmpty((String)pptInfo.getCreateDate())) {
                        update.set("pptInfo.$.createDate", (Object)pptInfo.getCreateDate());
                    }
                    if (StringUtils.isNotEmpty((String)pptInfo.getExpireDate())) {
                        update.set("pptInfo.$.expireDate", (Object)pptInfo.getExpireDate());
                    }
                    if (StringUtils.isNotEmpty((String)pptInfo.getPptPageSize())) {
                        update.set("pptInfo.$.pptPageSize", (Object)pptInfo.getPptPageSize());
                    }
                    update.set("updateTime", (Object)LocalTime.now());
                    this.mongoAgileDataPageViewTemplate.updateFirst(updateQuery, (UpdateDefinition)update, MONGODB_COLLECTION_NAME);
                } else {
                    Query addQuery = new Query((CriteriaDefinition)Criteria.where((String)"messageId").is((Object)agileDataFileDTO.getMessageId()).and("tenantId").is((Object)user.getTenantId()).and("userId").is((Object)user.getUserId()));
                    HashMap pptMap = Maps.newHashMap();
                    pptMap.put("pptId", pptInfo.getPptId());
                    Update update = new Update().push("pptInfo", (Object)pptMap);
                    update.set("updateTime", (Object)LocalTime.now());
                    this.mongoAgileDataPageViewTemplate.updateFirst(addQuery, (UpdateDefinition)update, MONGODB_COLLECTION_NAME);
                }
            });
        } else {
            Query query = new Query((CriteriaDefinition)Criteria.where((String)"messageId").is((Object)agileDataFileDTO.getMessageId()).and("tenantId").is((Object)user.getTenantId()).and("userId").is((Object)user.getUserId()));
            Update update = new Update();
            if (agileDataFileDTO.getMessageStatus() != null) {
                update.set("messageStatus", (Object)agileDataFileDTO.getMessageStatus());
            }
            update.set("updateTime", (Object)LocalTime.now());
            this.mongoAgileDataPageViewTemplate.updateFirst(query, (UpdateDefinition)update, MONGODB_COLLECTION_NAME);
        }
        return true;
    }

    public Boolean deleteAgileDataFile(AuthoredUser user, AgileDataFileQueryReq agileDataFileQueryReq) {
        if (agileDataFileQueryReq == null) {
            return false;
        }
        Query query = Query.query((CriteriaDefinition)Criteria.where((String)"userId").is((Object)user.getUserId()).and("tenantId").is((Object)user.getTenantId()).and("messageId").is((Object)agileDataFileQueryReq.getMessageId()));
        if (CollectionUtils.isNotEmpty((Collection)agileDataFileQueryReq.getQuestionIds())) {
            BasicDBObject pullCondition = new BasicDBObject("questionId", (Object)new BasicDBObject("$in", (Object)agileDataFileQueryReq.getQuestionIds()));
            Update update = new Update();
            update.pull("questionInfo", (Object)pullCondition);
            this.mongoAgileDataPageViewTemplate.updateFirst(query, (UpdateDefinition)update, MONGODB_COLLECTION_NAME);
        } else {
            this.mongoAgileDataPageViewTemplate.remove(query, MONGODB_COLLECTION_NAME);
        }
        return true;
    }
}

