/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.athena.show.template;

import cn.hutool.core.bean.BeanUtil;
import com.digiwin.athena.agiledataecho.constant.ErrorCodeEnum;
import com.digiwin.athena.agiledataecho.util.MessageUtil;
import com.digiwin.athena.appcore.exception.BusinessException;
import com.digiwin.athena.appcore.util.JsonUtils;
import com.digiwin.athena.appcore.util.SpringUtil;
import com.digiwin.athena.show.assistant.ExecuteContext;
import com.digiwin.athena.show.component.AbstractComponent;
import com.digiwin.athena.show.component.echarts.EchartsComponent;
import com.digiwin.athena.show.component.echarts.EchartsComponentImpl;
import com.digiwin.athena.show.component.grid.GridComponent;
import com.digiwin.athena.show.component.grid.GridComponentImpl;
import com.digiwin.athena.show.component.gridster.GridsterComponent;
import com.digiwin.athena.show.component.gridster.GridsterComponentImpl;
import com.digiwin.athena.show.component.index.AgileDataIndexComponentImpl;
import com.digiwin.athena.show.domain.BuildContext;
import com.digiwin.athena.show.domain.agileDataDTO.AgileDataBestShowRule;
import com.digiwin.athena.show.domain.agileDataDTO.AgileDataMobileGridColumnDef;
import com.digiwin.athena.show.domain.agileDataDTO.AgileDataRelationDTO;
import com.digiwin.athena.show.domain.agileDataDTO.AgileReport;
import com.digiwin.athena.show.domain.agileDataDTO.AgileReportChartTypeEnum;
import com.digiwin.athena.show.domain.agileDataDTO.AgileReportIndex;
import com.digiwin.athena.show.domain.agileDataDTO.AgileReportRuleDTO;
import com.digiwin.athena.show.domain.agileDataDTO.AgileReportRuleInfoDTO;
import com.digiwin.athena.show.domain.agileDataDTO.ConvertAgileDataUtils;
import com.digiwin.athena.show.domain.agileDataDTO.ConvertGetAgileData;
import com.digiwin.athena.show.domain.agileDataDTO.MobileDSLAgileData;
import com.digiwin.athena.show.domain.agileDataDTO.MobileDSLChartAlertShow;
import com.digiwin.athena.show.domain.agileDataDTO.MobileDSLChartGrowth;
import com.digiwin.athena.show.domain.agileDataDTO.MobileDSLChartGrowthField;
import com.digiwin.athena.show.domain.agileDataDTO.MobileDSLChartMeasure;
import com.digiwin.athena.show.domain.agileDataDTO.MobileDSLChartRender;
import com.digiwin.athena.show.domain.agileDataDTO.MobileDSLIndexRender;
import com.digiwin.athena.show.domain.agileDataDTO.MobileDSLTableRender;
import com.digiwin.athena.show.domain.showDefine.DynamicAgileData;
import com.digiwin.athena.show.domain.showDefine.MobileDSLAgileComponent;
import com.digiwin.athena.show.domain.showDefine.ThemeMapReport;
import com.digiwin.athena.show.manager.themeMap.ThemeAgileDataService;
import com.digiwin.athena.show.metadata.ApiMetadata;
import com.digiwin.athena.show.metadata.MetadataField;
import com.digiwin.athena.show.service.AgileDataBusinessProcess;
import com.digiwin.athena.show.service.AgileDataCardInterpreter;
import com.digiwin.athena.show.service.AgileReportRuleService;
import com.digiwin.athena.show.service.ChartBuildBase;
import com.digiwin.athena.show.util.ApiMetadataUtil;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import digiwin.chartsdk.beans.sdk.chart.ChartBase;
import digiwin.chartsdk.beans.sdk.chart.ChartBaseSeries;
import digiwin.chartsdk.beans.sdk.chart.Point;
import digiwin.chartsdk.beans.sdk.chart.Value;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.collections.MapUtils;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public abstract class AgileReportPageTemplate {
    private static final Logger log = LoggerFactory.getLogger(AgileReportPageTemplate.class);
    @Autowired
    private EchartsComponentImpl echartsComponent;
    @Autowired
    private AgileDataIndexComponentImpl agileDataIndexComponentImpl;
    @Autowired
    private GridComponentImpl gridComponent;
    @Autowired
    protected GridsterComponentImpl gridsterComponentImpl;
    @Autowired
    private AgileReportRuleService agileReportRuleService;
    @Autowired
    private MessageUtil messageUtils;
    @Autowired
    private AgileDataBusinessProcess agileDataBusinessProcess;
    @Autowired
    private AgileDataCardInterpreter agileDataCardInterpreter;
    @Autowired
    private ThemeAgileDataService themeAgileDataService;
    private static final List<String> CHART_TYPE = Lists.newArrayList((Object[])new String[]{"line", "bar"});
    private static final List<Integer> MOBILE_WEB_CHART_TYPE = Lists.newArrayList((Object[])new Integer[]{8, 9});

    public String supportKey() {
        return org.apache.commons.lang3.StringUtils.lowerCase((String)"AGILE-REPORT");
    }

    public DynamicAgileData createAgileReport(ExecuteContext executeContext, AgileReport agileReport) {
        try {
            DynamicAgileData dynamicAgileData = new DynamicAgileData();
            if (CollectionUtils.isEmpty((Collection)agileReport.getReport())) {
                return dynamicAgileData;
            }
            log.info("\u751f\u6210\u5448\u73b0\u7ec4\u4ef6\uff1a{}", (Object)JsonUtils.objectToString((Object)agileReport.getReport()));
            List abstractComponents = this.createComponents(agileReport, dynamicAgileData, executeContext);
            dynamicAgileData.setExecuteContext(executeContext);
            log.info("\u751f\u6210\u5448\u73b0\u7ed3\u6784\uff1a{}", (Object)JsonUtils.objectToString((Object)abstractComponents));
            if (org.apache.commons.lang3.StringUtils.equals((CharSequence)"webplatform", (CharSequence)executeContext.getClientAgent())) {
                dynamicAgileData.setLayout((List)Lists.newArrayList((Iterable)abstractComponents));
            } else {
                this.buildMobileDSL(dynamicAgileData, abstractComponents, executeContext, agileReport);
            }
            log.info("\u8f93\u51fa\u5448\u73b0\u7ed3\u6784\uff1a{}", (Object)JsonUtils.objectToString((Object)dynamicAgileData));
            return dynamicAgileData;
        }
        catch (Exception e) {
            log.error("\u5feb\u7167ID\uff1a{},\u5904\u7406\u654f\u6377\u6570\u636e\u5448\u73b0\u5f02\u5e38\uff1a{},{}", new Object[]{executeContext.getAgileData(), e.getMessage(), e.toString()});
            throw BusinessException.create((String)ErrorCodeEnum.AGILE_REPORT_DATA_ERROR.getErrCode(), (String)this.messageUtils.getMessageByLangName("P.UIBOT.800.0004", executeContext.getLocale()));
        }
    }

    protected abstract List<AgileDataBestShowRule> getBestShowRules(ExecuteContext var1);

    protected void createPageDefineTitle(AbstractComponent component, ExecuteContext executeContext, AgileReport agileReport) {
        if (component instanceof GridsterComponent) {
            GridsterComponent gridsterComponent = (GridsterComponent)component;
            if (agileReport != null) {
                agileReport.getReport().stream().forEach(report -> gridsterComponent.setTitle(report.getTitle()));
            }
            gridsterComponent.getItems().stream().forEach(item -> {
                item.setTargetId(item.getId());
                item.setCellOverflow("hidden");
            });
        }
    }

    protected List<AgileDataRelationDTO> getAgileDataRelation(AgileReport agileReport) {
        ThemeMapReport themeMapReport2;
        Optional themeMapReportOptional;
        if (CollectionUtils.isNotEmpty((Collection)agileReport.getReport()) && (themeMapReportOptional = agileReport.getReport().stream().findFirst()).isPresent() && CollectionUtils.isNotEmpty((Collection)(themeMapReport2 = (ThemeMapReport)themeMapReportOptional.get()).getAgileDataRelation())) {
            return themeMapReport2.getAgileDataRelation();
        }
        List actionIds = agileReport.getReport().stream().map(themeMapReport -> themeMapReport.getActionId()).collect(Collectors.toList());
        List agileDataRelationDTOList = this.themeAgileDataService.queryActionRelation(actionIds);
        return agileDataRelationDTOList;
    }

    protected List<AbstractComponent> createComponents(AgileReport agileReport, DynamicAgileData dynamicAgileData, ExecuteContext executeContext) {
        ArrayList abstractComponents = Lists.newArrayList();
        for (ThemeMapReport themeMapReport : agileReport.getReport()) {
            AbstractComponent noneDataComponent;
            if (themeMapReport.getReportShow() == null) {
                themeMapReport.setReportShow(Integer.valueOf(0));
            }
            if ((noneDataComponent = this.createNoneDataComponent(themeMapReport, executeContext, dynamicAgileData)) != null) {
                abstractComponents.add(noneDataComponent);
                continue;
            }
            switch (ConvertAgileDataUtils.transType((Integer)themeMapReport.getReportShow())) {
                case "0": {
                    abstractComponents.addAll(this.BuildTableLayout(executeContext, themeMapReport));
                    break;
                }
                case "chart": {
                    AbstractComponent eChartComponent = this.buildEchartsLayout(executeContext, agileReport, themeMapReport);
                    if (eChartComponent == null) break;
                    abstractComponents.add(eChartComponent);
                    break;
                }
                case "2": {
                    AbstractComponent index = this.buildIndexLayout(executeContext, themeMapReport);
                    if (index == null) break;
                    abstractComponents.add(index);
                    break;
                }
            }
        }
        return abstractComponents;
    }

    protected abstract AbstractComponent createNoneDataComponent(ThemeMapReport var1, ExecuteContext var2, DynamicAgileData var3);

    private void buildMobileDSL(DynamicAgileData dynamicAgileData, List<AbstractComponent> abstractComponents, ExecuteContext executeContext, AgileReport agileReport) {
        MobileDSLAgileComponent mobileDSLAgileComponent = new MobileDSLAgileComponent();
        Map agileData = executeContext.getAgileData();
        ArrayList mobileDSLAgileDATAList = Lists.newArrayList();
        mobileDSLAgileComponent.setType("dsl_mobileplatform_pagedefine");
        mobileDSLAgileComponent.setData((List)mobileDSLAgileDATAList);
        mobileDSLAgileComponent.setGenerateTime(MapUtils.getString((Map)agileData, (Object)"requestTime"));
        mobileDSLAgileComponent.setData(this.getMobileAgileData(abstractComponents, executeContext, agileReport));
        dynamicAgileData.setLayout((List)Lists.newArrayList((Object[])new AbstractComponent[]{mobileDSLAgileComponent}));
    }

    private List<MobileDSLAgileData> getMobileAgileData(List<AbstractComponent> abstractComponents, ExecuteContext executeContext, AgileReport agileReport) {
        ArrayList datas = Lists.newArrayList();
        for (ThemeMapReport themeMapReport : agileReport.getReport()) {
            switch (ConvertAgileDataUtils.transType((Integer)themeMapReport.getReportShow())) {
                case "0": {
                    List tableComponents = abstractComponents.stream().filter(component -> org.apache.commons.lang3.StringUtils.equals((CharSequence)"TABLE", (CharSequence)component.getType()) && org.apache.commons.lang3.StringUtils.equals((CharSequence)themeMapReport.getDataSource(), (CharSequence)component.getId())).collect(Collectors.toList());
                    datas.addAll(this.buildMobileDSLTable(executeContext, themeMapReport, tableComponents, themeMapReport.getPageData()));
                    break;
                }
                case "chart": {
                    Optional<AbstractComponent> echartOptional = abstractComponents.stream().filter(component -> org.apache.commons.lang3.StringUtils.equals((CharSequence)"ECHARTS", (CharSequence)component.getType()) && org.apache.commons.lang3.StringUtils.equals((CharSequence)themeMapReport.getDataSource(), (CharSequence)component.getId())).findFirst();
                    if (!echartOptional.isPresent()) break;
                    datas.add(this.buildMobileDSLECharts(executeContext, themeMapReport, agileReport, echartOptional.get()));
                    break;
                }
                case "2": {
                    Optional<AbstractComponent> indexOptional = abstractComponents.stream().filter(component -> org.apache.commons.lang3.StringUtils.equals((CharSequence)"STATISTIC", (CharSequence)component.getType()) && org.apache.commons.lang3.StringUtils.equals((CharSequence)themeMapReport.getDataSource(), (CharSequence)component.getId())).findFirst();
                    datas.add(this.buildMobileDSLIndex(themeMapReport, indexOptional.get()));
                    break;
                }
            }
        }
        return datas;
    }

    private List<MobileDSLAgileData> buildMobileDSLTable(ExecuteContext executeContext, ThemeMapReport themeMapReport, List<AbstractComponent> abstractComponents, List<Map<String, Object>> pageData) {
        ArrayList mobileDSLAgileDataList = Lists.newArrayList();
        if (CollectionUtils.isEmpty(abstractComponents)) {
            return Lists.newArrayList();
        }
        String actionId = themeMapReport.getActionId();
        if (org.apache.commons.lang3.StringUtils.isBlank((CharSequence)actionId)) {
            return Lists.newArrayList();
        }
        ApiMetadata apiMetadata = themeMapReport.getApiMetadata();
        abstractComponents.stream().forEach(abstractComponent -> {
            String title = themeMapReport.getTitle();
            MobileDSLAgileData mobileDSLAgileData = new MobileDSLAgileData();
            mobileDSLAgileData.setShowName(title);
            mobileDSLAgileData.setShowCategory(themeMapReport.getReportShow());
            mobileDSLAgileData.setBizDataId(abstractComponent.getId());
            if (CollectionUtils.isNotEmpty((Collection)apiMetadata.getResponseFields())) {
                mobileDSLAgileData.setMetadataFields(apiMetadata.getResponseFields());
            }
            mobileDSLAgileData.setPageData((Object)themeMapReport.getPageData());
            if (abstractComponent instanceof GridComponent) {
                MobileDSLTableRender mobileDSLTableRender = new MobileDSLTableRender();
                Map fieldMap = ConvertGetAgileData.getFiledMap((String)themeMapReport.getDataSource(), (ApiMetadata)apiMetadata);
                ArrayList columns = Lists.newArrayList();
                GridComponent gridComponent = (GridComponent)abstractComponent;
                gridComponent.getColumns().stream().forEach(gridColumnDef -> {
                    MetadataField metadataField = (MetadataField)fieldMap.get(gridColumnDef.getId());
                    AgileDataMobileGridColumnDef agileDataMobileGridColumnDef = new AgileDataMobileGridColumnDef();
                    agileDataMobileGridColumnDef.getMobilelGridColumn(metadataField, themeMapReport.getDataSource(), gridColumnDef.getWidth());
                    columns.add(agileDataMobileGridColumnDef);
                });
                mobileDSLTableRender.setColumns((List)columns);
                mobileDSLAgileData.setTableRenderSetting(mobileDSLTableRender);
            }
            mobileDSLAgileDataList.add(mobileDSLAgileData);
        });
        return mobileDSLAgileDataList;
    }

    private List<AbstractComponent> BuildTableLayout(ExecuteContext executeContext, ThemeMapReport themeMapReport) {
        if (CollectionUtils.isEmpty((Collection)themeMapReport.getPageData())) {
            return Lists.newArrayList();
        }
        String actionId = themeMapReport.getActionId();
        if (org.apache.commons.lang3.StringUtils.isBlank((CharSequence)actionId)) {
            return Lists.newArrayList();
        }
        ApiMetadata apiMetadata = themeMapReport.getApiMetadata();
        ApiMetadataUtil.flatMetaData((ApiMetadata)apiMetadata);
        this.sinSpecialTagToMetadata(apiMetadata);
        this.agileReportRuleService.buildTableDataRule(themeMapReport.getPageData(), themeMapReport.getAgileRule());
        return this.createTopReport(executeContext, themeMapReport);
    }

    private void sinSpecialTagToMetadata(ApiMetadata apiMetadata) {
        List responseMetadataFields = apiMetadata.getResponseFields();
        this.signSpecialTag(responseMetadataFields);
    }

    private void signSpecialTag(List<MetadataField> metadataFields) {
        if (CollectionUtils.isEmpty(metadataFields)) {
            return;
        }
        for (MetadataField metadataField : metadataFields) {
            if ("date".equals(metadataField.getDataType())) {
                metadataField.setDataType("string");
            }
            if ("datetime".equals(metadataField.getDataType())) {
                metadataField.setDataType("string");
            }
            if (!CollectionUtils.isNotEmpty((Collection)metadataField.getSubFields())) continue;
            this.signSpecialTag(metadataField.getSubFields());
        }
    }

    private MobileDSLAgileData buildMobileDSLECharts(ExecuteContext executeContext, ThemeMapReport themeMapReport, AgileReport agileReport, AbstractComponent abstractComponent) {
        MobileDSLAgileData mobileDSLAgileData = new MobileDSLAgileData();
        if (themeMapReport == null) {
            return mobileDSLAgileData;
        }
        String actionId = themeMapReport.getDataSource();
        if (org.apache.commons.lang3.StringUtils.isBlank((CharSequence)actionId)) {
            return mobileDSLAgileData;
        }
        ApiMetadata apiMetadata = themeMapReport.getApiMetadata();
        BuildContext buildContext = this.createBuildContext(themeMapReport, agileReport, executeContext);
        mobileDSLAgileData.setShowName(themeMapReport.getECharts().getTitle());
        mobileDSLAgileData.setShowCategory(Integer.valueOf(1));
        mobileDSLAgileData.setBizDataId(abstractComponent.getId());
        if (CollectionUtils.isNotEmpty((Collection)apiMetadata.getResponseFields())) {
            mobileDSLAgileData.setMetadataFields(apiMetadata.getResponseFields());
        }
        MobileDSLChartRender mobileDSLChartRender = new MobileDSLChartRender();
        mobileDSLChartRender.setTitle(themeMapReport.getECharts().getTitle());
        if (MOBILE_WEB_CHART_TYPE.contains(themeMapReport.getReportShow())) {
            if (abstractComponent instanceof EchartsComponent) {
                EchartsComponent echartsComponent = (EchartsComponent)abstractComponent;
                mobileDSLChartRender.setChartType(AgileReportChartTypeEnum.getTypeByValue((Integer)themeMapReport.getReportShow()));
                mobileDSLChartRender.setSourceChartType(mobileDSLChartRender.getChartType());
                mobileDSLChartRender.setOption(echartsComponent.getOption());
            }
        } else {
            ChartBuildBase chartBuildBase = (ChartBuildBase)SpringUtil.getBean((String)("chart_" + themeMapReport.getECharts().getChartType()), ChartBuildBase.class);
            ChartBase chartBase = chartBuildBase.buildChartParams(buildContext);
            ChartBaseSeries chartBaseSeries = new ChartBaseSeries();
            if (CollectionUtils.isNotEmpty((Collection)chartBase.getChartBaseSeries())) {
                chartBaseSeries = (ChartBaseSeries)chartBase.getChartBaseSeries().get(0);
            }
            mobileDSLChartRender.setSourceChartType(AgileReportChartTypeEnum.getTypeByValue((Integer)chartBase.getSourceChartType()));
            mobileDSLChartRender.setChartType(chartBaseSeries.getType());
            mobileDSLChartRender.setPoints(chartBaseSeries.getPoints());
            Map fieldMap = ConvertGetAgileData.getAgileData((String)themeMapReport.getDataSourceName(), (ApiMetadata)themeMapReport.getApiMetadata());
            MetadataField pointField = (MetadataField)fieldMap.get(((Point)chartBaseSeries.getPoints().stream().findFirst().get()).getName());
            ArrayList dslChartValues = Lists.newArrayList();
            block0: for (int i = 0; i < chartBase.getChartBaseSeries().size(); ++i) {
                ChartBaseSeries dslSeries = (ChartBaseSeries)chartBase.getChartBaseSeries().get(i);
                if (!CollectionUtils.isNotEmpty((Collection)dslSeries.getValues())) continue;
                for (Value value : dslSeries.getValues()) {
                    MobileDSLChartRender.DSLChartValue dslChartValue = new MobileDSLChartRender.DSLChartValue();
                    dslChartValue.setTitle(value.getTitle());
                    dslChartValue.setName(value.getName());
                    dslChartValue.setDataType(value.getDataType());
                    dslChartValue.setChartType(value.getType());
                    if (org.apache.commons.lang3.StringUtils.isNotEmpty((CharSequence)value.getDescription())) {
                        dslChartValue.setDescription(value.getDescription());
                    }
                    HashMap dslMap = Maps.newHashMap();
                    dslMap.put("decimal", value.getDecimal());
                    dslMap.put("percent", value.getPercent());
                    MetadataField field = (MetadataField)fieldMap.get(dslChartValue.getName());
                    if (field != null) {
                        if (org.apache.commons.lang3.StringUtils.isNotEmpty((CharSequence)field.getBusinessType())) {
                            dslChartValue.setBusinessType(field.getBusinessType());
                        }
                        if (org.apache.commons.lang3.StringUtils.isNotEmpty((CharSequence)field.getDecimalRule())) {
                            dslMap.put("decimalRule", BeanUtil.beanToMap((Object)ConvertAgileDataUtils.getDecimalRule((String)field.getDecimalRule()), (String[])new String[0]));
                        }
                        if (org.apache.commons.lang3.StringUtils.isNotEmpty((CharSequence)field.getUnit())) {
                            dslMap.put("unit", BeanUtil.beanToMap((Object)ConvertAgileDataUtils.getUnitRule((String)field.getUnit()), (String[])new String[0]));
                        }
                    }
                    dslChartValue.setGroup(Integer.valueOf(i));
                    dslChartValue.setFormat((Map)dslMap);
                    dslChartValue.setDimensionData(ConvertGetAgileData.getOriginalField((Integer)0, (MetadataField)field, (MetadataField)pointField, (Map)Maps.newHashMap()));
                    dslChartValue.setMeasurementData(ConvertGetAgileData.getOriginalField((Integer)1, (MetadataField)field, null, (Map)Maps.newHashMap()));
                    dslChartValues.add(dslChartValue);
                    String overAllType = themeMapReport.getECharts().getChartType();
                    if (org.apache.commons.lang3.StringUtils.equals((CharSequence)"mixed", (CharSequence)overAllType) || !org.apache.commons.lang3.StringUtils.equals((CharSequence)"pie", (CharSequence)value.getType())) continue;
                    continue block0;
                }
            }
            mobileDSLChartRender.setValues((List)dslChartValues);
            ArrayList measurePresents = Lists.newArrayList();
            measurePresents.addAll(this.getAlertShow(mobileDSLChartRender, fieldMap, themeMapReport.getAgileRule()));
            measurePresents.addAll(this.getGrowthRate(mobileDSLChartRender, fieldMap, themeMapReport.getAgileRule()));
            mobileDSLChartRender.setMeasurePresents((List)measurePresents);
            mobileDSLChartRender.setMarkLine(this.getMarkLine(mobileDSLChartRender, chartBase, themeMapReport.getAgileRule(), fieldMap));
        }
        mobileDSLAgileData.setChartRenderSetting(mobileDSLChartRender);
        mobileDSLAgileData.setPageData((Object)themeMapReport.getPageData());
        return mobileDSLAgileData;
    }

    private Map<String, Object> getMarkLine(MobileDSLChartRender mobileDSLChartRender, ChartBase chartBase, List<AgileReportRuleDTO> agileRules, Map<String, MetadataField> fieldMap) {
        HashMap markMap = Maps.newHashMap();
        if (!CHART_TYPE.contains(mobileDSLChartRender.getChartType())) {
            return markMap;
        }
        if (CollectionUtils.isEmpty(agileRules)) {
            return markMap;
        }
        ChartBaseSeries chartBaseSeries = new ChartBaseSeries();
        if (CollectionUtils.isNotEmpty((Collection)chartBase.getChartBaseSeries())) {
            chartBaseSeries = (ChartBaseSeries)chartBase.getChartBaseSeries().get(0);
        }
        Optional<AgileReportRuleDTO> agileReportRuleOpt = agileRules.stream().filter(x -> org.apache.commons.lang3.StringUtils.equals((CharSequence)"markLine", (CharSequence)x.getType())).findFirst();
        chartBaseSeries.getValues().stream().forEach(value -> {
            if (agileReportRuleOpt.isPresent()) {
                Map<String, List<AgileReportRuleInfoDTO>> ruleMap;
                ArrayList markLineList = Lists.newArrayList();
                AgileReportRuleDTO agileReportRule = (AgileReportRuleDTO)agileReportRuleOpt.get();
                String schemaName = value.getTitle();
                MetadataField markLineField = new MetadataField();
                for (MetadataField metadataField : fieldMap.values()) {
                    if (!org.apache.commons.lang3.StringUtils.equals((CharSequence)schemaName, (CharSequence)metadataField.getDescription())) continue;
                    markLineField = metadataField;
                    break;
                }
                List<AgileReportRuleInfoDTO> agileDataRules = null;
                if (CollectionUtils.isNotEmpty((Collection)agileReportRule.getRules()) && MapUtils.isNotEmpty(ruleMap = agileReportRule.getRules().stream().filter(t -> StringUtils.isNotEmpty((String)t.getApplyToField())).collect(Collectors.groupingBy(AgileReportRuleInfoDTO::getApplyToField))) && ruleMap.containsKey(markLineField.getName())) {
                    agileDataRules = ruleMap.get(markLineField.getName());
                }
                if (CollectionUtils.isNotEmpty(agileDataRules)) {
                    agileDataRules.stream().forEach(rule -> {
                        switch (rule.getType()) {
                            case "avg": {
                                HashMap avgMap = Maps.newHashMap();
                                avgMap.put("type", "average");
                                avgMap.put("name", rule.getName());
                                avgMap.put("applyToValueField", value.getName());
                                markLineList.add(avgMap);
                                break;
                            }
                            case "max": {
                                HashMap maxMap = Maps.newHashMap();
                                maxMap.put("type", "max");
                                maxMap.put("name", rule.getName());
                                maxMap.put("applyToValueField", value.getName());
                                markLineList.add(maxMap);
                                break;
                            }
                            case "min": {
                                HashMap minMap = Maps.newHashMap();
                                minMap.put("type", "min");
                                minMap.put("name", rule.getName());
                                minMap.put("applyToValueField", value.getName());
                                markLineList.add(minMap);
                                break;
                            }
                        }
                    });
                }
                if (CollectionUtils.isNotEmpty((Collection)markLineList)) {
                    markMap.put("data", markLineList);
                }
            }
        });
        return markMap;
    }

    private List<MobileDSLChartMeasure> getAlertShow(MobileDSLChartRender mobileDSLChartRender, Map<String, MetadataField> fieldMap, List<AgileReportRuleDTO> agileRules) {
        ArrayList measures = Lists.newArrayList();
        if (!CHART_TYPE.contains(mobileDSLChartRender.getChartType())) {
            return measures;
        }
        if (CollectionUtils.isEmpty(agileRules)) {
            return measures;
        }
        List showRules = agileRules.stream().filter(x -> org.apache.commons.lang3.StringUtils.equals((CharSequence)"alertShow", (CharSequence)x.getType())).collect(Collectors.toList());
        if (CollectionUtils.isNotEmpty(showRules)) {
            showRules.stream().forEach(agileReportRule -> agileReportRule.getRules().stream().forEach(rule -> {
                MobileDSLChartAlertShow mobileDSLChartAlertShow = new MobileDSLChartAlertShow();
                mobileDSLChartAlertShow.setFormulationId("highlightShow");
                mobileDSLChartAlertShow.setParams(rule);
                MetadataField metadataField = (MetadataField)fieldMap.get(rule.getApplyToField());
                HashMap format = Maps.newHashMap();
                this.buildFormat((Map)format, metadataField);
                mobileDSLChartAlertShow.setFormat((Map)format);
                measures.add(mobileDSLChartAlertShow);
            }));
        }
        return measures;
    }

    private List<MobileDSLChartMeasure> getGrowthRate(MobileDSLChartRender mobileDSLChartRender, Map<String, MetadataField> fieldMap, List<AgileReportRuleDTO> agileRules) {
        ArrayList measures = Lists.newArrayList();
        if (!CHART_TYPE.contains(mobileDSLChartRender.getChartType())) {
            return measures;
        }
        if (CollectionUtils.isEmpty(agileRules)) {
            return measures;
        }
        List showRules = agileRules.stream().filter(x -> org.apache.commons.lang3.StringUtils.equals((CharSequence)"growthRate", (CharSequence)x.getType())).collect(Collectors.toList());
        if (CollectionUtils.isNotEmpty(showRules)) {
            showRules.stream().forEach(agileReportRule -> agileReportRule.getRules().stream().forEach(rule -> {
                MobileDSLChartGrowth mobileDSLChartGrowth = new MobileDSLChartGrowth();
                mobileDSLChartGrowth.setFormulationId("growth_rate");
                MobileDSLChartGrowthField mobileDSLChartAlertShow = new MobileDSLChartGrowthField();
                mobileDSLChartAlertShow.setPreviousField(rule.getPreviousField());
                mobileDSLChartAlertShow.setNowField(rule.getNowField());
                mobileDSLChartAlertShow.setApplyToField(rule.getApplyToField());
                mobileDSLChartGrowth.setParams(mobileDSLChartAlertShow);
                MetadataField metadataField = (MetadataField)fieldMap.get(rule.getApplyToField());
                HashMap format = Maps.newHashMap();
                this.buildFormat((Map)format, metadataField);
                mobileDSLChartGrowth.setFormat((Map)format);
                measures.add(mobileDSLChartGrowth);
            }));
        }
        return measures;
    }

    private void buildFormat(Map<String, Object> format, MetadataField metadataField) {
        if (metadataField != null) {
            format.put("decimal", metadataField.getDecimal());
            format.put("percent", metadataField.getPercent());
            if (org.apache.commons.lang3.StringUtils.isNotEmpty((CharSequence)metadataField.getDecimalRule())) {
                format.put("decimalRule", BeanUtil.beanToMap((Object)ConvertAgileDataUtils.getDecimalRule((String)metadataField.getDecimalRule()), (String[])new String[0]));
            }
            if (org.apache.commons.lang3.StringUtils.isNotEmpty((CharSequence)metadataField.getUnit())) {
                format.put("unit", BeanUtil.beanToMap((Object)ConvertAgileDataUtils.getUnitRule((String)metadataField.getUnit()), (String[])new String[0]));
            }
        }
    }

    private MobileDSLAgileData buildMobileDSLIndex(ThemeMapReport themeMapReport, AbstractComponent abstractComponent) {
        MobileDSLAgileData mobileDSLAgileData = new MobileDSLAgileData();
        mobileDSLAgileData.setShowName(themeMapReport.getTitle());
        String actionId = themeMapReport.getActionId();
        if (org.apache.commons.lang3.StringUtils.isBlank((CharSequence)actionId)) {
            return mobileDSLAgileData;
        }
        ApiMetadata apiMetadata = themeMapReport.getApiMetadata();
        mobileDSLAgileData.setShowCategory(themeMapReport.getReportShow());
        mobileDSLAgileData.setBizDataId(abstractComponent.getId());
        if (CollectionUtils.isNotEmpty((Collection)apiMetadata.getResponseFields())) {
            mobileDSLAgileData.setMetadataFields(apiMetadata.getResponseFields());
        }
        List pageDataList = themeMapReport.getPageData();
        mobileDSLAgileData.setPageData((Object)pageDataList);
        MobileDSLIndexRender mobileDSLIndexRender = new MobileDSLIndexRender();
        mobileDSLIndexRender.setIndexTitle(themeMapReport.getTitle());
        ArrayList indexList = Lists.newArrayList();
        Map filedMap = ConvertGetAgileData.getAgileData((String)themeMapReport.getDataSource(), (ApiMetadata)apiMetadata);
        for (AgileReportIndex.AgileDataDefineIndex index : themeMapReport.getAgileReportIndex().getIndexes()) {
            MobileDSLIndexRender.MobileDSLIndex mobileDSLIndex = new MobileDSLIndexRender.MobileDSLIndex();
            MetadataField metadataField = (MetadataField)filedMap.get(index.getTitle().getApplyToField());
            mobileDSLIndex.setTitle(metadataField.getDescription());
            mobileDSLIndex.setDecimal(metadataField.getDecimal());
            mobileDSLIndex.setPercent(metadataField.getPercent());
            if (CollectionUtils.isNotEmpty((Collection)pageDataList)) {
                Map pageMap = (Map)pageDataList.get(0);
                mobileDSLIndex.setValue(MapUtils.getString((Map)pageMap, (Object)index.getValue().getApplyToField()));
                mobileDSLIndex.setDimensionData(ConvertGetAgileData.getOriginalField((Integer)0, (MetadataField)metadataField, null, (Map)pageMap));
                mobileDSLIndex.setMeasurementData(ConvertGetAgileData.getOriginalField((Integer)1, (MetadataField)metadataField, null, (Map)pageMap));
            }
            if (org.apache.commons.lang3.StringUtils.isNotEmpty((CharSequence)metadataField.getBusinessType())) {
                mobileDSLIndex.setBusinessType(metadataField.getBusinessType());
            }
            if (org.apache.commons.lang3.StringUtils.isNotEmpty((CharSequence)metadataField.getExplanation())) {
                mobileDSLIndex.setDescription(this.messageUtils.getMessage("agileData.description") + metadataField.getExplanation());
            }
            if (org.apache.commons.lang3.StringUtils.isNotEmpty((CharSequence)metadataField.getDecimalRule())) {
                mobileDSLIndex.setDecimalRule(BeanUtil.beanToMap((Object)ConvertAgileDataUtils.getDecimalRule((String)metadataField.getDecimalRule()), (String[])new String[0]));
            }
            if (org.apache.commons.lang3.StringUtils.isNotEmpty((CharSequence)metadataField.getUnit())) {
                mobileDSLIndex.setUnit(BeanUtil.beanToMap((Object)ConvertAgileDataUtils.getUnitRule((String)metadataField.getUnit()), (String[])new String[0]));
            }
            indexList.add(mobileDSLIndex);
        }
        mobileDSLIndexRender.setIndexSetting((List)indexList);
        mobileDSLAgileData.setMobileDSLIndexRender(mobileDSLIndexRender);
        return mobileDSLAgileData;
    }

    private AbstractComponent buildIndexLayout(ExecuteContext executeContext, ThemeMapReport themeMapReport) {
        AbstractComponent index = new AbstractComponent();
        AgileReportIndex agileReportIndex = themeMapReport.getAgileReportIndex();
        BuildContext buildContext = this.createBuildContext(themeMapReport, null, executeContext);
        if (agileReportIndex != null && CollectionUtils.isNotEmpty((Collection)agileReportIndex.getIndexes())) {
            return this.agileDataIndexComponentImpl.createComponent(ConvertGetAgileData.getRootMetadataField((ApiMetadata)themeMapReport.getApiMetadata()), buildContext);
        }
        return index;
    }

    private AbstractComponent buildCardLayout(ExecuteContext executeContext, ThemeMapReport themeMapReport) {
        BuildContext buildContext = this.createBuildContext(themeMapReport, null, executeContext);
        return this.agileDataCardInterpreter.interpreter(themeMapReport, buildContext);
    }

    private AbstractComponent buildEchartsLayout(ExecuteContext executeContext, AgileReport agileReport, ThemeMapReport themeMapReport) {
        if (CollectionUtils.isEmpty((Collection)themeMapReport.getPageData())) {
            return null;
        }
        BuildContext buildContext = this.createBuildContext(themeMapReport, agileReport, executeContext);
        return this.echartsComponent.createComponent(null, buildContext);
    }

    private List<AbstractComponent> createTopReport(ExecuteContext executeContext, ThemeMapReport themeMapReport) {
        ArrayList<AbstractComponent> components = new ArrayList<AbstractComponent>();
        if (themeMapReport.getApiMetadata() != null) {
            BuildContext buildContext = this.createBuildContext(themeMapReport, null, executeContext);
            themeMapReport.getApiMetadata().getResponseFields().stream().forEach(metadataField -> components.add(this.gridComponent.createComponent(metadataField, buildContext)));
        }
        return components;
    }

    private BuildContext createBuildContext(ThemeMapReport themeMapReport, AgileReport agileReport, ExecuteContext executeContext) {
        BuildContext buildContext = new BuildContext();
        buildContext.setExecuteContext(executeContext);
        buildContext.setThemeMapReport(themeMapReport);
        buildContext.setAgileReport(agileReport);
        return buildContext;
    }
}

