/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.athena.show.util.layout;

import com.digiwin.athena.agiledataecho.domain.AIBoardScrumBIShowTypeEnum;
import com.digiwin.athena.agiledataecho.dto.aiBoard.AIBoardLayout;
import com.digiwin.athena.agiledataecho.dto.aiBoard.AIBoardQuestionDTO;
import com.digiwin.athena.agiledataecho.dto.aiBoard.EchoAIBoardDTO;
import com.digiwin.athena.agiledataecho.dto.aiBoard.EchoAIBoardLayoutDTO;
import com.digiwin.athena.show.util.layout.BoardLayoutPlanner;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.Deque;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import org.apache.commons.collections.CollectionUtils;

/*
 * Exception performing whole class analysis ignored.
 */
public final class BoardLayoutPlanner {
    private BoardLayoutPlanner() {
    }

    public static AIBoardLayout plan(List<Seed> seeds, int layoutCols, int initialLayoutRows) {
        Deque q;
        AIBoardLayout layout = new AIBoardLayout();
        AIBoardLayout.layoutAll overall = new AIBoardLayout.layoutAll();
        overall.setLayoutCols(Integer.valueOf(layoutCols));
        overall.setLayoutRows(Integer.valueOf(initialLayoutRows));
        layout.setOverallLayout(overall);
        if (seeds == null || seeds.isEmpty()) {
            layout.setCharts(new ArrayList());
            return layout;
        }
        List originalOrder = seeds.stream().map(s -> Objects.toString(s.chartId, "")).collect(Collectors.toList());
        seeds.sort(Comparator.comparingInt(s -> s.row).thenComparingDouble(s -> s.importance));
        int cols = Math.max(1, layoutCols);
        int totalRows = Math.max(6, initialLayoutRows);
        ArrayList<AIBoardLayout.layoutArea> areas = new ArrayList<AIBoardLayout.layoutArea>();
        ArrayList<Placed> placed = new ArrayList<Placed>();
        int[] skyline = new int[cols];
        int i = 0;
        while (i < seeds.size()) {
            int currentRow = seeds.get((int)i).row;
            ArrayList group = new ArrayList();
            while (i < seeds.size() && seeds.get((int)i).row == currentRow) {
                group.add(seeds.get(i));
                ++i;
            }
            int groupFloor = BoardLayoutPlanner.currentMax((int[])skyline);
            ArrayList<Seed> arrayList = new ArrayList<Seed>();
            ArrayList<Seed> metrics = new ArrayList<Seed>();
            Iterator iterator = group.iterator();
            while (iterator.hasNext()) {
                Seed seed = (Seed)iterator.next();
                if (BoardLayoutPlanner.isMetric((String)seed.showType)) {
                    metrics.add(seed);
                    continue;
                }
                arrayList.add(seed);
            }
            arrayList.sort((a, b) -> {
                boolean at = BoardLayoutPlanner.isTable((String)a.showType);
                boolean bt = BoardLayoutPlanner.isTable((String)b.showType);
                if (at && !bt) {
                    return -1;
                }
                if (!at && bt) {
                    return 1;
                }
                return 0;
            });
            for (Seed seed : arrayList) {
                AIBoardLayout.layoutArea area;
                Size base = BoardLayoutPlanner.decideBaseSize((String)seed.showType);
                boolean isChart = BoardLayoutPlanner.isChart((String)seed.showType);
                int w = base.w;
                int h = base.h;
                if (BoardLayoutPlanner.isTable((String)seed.showType)) {
                    w = cols;
                }
                if (isChart && metrics.isEmpty() && arrayList.size() == 1) {
                    w = cols;
                    h = 6;
                    Pos p = new Pos(0, groupFloor);
                    BoardLayoutPlanner.place((int[])skyline, (int)p.x, (int)p.y, (int)w, (int)h);
                    totalRows = Math.max(totalRows, BoardLayoutPlanner.currentMax((int[])skyline));
                    area = BoardLayoutPlanner.buildArea((Seed)seed, (int)p.x, (int)p.y, (int)w, (int)h);
                    areas.add(area);
                    placed.add(new Placed(area, seed.showType, p.x, p.y, w, h));
                    continue;
                }
                Pos tryBase = BoardLayoutPlanner.findPositionWithFloor((int[])skyline, (int)cols, (int)w, (int)groupFloor);
                BoardLayoutPlanner.place((int[])skyline, (int)tryBase.x, (int)tryBase.y, (int)w, (int)h);
                totalRows = Math.max(totalRows, BoardLayoutPlanner.currentMax((int[])skyline));
                area = BoardLayoutPlanner.buildArea((Seed)seed, (int)tryBase.x, (int)tryBase.y, (int)w, (int)h);
                areas.add(area);
                placed.add(new Placed(area, seed.showType, tryBase.x, tryBase.y, w, h));
            }
            if (!metrics.isEmpty()) {
                AIBoardLayout.layoutArea area;
                int rowY = groupFloor;
                int rowHeight = BoardLayoutPlanner.getRowMaxHeightAtY(placed, (int)rowY);
                boolean placedInSameRow = false;
                if (rowHeight > 0) {
                    int needed = metrics.size() * 2;
                    Segment seg = BoardLayoutPlanner.largestFreeSegmentAtY((int[])skyline, (int)cols, (int)rowY);
                    if (seg.length >= needed) {
                        int cursor = seg.start;
                        for (Seed seed : metrics) {
                            int w = 2;
                            int h = rowHeight;
                            BoardLayoutPlanner.place((int[])skyline, (int)cursor, (int)rowY, (int)w, (int)h);
                            totalRows = Math.max(totalRows, BoardLayoutPlanner.currentMax((int[])skyline));
                            area = BoardLayoutPlanner.buildArea((Seed)seed, (int)cursor, (int)rowY, (int)w, (int)h);
                            areas.add(area);
                            placed.add(new Placed(area, seed.showType, cursor, rowY, w, h));
                            cursor += w;
                        }
                        placedInSameRow = true;
                    }
                }
                if (!placedInSameRow) {
                    int metricFloor = Math.max(BoardLayoutPlanner.currentMax((int[])skyline), groupFloor);
                    for (Seed seed : metrics) {
                        Size base = BoardLayoutPlanner.decideBaseSize((String)seed.showType);
                        int w = base.w;
                        int h = base.h;
                        Pos p = BoardLayoutPlanner.findPositionWithFloor((int[])skyline, (int)cols, (int)w, (int)metricFloor);
                        BoardLayoutPlanner.place((int[])skyline, (int)p.x, (int)p.y, (int)w, (int)h);
                        totalRows = Math.max(totalRows, BoardLayoutPlanner.currentMax((int[])skyline));
                        area = BoardLayoutPlanner.buildArea((Seed)seed, (int)p.x, (int)p.y, (int)w, (int)h);
                        areas.add(area);
                        placed.add(new Placed(area, seed.showType, p.x, p.y, w, h));
                    }
                }
            }
            overall.setLayoutRows(Integer.valueOf(Math.max(totalRows, BoardLayoutPlanner.currentMax((int[])skyline))));
        }
        BoardLayoutPlanner.stretchRowForNonMetrics(placed, (int)cols);
        HashMap<String, Deque> bucket = new HashMap<String, Deque>();
        for (AIBoardLayout.layoutArea a2 : areas) {
            String string = Objects.toString(a2.getChartId(), "");
            bucket.computeIfAbsent(string, k -> new ArrayDeque()).addLast(a2);
        }
        ArrayList<Object> orderedAreas = new ArrayList<Object>(areas.size());
        for (String string : originalOrder) {
            AIBoardLayout.layoutArea a3;
            q = (Deque)bucket.get(string);
            if (q == null || (a3 = (AIBoardLayout.layoutArea)q.pollFirst()) == null) continue;
            orderedAreas.add(a3);
        }
        for (Map.Entry entry : bucket.entrySet()) {
            q = (Deque)entry.getValue();
            while (q != null && !q.isEmpty()) {
                orderedAreas.add(q.pollFirst());
            }
        }
        layout.setCharts(orderedAreas);
        return layout;
    }

    private static AIBoardLayout.layoutArea buildArea(Seed seed, int x, int y, int w, int h) {
        AIBoardLayout.layoutArea area = new AIBoardLayout.layoutArea();
        area.setChartId(seed.chartId);
        area.setShowType(seed.showType);
        area.setTitle(seed.title);
        AIBoardLayout.layoutDimensions dim = new AIBoardLayout.layoutDimensions();
        dim.setAreaCols(Integer.valueOf(w));
        dim.setAreaRow(Integer.valueOf(h));
        area.setDimensions(dim);
        AIBoardLayout.layoutIndex col = new AIBoardLayout.layoutIndex();
        col.setStart(Integer.valueOf(x));
        col.setEnd(Integer.valueOf(x + w));
        AIBoardLayout.layoutIndex row = new AIBoardLayout.layoutIndex();
        row.setStart(Integer.valueOf(y));
        row.setEnd(Integer.valueOf(y + h));
        AIBoardLayout.layoutPosition pos = new AIBoardLayout.layoutPosition();
        pos.setLayoutCol(col);
        pos.setLayoutRow(row);
        area.setPosition(pos);
        return area;
    }

    private static boolean isTable(String showType) {
        return Objects.equals(showType, "0");
    }

    private static boolean isMetric(String showType) {
        return Objects.equals(showType, "2");
    }

    private static boolean isChart(String showType) {
        return !BoardLayoutPlanner.isTable((String)showType) && !BoardLayoutPlanner.isMetric((String)showType);
    }

    private static Size decideBaseSize(String showType) {
        if (BoardLayoutPlanner.isTable((String)showType)) {
            return new Size(12, 6);
        }
        if (BoardLayoutPlanner.isMetric((String)showType)) {
            return new Size(2, 2);
        }
        return new Size(6, 4);
    }

    private static void place(int[] skyline, int x, int y, int w, int h) {
        for (int i = x; i < x + w; ++i) {
            skyline[i] = y + h;
        }
    }

    private static int currentMax(int[] skyline) {
        int m = 0;
        for (int v : skyline) {
            m = Math.max(m, v);
        }
        return m;
    }

    private static Pos findPositionWithFloor(int[] skyline, int cols, int w, int floor) {
        if (w > cols) {
            return null;
        }
        int bestX = 0;
        int bestY = Integer.MAX_VALUE;
        for (int x = 0; x <= cols - w; ++x) {
            int y = 0;
            for (int i = x; i < x + w; ++i) {
                y = Math.max(y, skyline[i]);
            }
            if ((y = Math.max(y, floor)) >= bestY) continue;
            bestY = y;
            bestX = x;
        }
        return new Pos(bestX, bestY);
    }

    private static boolean rowIsEmptyAtFloor(int[] skyline, int cols, int floor) {
        for (int i = 0; i < cols; ++i) {
            if (skyline[i] <= floor) continue;
            return false;
        }
        return true;
    }

    private static int getRowMaxHeightAtY(List<Placed> placed, int y) {
        int h = 0;
        for (Placed p : placed) {
            if (p.y != y) continue;
            h = Math.max(h, p.h);
        }
        return h;
    }

    private static Segment largestFreeSegmentAtY(int[] skyline, int cols, int y) {
        int bestStart = -1;
        int bestLen = 0;
        int curStart = -1;
        int curLen = 0;
        for (int i = 0; i < cols; ++i) {
            if (skyline[i] <= y) {
                if (curStart == -1) {
                    curStart = i;
                    curLen = 1;
                    continue;
                }
                ++curLen;
                continue;
            }
            if (curLen > bestLen) {
                bestLen = curLen;
                bestStart = curStart;
            }
            curStart = -1;
            curLen = 0;
        }
        if (curLen > bestLen) {
            bestLen = curLen;
            bestStart = curStart;
        }
        if (bestStart == -1) {
            return new Segment(0, 0);
        }
        return new Segment(bestStart, bestLen);
    }

    private static void stretchRowForNonMetrics(List<Placed> placed, int cols) {
        for (Placed p : placed) {
            if (p == null || Objects.equals(p.showType, "2") || Objects.equals(p.showType, "0") || p.x != 0) continue;
            int yStart = p.y;
            int yEnd = p.y + p.h;
            int obstacleX = cols;
            for (Placed q : placed) {
                if (q == p) continue;
                int qY1 = q.y;
                int qY2 = q.y + q.h;
                boolean overlapY = qY1 < yEnd && qY2 > yStart;
                if (!overlapY || q.x < p.x + p.w) continue;
                obstacleX = Math.min(obstacleX, q.x);
            }
            int newW = Math.max(p.w, obstacleX - p.x);
            if (newW <= p.w) continue;
            p.w = newW;
            AIBoardLayout.layoutDimensions dim = new AIBoardLayout.layoutDimensions();
            dim.setAreaCols(Integer.valueOf(p.w));
            dim.setAreaRow(Integer.valueOf(p.h));
            p.area.setDimensions(dim);
            AIBoardLayout.layoutIndex col = new AIBoardLayout.layoutIndex();
            col.setStart(Integer.valueOf(p.x));
            col.setEnd(Integer.valueOf(p.x + p.w));
            AIBoardLayout.layoutIndex row = new AIBoardLayout.layoutIndex();
            row.setStart(Integer.valueOf(p.y));
            row.setEnd(Integer.valueOf(p.y + p.h));
            AIBoardLayout.layoutPosition pos = new AIBoardLayout.layoutPosition();
            pos.setLayoutCol(col);
            pos.setLayoutRow(row);
            p.area.setPosition(pos);
        }
    }

    public static List<Seed> getSeedList(AIBoardLayout aiBoardLayout, EchoAIBoardDTO echoAIBoardDTO) {
        ArrayList seeds = Lists.newArrayList();
        aiBoardLayout.getCharts().forEach(c -> {
            String chartId = c.getChartId();
            Double importance = c.getImportance() == null ? null : c.getImportance();
            Integer row = c.getRow();
            Integer stVal = null;
            String title = null;
            if (CollectionUtils.isNotEmpty((Collection)echoAIBoardDTO.getQuestionInfo())) {
                for (AIBoardQuestionDTO q : echoAIBoardDTO.getQuestionInfo()) {
                    if (q.getAnalyzeStatus() == null || q.getAnalyzeStatus() != 0 || !String.valueOf(q.getQuestionId()).equals(chartId)) continue;
                    stVal = AIBoardScrumBIShowTypeEnum.getShowTypeValueByBIType((String)q.getShowType());
                    title = q.getChartTitle();
                    break;
                }
            }
            String showTypeStr = stVal != null ? String.valueOf(stVal) : c.getShowType();
            String resolvedTitle = title != null ? title : c.getTitle();
            seeds.add(new Seed(chartId, showTypeStr, resolvedTitle, importance, row));
        });
        return seeds;
    }

    public static AIBoardLayout getAiBoardLayout(List<EchoAIBoardLayoutDTO> layoutDTOList, EchoAIBoardDTO echoAIBoardDTO, AIBoardLayout aiBoardLayout) {
        if (CollectionUtils.isNotEmpty(layoutDTOList)) {
            AIBoardLayout newLayout = new AIBoardLayout();
            AIBoardLayout.layoutAll overall = new AIBoardLayout.layoutAll();
            overall.setLayoutCols(Integer.valueOf(12));
            overall.setLayoutRows(Integer.valueOf(24));
            newLayout.setOverallLayout(overall);
            ArrayList charts = Lists.newArrayList();
            List qs = echoAIBoardDTO.getQuestionInfo();
            HashMap qMap = qs == null ? Maps.newHashMap() : qs.stream().collect(Collectors.toMap(AIBoardQuestionDTO::getQuestionId, v -> v, (a, b) -> a));
            int groupRow = 1;
            for (EchoAIBoardLayoutDTO seg : layoutDTOList) {
                List summary = seg.getSummary();
                List details = seg.getDetails();
                if (CollectionUtils.isNotEmpty((Collection)summary)) {
                    int n = summary.size();
                    for (int idx = 0; idx < n; ++idx) {
                        Long sid = (Long)summary.get(idx);
                        AIBoardQuestionDTO q = (AIBoardQuestionDTO)qMap.get(sid);
                        if (q == null) continue;
                        AIBoardLayout.layoutArea c = new AIBoardLayout.layoutArea();
                        c.setChartId(String.valueOf(q.getQuestionId()));
                        c.setShowType(String.valueOf(AIBoardScrumBIShowTypeEnum.getShowTypeValueByBIType((String)q.getShowType())));
                        c.setTitle(q.getChartTitle());
                        c.setRow(Integer.valueOf(groupRow));
                        c.setImportance(Double.valueOf(1.0 + (double)(idx + 1) * 1.0E-4));
                        charts.add(c);
                    }
                }
                int lastDetailGroupRow = groupRow++;
                if (!CollectionUtils.isNotEmpty((Collection)details)) continue;
                int detailGroupRow = groupRow + 1;
                int remaining = 12;
                int n = details.size();
                for (int idx = 0; idx < n; ++idx) {
                    Long did = (Long)details.get(idx);
                    AIBoardQuestionDTO q = (AIBoardQuestionDTO)qMap.get(did);
                    if (q == null) continue;
                    String st = String.valueOf(AIBoardScrumBIShowTypeEnum.getShowTypeValueByBIType((String)q.getShowType()));
                    int width = BoardLayoutPlanner.computeBaseWidth((String)st);
                    if (remaining < width && remaining != 12) {
                        ++detailGroupRow;
                        remaining = 12;
                    }
                    AIBoardLayout.layoutArea c = new AIBoardLayout.layoutArea();
                    c.setChartId(String.valueOf(q.getQuestionId()));
                    c.setShowType(st);
                    c.setTitle(q.getChartTitle());
                    c.setRow(Integer.valueOf(detailGroupRow));
                    c.setImportance(Double.valueOf(1.0 + (double)(idx + 1) * 1.0E-4));
                    charts.add(c);
                    remaining -= Math.min(width, remaining);
                    lastDetailGroupRow = detailGroupRow;
                }
                groupRow = lastDetailGroupRow + 1;
            }
            newLayout.setCharts((List)charts);
            echoAIBoardDTO.setBoardLayout(newLayout);
            aiBoardLayout = newLayout;
        }
        return aiBoardLayout;
    }

    private static int computeBaseWidth(String showType) {
        if ("0".equals(showType)) {
            return 12;
        }
        if ("2".equals(showType)) {
            return 2;
        }
        return 6;
    }
}

