package com.digiwin.athena.agiledataecho.constant;

import com.digiwin.athena.appcore.constant.ErrorTypeEnum;
import com.digiwin.athena.appcore.exception.BusinessException;
import com.digiwin.athena.appcore.util.SpringUtil;
import lombok.Getter;
import org.springframework.context.MessageSource;
import org.springframework.context.i18n.LocaleContextHolder;

/**
 * 错误码定义类
 */
@Getter
public enum ErrorCodeEnum {

    /**
     * 调用中间价报错（中间价没有封装规范格式的错误码）
     * 第3码用于区分不同的中间件，第4码用于表示该组件不同的API
     * <p>
     * P_ECHO_AAM_ERROR("P.ECHO.901.0001","调gmc的api：报错"),
     */

    //调用gmc报错
    GMC_QUERY_ANNOUNCEMENT_LIST_FAIL("P.ECHO.901.0001", "获取GMC公告列表失败"),
    //gmc调用dap翻译报错
    GMC_DAP_TRANSLATORS_FAIL("P.ECHO.901.0002", "GMC调用DAP翻译公告失败"),

    //调用km报错
    KM_QUERY_PURCHASED_AGILE_DATA_APPLICATION_FAIL("P.ECHO.902.0001", "获取KM中租户购买的敏捷数据应用列表失败"),

    KM_QUERY_SCENE_INTENTION_FAIL("P.ECHO.902.0002", "获取KM开场白示例失败"),

    ADE_GET_FILE_URL_FAIL("P.ECHO.903.0001", "获取数据明细失败"),

    ADT_GET_FILE_URL_FAIL("P.ECHO.904.0001", "获取快照信息失败"),

    ADE_GET_USER_CONFIG_FAIL("P.ECHO.905.0001", "获取用户信息失败"),

    ADE_GET_ANALYSIS_URL_FAIL("P.ECHO.906.0001", "获取解析结果失败"),

    ADE_GET_TRANS_DATA_URL_FAIL("P.ECHO.906.0002", "转换数据失败"),

    AGILE_REPORT_EMPTY_DATA("P.ECHO.801.0001","无数据"),

    AGILE_REPORT_DATA_ERROR("P.ECHO.801.0001","解析呈现异常"),

    METADATA_GET_ERROR("P.UIBOT.500.0022","元数据获取异常"),

    IAM_V2_USER("P.ECHO,900.0001","获取用户信息异常"),

    EOC_V2_EMP_ID("P.ECHO,900.0002","获取员工信息异常"),

    IAM_V2_QUERY_USER("P.ECHO,900.0003","获取人员信息异常"),

    EOC_SEARCH_STAFF_INFO_FAIL("P.ECHO.900.0004","查询员工信息失败"),

    EOC_SEARCH_EOC_V2_DEPT_CASCADE_FAIL("P.ECHO.905.0005","查询所有部门信息以及部门下所有员工的信息失败"),

    //调用iam报错
    IAM_GET_USERMETADATA_FAIL("P.ATMC.903.0001","请求aim根据userSid获取租户语言别设置失败，入参：{0}"),

    BOARD_NO_DATA("P.ECHO.807.0001","看板信息不存在");

    /**
     * 错误码
     */
    private String errCode;

    /**
     * 错误描述
     */
    private String errMsg;

    private static MessageSource messageSource;

    static {
        ErrorCodeEnum.messageSource = SpringUtil.getBean(MessageSource.class);
    }

    ErrorCodeEnum(String errCode, String errMsg) {
        this.errCode = errCode;
        this.errMsg = errMsg;
    }

    /**
     * 把 errorCode 作为资源文件的 name ,以支持多语言
     * -- 注意： 一定要在 error 资源包中建立以 errorCode 为 name 的多语言资源。
     * 否则，会使用 errorMsg 来显示。
     *
     * @return
     */
    public BusinessException getBusinessException() {
        return BusinessException.create(this.getErrCode(), ErrorCodeEnum.messageSource.getMessage(this.getErrCode(), null, this.getErrMsg(), LocaleContextHolder.getLocale()));
    }

    /**
     * ErrorCodeEnum转BusinessException
     *
     * @param errorTypeEnum 错误类型枚举
     * @return BusinessException实例
     */
    public BusinessException getBusinessException(ErrorTypeEnum errorTypeEnum) {
        return BusinessException.create(this.getErrCode(), ErrorCodeEnum.messageSource.getMessage(this.getErrCode(), null, this.getErrMsg(), LocaleContextHolder.getLocale()), errorTypeEnum.getValue());
    }

    /**
     * 把 errorCode 作为资源文件的 name ,以支持多语言
     * -- 注意： 一定要在 error 资源包中建立以 errorCode 为 name 的多语言资源。
     * 否则，会使用 errorMsg 来显示。
     * args：message后面需要带的参数
     *
     * @return
     */
    public BusinessException getBusinessExceptionWithArgs(Object... paras) {
        return BusinessException.create(this.getErrCode(), ErrorCodeEnum.messageSource.getMessage(this.getErrCode(), paras, LocaleContextHolder.getLocale()));
    }

    /**
     * ErrorCodeEnum转BusinessException
     *
     * @return BusinessException实例
     */
    public BusinessException getBusinessException(String errorMessage) {
        return BusinessException.create(this.getErrCode(), errorMessage);
    }




}