package com.digiwin.athena.agiledataecho.controller;

import com.digiwin.athena.agiledataecho.proxy.gmc.model.GmcBulletinUnReadSaveDTO;
import com.digiwin.athena.agiledataecho.service.EchoGmcService;
import com.digiwin.athena.appcore.auth.GlobalConstant;
import com.digiwin.athena.appcore.auth.domain.AuthoredUser;
import com.digiwin.athena.appcore.util.ResponseEntityWrapper;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.ResponseEntity;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.*;

/**
 * 敏捷数据获取GMC公告Controller
 *
 * @author yanfeng
 * @date 2024/7/24
 */
@RestController
@RequestMapping(value = "/api/ai/agile/echo/gmc")
public class EchoGmcController {

    @Autowired
    private EchoGmcService echoGmcService;

    @GetMapping("/queryReadBulletinList")
    public ResponseEntity<?> queryReadBulletinList(@RequestParam("pageNum") Integer pageNum, @RequestParam("pageSize") Integer pageSize,
                                                   @RequestAttribute(value = GlobalConstant.AUTH_USER, required = false) AuthoredUser user) {
        return ResponseEntityWrapper.wrapperOk(echoGmcService.queryReadBulletinList(user, pageNum, pageSize));
    }

    @GetMapping("/queryUnreadBulletinList")
    public ResponseEntity<?> queryUnreadBulletinList(@RequestParam("pageNum") Integer pageNum, @RequestParam("pageSize") Integer pageSize,
                                                     @RequestAttribute(value = GlobalConstant.AUTH_USER, required = false) AuthoredUser user) {
        return ResponseEntityWrapper.wrapperOk(echoGmcService.queryUnreadBulletinList(user, pageNum, pageSize));
    }

    @PostMapping("/saveReadBulletin")
    public ResponseEntity<?> saveReadBulletin(@RequestBody @Validated GmcBulletinUnReadSaveDTO saveDTO,
                                              @RequestAttribute(value = GlobalConstant.AUTH_USER, required = false) AuthoredUser user) {
        return ResponseEntityWrapper.wrapperOk(echoGmcService.saveReadBulletin(user, saveDTO));
    }

}