package com.digiwin.athena.agiledataecho.controller;

import com.digiwin.athena.agiledataecho.service.EchoQueryDataDetailService;
import com.digiwin.athena.appcore.auth.GlobalConstant;
import com.digiwin.athena.appcore.auth.domain.AuthoredUser;
import com.digiwin.athena.appcore.util.ResponseEntityWrapper;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.ResponseEntity;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestAttribute;
import org.springframework.web.bind.annotation.RequestMapping;

import javax.servlet.http.HttpServletRequest;

@Controller
@RequestMapping(value = "/api/ai/agile/echo/dataDetail")
public class EchoQueryDataDetailController {

    @Autowired
    private EchoQueryDataDetailService echoQueryDataDetailService;

    @GetMapping("/queryDetail/{snapshotId}")
    public ResponseEntity<?> getExceptionInfoByMessageId(HttpServletRequest request,
                                                         @PathVariable("snapshotId") String snapshotId,
                                                         @RequestAttribute(value = GlobalConstant.AUTH_USER, required = false) AuthoredUser user) {
        String locale = request.getHeader("locale");
        return ResponseEntityWrapper.wrapperOk(echoQueryDataDetailService.getDataDetailUrl(user, snapshotId, locale));
    }

}
