package com.digiwin.athena.agiledataecho.controller;

import com.digiwin.athena.agiledataecho.dto.EchoSchemaElReqDTO;
import com.digiwin.athena.agiledataecho.service.EchoSchemaElService;
import com.digiwin.athena.appcore.auth.GlobalConstant;
import com.digiwin.athena.appcore.auth.domain.AuthoredUser;
import com.digiwin.athena.appcore.util.ResponseEntityWrapper;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.ResponseEntity;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.*;

/**
 * @Author: SunHong
 * @Date: 2024/8/5 15:51
 * @Description:
 */
@RestController
@RequestMapping(value = "/api/ai/agile/echo/schema")
public class EchoSchemaElementController {

    @Autowired
    private EchoSchemaElService echoSchemaElService;

    @PostMapping("/submit")
    public ResponseEntity<?> submit(@RequestBody @Validated EchoSchemaElReqDTO reqDTO,
                                    @RequestAttribute(value = GlobalConstant.AUTH_USER, required = false) AuthoredUser user) {
        echoSchemaElService.submit(reqDTO,user);
        return ResponseEntityWrapper.wrapperOk();
    }

    /**
     * 通过snapshotId和userId查询快照信息
     */
    @GetMapping("/queryInfo/{messageId}")
    public ResponseEntity<?> getExceptionInfoByMessageId(@PathVariable("messageId") String messageId,
                                                         @RequestAttribute(value = GlobalConstant.AUTH_USER, required = false) AuthoredUser user) {
        return ResponseEntityWrapper.wrapperOk(echoSchemaElService.getSchemaElInfoByMessageId(messageId,user));
    }

    @GetMapping("/getInfoAndSchema/{messageId}")
    public ResponseEntity<?> getInfoAndSchema(@PathVariable("messageId") String messageId,
                                              @RequestAttribute(value = GlobalConstant.AUTH_USER, required = false) AuthoredUser user) {
        return ResponseEntityWrapper.wrapperOk(echoSchemaElService.getInfoAndSchema(messageId,user));
    }
}
