package com.digiwin.athena.agiledataecho.domain;

import com.baomidou.mybatisplus.annotation.IdType;
import com.baomidou.mybatisplus.annotation.TableId;
import com.baomidou.mybatisplus.annotation.TableName;
import lombok.AllArgsConstructor;
import lombok.Data;
import lombok.NoArgsConstructor;

import java.io.Serializable;
import java.util.Date;

/**
 * 敏捷数据公告已读记录表
 *
 * @author yanfeng
 * @date 2024/7/23
 */
@Data
@NoArgsConstructor
@AllArgsConstructor
@TableName("echo_bulletin_read_record")
public class EchoBulletinReadRecord implements Serializable {

    private static final long serialVersionUID = 119298889156103705L;
    @TableId(value = "id", type = IdType.AUTO)
    private long id;

    private String userId;

    private String tenantId;

    private String sid;

    private Date createDate;

    public EchoBulletinReadRecord(String userId, String tenantId, String sid) {
        this.userId = userId;
        this.tenantId = tenantId;
        this.sid = sid;
    }

}