package com.digiwin.athena.agiledataecho.domain;


import com.baomidou.mybatisplus.annotation.IdType;
import com.baomidou.mybatisplus.annotation.TableId;
import com.baomidou.mybatisplus.annotation.TableName;
import lombok.AllArgsConstructor;
import lombok.Data;
import lombok.NoArgsConstructor;

import java.time.LocalDateTime;

/**
 * 敏数体验次数
 */
@Data
@NoArgsConstructor
@AllArgsConstructor
@TableName("echo_lite_charging")
public class EchoCharging {

    @TableId(value = "id", type = IdType.AUTO)
    private long id;

    /**
     * 用户ID
     */
    private String userId;

    /**
     * 用户名称
     */
    private String userName;

    /**
     * 租户ID
     */
    private String tenantId;

    /**
     * 租户名称
     */
    private String tenantName;

    /**
     * 计费类型 lite敏数体验版计费
     */
    private String chargingType;

    /**
     * 剩余次数
     */
    private int chargingRemain;

    /**
     * 总次数
     */
    private int chargingNum;

    /**
     * 生成时间
     */
    private LocalDateTime createDate;

    /**
     * 修改时间
     */
    private LocalDateTime modifyDate;

}
