package com.digiwin.athena.agiledataecho.domain;

import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Data;
import lombok.NoArgsConstructor;

import java.time.LocalDateTime;
import java.util.List;


@Data
@AllArgsConstructor
@NoArgsConstructor
@Builder
public class EocDeptDTO {

    private int code;
    private String message;
    private boolean success;
    private DataObject data;

    @Data
    @AllArgsConstructor
    @NoArgsConstructor
    @Builder
    public static class DataObject{
        private Integer total;
        private List<Dept> list;
    }

    @Data
    @AllArgsConstructor
    @NoArgsConstructor
    @Builder
    public static class Dept {
        private Long sid;
        private String id;
        private String name;
        private String directorId;
        private String directorName;
        private List<EmployeeDTO> emps;
    }

    @Data
    @AllArgsConstructor
    @NoArgsConstructor
    @Builder
    public static class EmployeeDTO{

        private Long sid;
        private String id;
        private String name;
        private Boolean mainDept;
        private Boolean status;
        private String agentId;
        private String agentName;
        private LocalDateTime agentBeginDate;
        private LocalDateTime agentEndDate;

    }
}
