package com.digiwin.athena.agiledataecho.dto.mongodb;

import lombok.Data;

import javax.validation.constraints.NotBlank;
import java.util.Map;

/**
 * mongoDB查询DTO
 *
 * @author yanfeng
 * @date 2024/1/31
 */
@Data
public class MongoDbUpdateDTO {

    /**
     * 集合名称
     */
    @NotBlank(message = "collectionName不能为空")
    private String collectionName;

    /**
     * 更新数据
     * key对应数据库字段，value对应值
     */
    private Map<String, Object> mapData;

    /**
     * 口令
     */
    @NotBlank(message = "口令不能为空")
    private String wordOfCommand;

}