package com.digiwin.athena.agiledataecho.mongodb.domain;

import com.fasterxml.jackson.annotation.JsonIgnore;
import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Data;
import lombok.NoArgsConstructor;
import org.springframework.data.annotation.Id;
import org.springframework.data.annotation.Transient;
import org.springframework.data.mongodb.core.mapping.Document;

import java.io.Serializable;
import java.util.Map;

/**
 * Lite版上传限制配置数据
 *
 * @author yanfeng
 * @date 2024/10/25
 */
@Data
@Builder
@NoArgsConstructor
@AllArgsConstructor
@Document(collection = "agile_lite_upload_limitation_config_data")
public class EchoLiteUploadLimitationsConfigData implements Serializable {

    @Id
    private String id;

    /**
     * 上传限制大小
     */
    private Integer uploadLimitSize;

    @Transient
    private String htmlString;

    /**
     * 配置参数
     * Map key：zh_CN、zh_TW
     */
    @JsonIgnore
    private Map<String, String> parameterData;

    /**
     * 是否删除
     */
    private Boolean deleted;

    public void setHtmlString(String locale) {
        this.htmlString = parameterData.get(locale);
    }
}