package com.digiwin.athena.agiledataecho.mongodb.domain;

import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Data;
import lombok.NoArgsConstructor;
import org.springframework.data.annotation.Id;
import org.springframework.data.mongodb.core.mapping.Document;

import java.util.List;

/**
 * 开场白配置类
 *
 * @author yanfeng
 * @date 2024/7/23
 */
@Data
@Builder
@NoArgsConstructor
@AllArgsConstructor
@Document("agile_opening_remarks_config")
public class EchoOpeningRemarksConfigData {

    @Id
    private String id;

    /**
     * 标题
     */
    private String title;

    /**
     * 封面图标Url
     */
    private String coverUrl;

    /**
     * 内容
     */
    private String content;

    /**
     * 来源端
     * PC端和移动端的产品公告可能有所不同
     * PC, MOBILE
     */
    private List<String> source;

}